/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.MouseAxis;

public abstract class MenuMouse
extends BuildMenu {
    public BuildMenu advancedMenu;
    public MenuSwitch mEnable;
    public MenuSwitch mMenuEnab;
    public MenuSwitch mRawInput;
    public MenuTextField mSens;
    public MenuSlider mTurn;
    public MenuSlider mLook;
    public MenuSlider mMove;
    public MenuSlider mStrafe;
    public MenuSwitch mAiming;
    public MenuSwitch mInvert;
    public MenuButton mAdvance;
    public MenuConteiner mAxisUp;
    public MenuConteiner mAxisDown;
    public MenuConteiner mAxisLeft;
    public MenuConteiner mAxisRight;

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public MenuMouse(BuildGame app, int posx, int posy, int width, int menuHeight, int separatorHeight, Font style, int buttonPal) {
        super(app.pMenu);
        this.addItem(this.getTitle(app, "Mouse setup"), false);
        final GameConfig cfg = app.pCfg;
        this.advancedMenu = this.buildAdvancedAxisMenu(app, posx, posy, width, menuHeight, style);
        this.mEnable = new MenuSwitch("Mouse in game", style, posx, posy += menuHeight, width, cfg.isUseMouse(), new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.setUseMouse(sw.value);
            }
        }, "Yes", "No");
        this.mEnable.pal = buttonPal;
        this.mMenuEnab = new MenuSwitch("Mouse in menu", style, posx, posy += menuHeight, width, cfg.isMenuMouse(), new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.setMenuMouse(sw.value);
            }
        }, "Yes", "No");
        this.mMenuEnab.pal = buttonPal;
        this.mRawInput = new MenuSwitch(this, "Raw Mouse Input", style, posx, posy += menuHeight, width, cfg.isRawInput(), (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            cfg.setRawInput(sw.value);
        }, "Yes", "No"){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, value, callback, onMessage, offMessage);
            }

            @Override
            public void draw(MenuHandler handler) {
                super.draw(handler);
                this.mCheckEnableItem(cfg.isRawInputSupported());
            }
        };
        this.mRawInput.pal = buttonPal;
        posy += separatorHeight;
        this.mSens = new MenuTextField(this, "Mouse Sensitivity", "", style, posx, posy += menuHeight, width, 10, (handler, pItem) -> {
            MenuTextField item = (MenuTextField)pItem;
            String numbers = item.getText();
            double mouseSens = Double.parseDouble(numbers);
            cfg.setgSensitivity((int)(mouseSens * 65536.0));
        }){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, input, font, x, y, width, charFlag, confirmCallback);
            }

            @Override
            public void open() {
                this.setText("" + (float)cfg.getSensitivity() / 65536.0f);
            }
        };
        this.mSens.pal = buttonPal;
        this.mTurn = new MenuSlider(app.pSlider, "Turning speed", style, posx, posy += menuHeight, width, cfg.getgMouseTurnSpeed(), 0, 163840, 4096, (handler, pItem) -> {
            MenuSlider slider = (MenuSlider)pItem;
            cfg.setgMouseTurnSpeed(slider.value);
        }, true);
        this.mTurn.digitalMax = 65536.0f;
        this.mTurn.pal = buttonPal;
        this.mLook = new MenuSlider(app.pSlider, "Aiming up/down speed", style, posx, posy += menuHeight, width, cfg.getgMouseLookSpeed(), 0, 163840, 4096, new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.setgMouseLookSpeed(slider.value);
            }
        }, true);
        this.mLook.digitalMax = 65536.0f;
        this.mLook.pal = buttonPal;
        this.mMove = new MenuSlider(app.pSlider, "Forward/Backward speed", style, posx, posy += menuHeight, width, cfg.getgMouseMoveSpeed(), 0, 163840, 4096, new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.setgMouseMoveSpeed(slider.value);
            }
        }, true);
        this.mMove.digitalMax = 65536.0f;
        this.mMove.pal = buttonPal;
        this.mStrafe = new MenuSlider(app.pSlider, "Strafing speed", style, posx, posy += menuHeight, width, cfg.getgMouseStrafeSpeed(), 0, 163840, 4096, new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSlider slider = (MenuSlider)pItem;
                cfg.setgMouseStrafeSpeed(slider.value);
            }
        }, true);
        this.mStrafe.digitalMax = 65536.0f;
        this.mStrafe.pal = buttonPal;
        posy += separatorHeight;
        this.mAiming = new MenuSwitch("Mouse aiming", style, posx, posy += menuHeight, width, cfg.isgMouseAim(), new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.setgMouseAim(sw.value);
            }
        }, null, null);
        this.mAiming.pal = buttonPal;
        this.mInvert = new MenuSwitch("Invert mouse aim", style, posx, posy += menuHeight, width, cfg.isgInvertmouse(), new MenuProc(){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                cfg.setgInvertmouse(sw.value);
            }
        }, null, null);
        this.mInvert.pal = buttonPal;
        this.mAdvance = new MenuButton("Digital axis setup", style, posx, (posy += separatorHeight) + menuHeight, width, 1, buttonPal, this.advancedMenu, -1, null, 0);
        this.addItem(this.mEnable, true);
        this.addItem(this.mMenuEnab, false);
        this.addItem(this.mRawInput, false);
        this.addItem(this.mSens, false);
        this.addItem(this.mTurn, false);
        this.addItem(this.mLook, false);
        this.addItem(this.mMove, false);
        this.addItem(this.mStrafe, false);
        this.addItem(this.mAiming, false);
        this.addItem(this.mInvert, false);
        this.addItem(this.mAdvance, false);
    }

    protected BuildMenu buildAdvancedAxisMenu(BuildGame app, int posx, int posy, int width, int menuHeight, Font style) {
        BuildMenu advancedMenu = new BuildMenu(app.pMenu);
        advancedMenu.addItem(this.getTitle(app, "Digital axis"), false);
        final GameConfig cfg = app.pCfg;
        final GameKey[] gameKeys = cfg.getKeymap();
        char[][] keymaplist = new char[gameKeys.length + 1][];
        keymaplist[0] = "None".toCharArray();
        for (int i = 1; i < keymaplist.length; ++i) {
            keymaplist[i] = gameKeys[i - 1].getName().toCharArray();
        }
        this.mAxisUp = new MenuConteiner(this, "Digital up", style, posx, posy += 10, width, null, 0, null){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.num = Gameutils.arrayIndexOf(gameKeys, i -> gameKeys[i].equals(cfg.getMouseAxis(MouseAxis.UP))) + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return this.this$0.mAdvancedCallback(handler, cfg, this, opt, MouseAxis.UP);
            }
        };
        this.mAxisDown = new MenuConteiner(this, "Digital down", style, posx, posy += 10, width, null, 0, null){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.num = Gameutils.arrayIndexOf(gameKeys, i -> gameKeys[i].equals(cfg.getMouseAxis(MouseAxis.DOWN))) + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return this.this$0.mAdvancedCallback(handler, cfg, this, opt, MouseAxis.DOWN);
            }
        };
        this.mAxisLeft = new MenuConteiner(this, "Digital left", style, posx, posy += 10, width, null, 0, null){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.num = Gameutils.arrayIndexOf(gameKeys, i -> gameKeys[i].equals(cfg.getMouseAxis(MouseAxis.LEFT))) + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return this.this$0.mAdvancedCallback(handler, cfg, this, opt, MouseAxis.LEFT);
            }
        };
        this.mAxisRight = new MenuConteiner(this, "Digital right", style, posx, posy += 10, width, null, 0, null){
            final /* synthetic */ MenuMouse this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.num = Gameutils.arrayIndexOf(gameKeys, i -> gameKeys[i].equals(cfg.getMouseAxis(MouseAxis.RIGHT))) + 1;
            }

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                return this.this$0.mAdvancedCallback(handler, cfg, this, opt, MouseAxis.RIGHT);
            }
        };
        this.mAxisRight.list = keymaplist;
        this.mAxisLeft.list = keymaplist;
        this.mAxisDown.list = keymaplist;
        this.mAxisUp.list = keymaplist;
        advancedMenu.addItem(this.mAxisUp, true);
        advancedMenu.addItem(this.mAxisDown, false);
        advancedMenu.addItem(this.mAxisLeft, false);
        advancedMenu.addItem(this.mAxisRight, false);
        return advancedMenu;
    }

    private boolean mAdvancedCallback(MenuHandler handler, GameConfig cfg, MenuConteiner item, MenuHandler.MenuOpt opt, MouseAxis mouseAxis) {
        switch (opt) {
            case LEFT: 
            case MWDW: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num > 0 ? --item.num : 0;
                cfg.setMouseAxis(mouseAxis, item.num > 0 ? cfg.getKeymap()[item.num - 1] : GameKey.UNKNOWN_KEY);
                return false;
            }
            case RIGHT: 
            case MWUP: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num < item.list.length - 1 ? ++item.num : item.list.length - 1;
                cfg.setMouseAxis(mouseAxis, item.num > 0 ? cfg.getKeymap()[item.num - 1] : GameKey.UNKNOWN_KEY);
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((item.flags & 4) == 0) {
                    return false;
                }
                item.num = item.num < item.list.length - 1 ? ++item.num : 0;
                cfg.setMouseAxis(mouseAxis, item.num > 0 ? cfg.getKeymap()[item.num - 1] : GameKey.UNKNOWN_KEY);
                return false;
            }
        }
        return item.m_pMenu.mNavigation(opt);
    }
}

