/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import java.util.stream.IntStream;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenuList;
import ru.m210projects.Build.Pattern.MenuItems.DummyItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.settings.GameConfig;

public abstract class MenuRendererSettings
extends BuildMenuList {
    private final MenuItem title;
    public BuildGame app;
    public Font style;
    public int width;
    public boolean fontShadow = false;
    public boolean listShadow = false;
    protected BuildMenuList GLHiresMenu;
    protected MenuSlider palettedGamma;
    protected MenuSlider fovSlider;
    protected MenuSwitch vSync;
    protected MenuSwitch useVoxels;
    protected MenuConteiner fpsLimits;
    protected DummyItem separator;
    protected MenuConteiner GLTextureFilter;
    protected MenuSwitch GLPaletteFiltered;
    protected MenuSwitch GLSoftShading;
    protected MenuSwitch GLUseHighTile;
    protected MenuSwitch GLUseModels;
    protected MenuButton GLHires;
    protected MenuSwitch GLPalette;
    private Renderer currentRenderer;
    private TileData.PixelFormat currentFormat;

    public MenuRendererSettings(BuildGame app, int x, int y, int width, int step, Font style) {
        super(app, "Renderer settings", x, y, width, step, 15);
        this.app = app;
        this.style = style;
        this.width = width;
        this.title = this.m_pItems[0];
    }

    @Override
    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    @Override
    public void mDraw(MenuHandler handler) {
        Renderer renderer = this.app.getRenderer();
        if (this.currentFormat != renderer.getTexFormat()) {
            this.rebuild();
        }
        super.mDraw(handler);
    }

    @Override
    public boolean mLoadRes(MenuHandler handler, MenuHandler.MenuOpt opt) {
        Renderer renderer = this.app.getRenderer();
        if (opt == MenuHandler.MenuOpt.Open && (this.currentRenderer != this.app.getRenderer() || this.currentFormat != renderer.getTexFormat())) {
            this.rebuild();
        }
        return super.mLoadRes(handler, opt);
    }

    protected void rebuild() {
        this.clear();
        this.currentRenderer = this.app.getRenderer();
        this.currentFormat = this.currentRenderer.getTexFormat();
        if (this.title != null) {
            this.title.text = (this.currentRenderer.getType().getName() + " settings").toCharArray();
        }
        this.BuildRenderParameters();
        if (!this.app.isSoftwareRenderer()) {
            this.BuildGLRenderParameters();
            this.addItem(this.palettedGamma, true);
            this.addItem(this.separator, false);
            this.addItem(this.fovSlider, false);
            this.addItem(this.vSync, false);
            this.addItem(this.fpsLimits, false);
            this.addItem(this.useVoxels, false);
            this.addItem(this.separator, false);
            this.addItem(this.GLPalette, false);
            this.addItem(this.GLHires, false);
        } else {
            this.addItem(this.palettedGamma, true);
            this.addItem(this.separator, false);
            this.addItem(this.fovSlider, false);
            this.addItem(this.vSync, false);
            this.addItem(this.fpsLimits, false);
            this.addItem(this.useVoxels, false);
        }
    }

    protected MenuConteiner BuildConteiner(String text, final SettingsListProvider settingsProvider) {
        MenuConteiner conteiner = new MenuConteiner(this, text, this.style, 0, 0, this.width, settingsProvider.getValues(), 0, (h, pItem) -> settingsProvider.setValue(((MenuConteiner)pItem).num)){
            final /* synthetic */ MenuRendererSettings this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(settingsProvider.checkEnable());
                this.num = (Integer)settingsProvider.getValue();
                super.draw(handler);
            }
        };
        conteiner.fontShadow = this.fontShadow;
        conteiner.listShadow = this.listShadow;
        return conteiner;
    }

    protected MenuSlider BuildSlider(String text, final SettingsSliderProvider var) {
        MenuSlider slider = new MenuSlider(this, this.app.pSlider, text, this.style, 0, 0, this.width, 0, var.getMinValue(), var.getMaxValue(), var.getStep(), (handler, pItem) -> var.setValue(((MenuSlider)pItem).value), true){
            final /* synthetic */ MenuRendererSettings this$0;
            {
                this.this$0 = this$0;
                super(slider, text, textStyle, x, y, width, value, min, max, step, callback, digital);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.value = (Integer)var.getValue();
                super.draw(handler);
            }
        };
        slider.fontShadow = this.fontShadow;
        return slider;
    }

    protected MenuSwitch BuildSwitch(String text, final SettingsProvider<Boolean> provider) {
        MenuSwitch sw = new MenuSwitch(this, text, this.style, 0, 0, this.width, false, (h, pItem) -> provider.setValue(((MenuSwitch)pItem).value), null, null){
            final /* synthetic */ MenuRendererSettings this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, value, callback, onMessage, offMessage);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.value = (Boolean)provider.getValue();
                super.draw(handler);
            }
        };
        sw.fontShadow = this.fontShadow;
        return sw;
    }

    protected MenuButton BuildButton(MenuProc callback) {
        MenuButton sw = new MenuButton("Hires settings", this.style, 0, 0, this.width, 0, 0, null, 0, callback, -1);
        sw.fontShadow = this.fontShadow;
        return sw;
    }

    protected void BuildGLRenderParameters() {
        this.GLHires = this.BuildButton((handler, p) -> handler.mOpen(this.GLHiresMenu, -1));
        this.GLPalette = this.BuildSwitch("Palette emulation", new PaletteEmulationSettingsProvider(this.app.pCfg));
        this.GLHiresMenu = new BuildMenuList(this.app, "Hires settings", this.list.x, this.list.y, this.width, this.list.mFontOffset(), 10){

            @Override
            public MenuTitle getTitle(BuildGame app, String text) {
                return MenuRendererSettings.this.getTitle(app, text);
            }
        };
        this.GLTextureFilter = this.BuildConteiner("Texture filtering", new TextureFilterSettingsProvider(this.app.pCfg));
        this.GLPaletteFiltered = this.BuildSwitch("Palette mode filtering", new PaletteFilteredSettingsProvider(this.app.pCfg));
        this.GLSoftShading = this.BuildSwitch("Palette mode soft shading", new SoftShadingSettingsProvider(this.app.pCfg));
        this.GLUseHighTile = this.BuildSwitch("True color textures", new UseHighTileSettingsProvider(this.app.pCfg));
        this.GLUseModels = this.BuildSwitch("3d models", new UseModelsSettingsProvider(this.app.pCfg));
        this.GLHiresMenu.addItem(this.GLTextureFilter, true);
        this.GLHiresMenu.addItem(this.GLPaletteFiltered, false);
        this.GLHiresMenu.addItem(this.GLSoftShading, false);
        this.GLHiresMenu.addItem(this.GLUseHighTile, false);
        this.GLHiresMenu.addItem(this.GLUseModels, false);
    }

    protected void BuildRenderParameters() {
        this.separator = new DummyItem();
        this.palettedGamma = this.BuildSlider("Gamma", new GammaSettingsProvider(this.app));
        this.fovSlider = this.BuildSlider("Field of view", new FovSettingsProvider(this.app.pCfg));
        this.vSync = this.BuildSwitch("Vsync", new VsyncSettingsProvider(this.app.pCfg));
        this.fpsLimits = this.BuildConteiner("Framerate limit", new FpsSettingsProvider(this.app.pCfg));
        this.useVoxels = this.BuildSwitch("Voxels", new VoxelSettingsProvider(this.app.pCfg));
    }

    public static interface SettingsListProvider
    extends SettingsProvider<Integer> {
        public String[] getValues();
    }

    public static interface SettingsSliderProvider
    extends SettingsProvider<Integer> {
        public int getMinValue();

        public int getMaxValue();

        public int getStep();
    }

    public static interface SettingsProvider<T> {
        public T getValue();

        public void setValue(T var1);

        default public boolean checkEnable() {
            return true;
        }
    }

    private static class PaletteEmulationSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public PaletteEmulationSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.isPaletteEmulation();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setPaletteEmulation(value);
        }
    }

    private static class TextureFilterSettingsProvider
    implements SettingsListProvider {
        private final GameConfig gameConfig;
        private final String[] filters;

        public TextureFilterSettingsProvider(GameConfig gameConfig) {
            this.gameConfig = gameConfig;
            this.filters = new String[TexFilter.values().length];
            for (int i = 0; i < this.filters.length; ++i) {
                this.filters[i] = TexFilter.valueOf(i).name();
            }
        }

        @Override
        public boolean checkEnable() {
            return true;
        }

        @Override
        public Integer getValue() {
            TexFilter currentFilter = this.gameConfig.getGlfilter();
            return IntStream.range(0, this.filters.length).boxed().filter(e -> TexFilter.valueOf(e).equals((Object)currentFilter)).findAny().orElse(-1);
        }

        @Override
        public void setValue(Integer value) {
            this.gameConfig.setGlfilter(TexFilter.valueOf(value));
        }

        @Override
        public String[] getValues() {
            return this.filters;
        }
    }

    private static class PaletteFilteredSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public PaletteFilteredSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.getPaletteFiltered();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setPaletteFiltered(value);
        }
    }

    private static class SoftShadingSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public SoftShadingSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.getSoftShading();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setSoftShading(value);
        }
    }

    private static class UseHighTileSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public UseHighTileSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.isUseHighTiles();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setUseHighTiles(value);
        }
    }

    private static class UseModelsSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public UseModelsSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.isUseModels();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setUseModels(value);
        }
    }

    private static class GammaSettingsProvider
    implements SettingsSliderProvider {
        private final BuildGame app;

        public GammaSettingsProvider(BuildGame app) {
            this.app = app;
        }

        @Override
        public Integer getValue() {
            return this.app.pCfg.getPaletteGamma();
        }

        @Override
        public void setValue(Integer value) {
            this.app.pCfg.setPaletteGamma(value);
            this.app.pEngine.setbrightness(this.app.pCfg.getPaletteGamma(), this.app.pEngine.getPaletteManager().getBasePalette());
        }

        @Override
        public int getMinValue() {
            return 0;
        }

        @Override
        public int getMaxValue() {
            return 15;
        }

        @Override
        public int getStep() {
            return 1;
        }
    }

    private static class FovSettingsProvider
    implements SettingsSliderProvider {
        private final GameConfig config;

        public FovSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Integer getValue() {
            return this.config.getgFov();
        }

        @Override
        public void setValue(Integer value) {
            this.config.setgFov(value);
        }

        @Override
        public int getMinValue() {
            return 60;
        }

        @Override
        public int getMaxValue() {
            return 140;
        }

        @Override
        public int getStep() {
            return 5;
        }
    }

    private static class VsyncSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public VsyncSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.isVSync();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setgVSync(value);
        }
    }

    private static class FpsSettingsProvider
    implements SettingsListProvider {
        private final Integer[] fpslimits = new Integer[]{0, 30, 60, 120, 144, 240, 320, 480};
        private final String[] values;
        private final GameConfig config;

        public FpsSettingsProvider(GameConfig config) {
            this.config = config;
            this.values = new String[this.fpslimits.length];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = i == 0 ? "None" : this.fpslimits[i] + " fps";
            }
        }

        @Override
        public Integer getValue() {
            int currentFps = this.config.getFpslimit();
            return IntStream.range(0, this.values.length).boxed().filter(e -> this.fpslimits[e] == currentFps).findAny().orElse(-1);
        }

        @Override
        public void setValue(Integer value) {
            this.config.setFpslimit(this.fpslimits[value]);
        }

        @Override
        public String[] getValues() {
            return this.values;
        }
    }

    private static class VoxelSettingsProvider
    implements SettingsProvider<Boolean> {
        private final GameConfig config;

        public VoxelSettingsProvider(GameConfig config) {
            this.config = config;
        }

        @Override
        public Boolean getValue() {
            return this.config.isUseVoxels();
        }

        @Override
        public void setValue(Boolean value) {
            this.config.setUseVoxels(value);
        }
    }
}

