/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.CommonMenus;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import java.util.List;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.settings.GameConfig;

public abstract class MenuVideoMode
extends BuildMenu {
    protected final BuildMenu mResList;
    protected final BuildMenu mRenSettingsMenu;
    protected GameConfig config;
    protected MenuConteiner mResolution;
    protected MenuConteiner mRenderer;
    protected MenuButton mRenderSettings;
    protected MenuSwitch mFullscreen;
    protected MenuButton mApplyChanges;
    protected MenuResolutionList mSlot;
    protected MenuScroller slider;
    protected Graphics.DisplayMode currentMode;
    protected boolean isFullscreen;
    protected Renderer.RenderType currentRender;
    protected Renderer.RenderType choosedRender;

    public MenuVideoMode(final BuildGame app, int posx, int posy, int width, int itemHeight, Font style, int nListItems, int nListWidth, int nBackground) {
        super(app.pMenu);
        this.config = app.pCfg;
        this.addItem(this.getTitle(app, "Video mode"), false);
        final GameConfig cfg = app.pCfg;
        MenuProc applyButtonCallback = (handler, pItem) -> Gdx.app.postRunnable(() -> {
            Graphics.DisplayMode displayMode = this.mSlot.getSelectedMode();
            if (this.currentRender != this.choosedRender) {
                cfg.setRenderType(this.choosedRender);
                this.currentRender = this.choosedRender;
            } else {
                cfg.setScreenMode(displayMode.width, displayMode.height, this.isFullscreen);
            }
        });
        this.mResList = this.getResolutionListMenu(this, app, posx + (width - nListWidth) / 2, posy + 2 * style.getSize(), nListWidth, nListItems, style, nBackground);
        this.mRenSettingsMenu = this.getRenSettingsMenu(app, posx, posy, width, itemHeight, style);
        this.mResolution = new MenuConteiner("Resolution", style, posx, posy += itemHeight, width, null, 0, null){

            @Override
            public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
                switch (opt) {
                    case LEFT: 
                    case MWDW: {
                        MenuVideoMode.this.mSlot.l_nFocus = MenuVideoMode.this.mSlot.l_nFocus > 0 ? --MenuVideoMode.this.mSlot.l_nFocus : 0;
                        return false;
                    }
                    case RIGHT: 
                    case MWUP: {
                        MenuVideoMode.this.mSlot.l_nFocus = MenuVideoMode.this.mSlot.l_nFocus < MenuVideoMode.this.mSlot.len - 1 ? ++MenuVideoMode.this.mSlot.l_nFocus : MenuVideoMode.this.mSlot.len - 1;
                        return false;
                    }
                    case ENTER: 
                    case LMB: {
                        handler.mOpen(MenuVideoMode.this.mResList, -1);
                        return false;
                    }
                }
                return this.m_pMenu.mNavigation(opt);
            }

            @Override
            public void open() {
                MenuVideoMode.this.mSlot.open();
                MenuVideoMode.this.currentMode = MenuVideoMode.this.mSlot.getSelectedMode();
                this.num = MenuVideoMode.this.mSlot.l_nFocus;
            }

            @Override
            public void draw(MenuHandler handler) {
                int px = this.x;
                int py = this.y;
                String key = ResolutionUtils.getDisplayModeAsString(MenuVideoMode.this.mSlot.getSelectedMode());
                int pal = handler.getPal(this.font, this);
                int shade = handler.getShade(this);
                this.font.drawTextScaled(handler.getRenderer(), px, py, this.text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                this.listFont.drawTextScaled(handler.getRenderer(), this.x + this.width - 1, py, key, 1.0f, shade, handler.getPal(this.listFont, this), TextAlign.Right, Transparent.None, ConvertType.Normal, this.listShadow);
                handler.mPostDraw(this);
            }
        };
        MenuProc renderCallback = (handler, pItem) -> Gdx.app.postRunnable(() -> {
            MenuConteiner item = (MenuConteiner)pItem;
            switch (item.num) {
                case 0: {
                    this.choosedRender = Renderer.RenderType.Software;
                    break;
                }
                case 1: {
                    this.choosedRender = Renderer.RenderType.Polymost;
                    break;
                }
                case 2: {
                    this.choosedRender = Renderer.RenderType.PolyGDX;
                }
            }
        });
        String[] renderers = new String[]{Renderer.RenderType.Software.getName(), Renderer.RenderType.Polymost.getName(), Renderer.RenderType.PolyGDX.getName()};
        this.mRenderer = new MenuConteiner(this, "Renderer", style, posx, posy += itemHeight, width, renderers, 0, renderCallback){
            final /* synthetic */ MenuVideoMode this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, list, num, callback);
            }

            @Override
            public void open() {
                this.this$0.choosedRender = this.this$0.currentRender = app.getRenderer().getType();
                switch (this.this$0.currentRender) {
                    case Software: {
                        this.num = 0;
                        break;
                    }
                    case Polymost: {
                        this.num = 1;
                        break;
                    }
                    case PolyGDX: {
                        this.num = 2;
                    }
                }
            }
        };
        this.mFullscreen = new MenuSwitch(this, "Fullscreen", style, posx, posy += itemHeight, width, cfg.isFullscreen(), new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuSwitch sw = (MenuSwitch)pItem;
                MenuVideoMode.this.isFullscreen = sw.value;
            }
        }, null, null){
            final /* synthetic */ MenuVideoMode this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, value, callback, onMessage, offMessage);
            }

            @Override
            public void open() {
                this.value = this.this$0.isFullscreen = cfg.isFullscreen();
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(this.this$0.mSlot.l_nFocus != -1);
                super.draw(handler);
            }
        };
        this.mRenderSettings = new MenuButton("Renderer settings", style, posx, posy += itemHeight, width, 0, 0, this.mRenSettingsMenu, -1, null, 0);
        this.mApplyChanges = new MenuButton(this, "Apply changes", style, 0, posy += 2 * itemHeight, 320, 1, 0, null, -1, applyButtonCallback, 0){
            final /* synthetic */ MenuVideoMode this$0;
            {
                this.this$0 = this$0;
                super(text, font, x, y, width, align, pal, nextMenu, nItem, specialCall, specialOpt);
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(!ResolutionUtils.getDisplayModeAsString(this.this$0.mSlot.getSelectedMode()).equalsIgnoreCase(ResolutionUtils.getDisplayModeAsString(this.this$0.currentMode)) || this.this$0.isFullscreen != cfg.isFullscreen() && this.this$0.mSlot.l_nFocus != -1 || this.this$0.currentRender != this.this$0.choosedRender);
                super.draw(handler);
            }

            @Override
            public void mCheckEnableItem(boolean nEnable) {
                this.flags = nEnable ? 7 : 3;
            }
        };
        this.addItem(this.mResolution, true);
        this.addItem(this.mRenderer, false);
        this.addItem(this.mFullscreen, false);
        this.addItem(this.mRenderSettings, false);
        this.addItem(this.mApplyChanges, false);
    }

    public abstract MenuTitle getTitle(BuildGame var1, String var2);

    public BuildMenu getResolutionListMenu(MenuVideoMode parent, BuildGame app, int posx, int posy, int width, int nListItems, Font style, int nListBackground) {
        BuildMenu menu = new BuildMenu(app.pMenu);
        menu.addItem(parent.getTitle(app, "Resolution"), false);
        int bpp = Gdx.graphics.getDisplayMode().bitsPerPixel;
        List<Graphics.DisplayMode> resolutions = ResolutionUtils.getBestDisplayModes(app.pCfg.getResolutions(), bpp);
        MenuProc resolutionListApplyCallback = (handler, pItem) -> {
            MenuResolutionList item = (MenuResolutionList)pItem;
            if (item.l_nFocus == -1) {
                return;
            }
            Gdx.app.postRunnable(() -> {
                Graphics.DisplayMode selectedMode = item.getSelectedMode();
                app.pCfg.setScreenMode(selectedMode.width, selectedMode.height, app.pCfg.isFullscreen());
                parent.mLoadRes(app.pMenu, MenuHandler.MenuOpt.Open);
                app.pMenu.mMenuBack();
            });
        };
        this.mSlot = new MenuResolutionList(app, resolutions, style, posx, posy, width, 1, resolutionListApplyCallback, nListItems, nListBackground);
        this.slider = new MenuScroller(app.pSlider, this.mSlot, width + posx - app.pSlider.getScrollerWidth());
        menu.addItem(this.mSlot, true);
        menu.addItem(this.slider, false);
        return menu;
    }

    public abstract MenuRendererSettings getRenSettingsMenu(BuildGame var1, int var2, int var3, int var4, int var5, Font var6);

    public void onResize(int width, int height) {
        this.mResolution.open();
    }

    public void onRenderChanged(Renderer.RenderType renderType) {
        int bpp = Gdx.graphics.getDisplayMode().bitsPerPixel;
        this.mSlot.setDisplayModes(ResolutionUtils.getBestDisplayModes(this.config.getResolutions(), bpp));
    }
}

