/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Pattern.Tools.NaturalComparator;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public abstract class MenuFileBrowser
extends MenuItem
implements ScrollableMenuItem {
    protected final BuildGame app;
    protected final int nListItems;
    protected final int nItemHeight;
    private final int DIRECTORY = 0;
    private final int FILE = 1;
    private final int[] scrollX = new int[2];
    private final SliderDrawable slider;
    public String back = "..";
    public boolean[] scrollTouch = new boolean[2];
    public String path;
    public int topPal;
    public int pathPal;
    public int listPal;
    public int backgroundPal;
    public int transparent = 1;
    protected List<FileEntry> fileList;
    protected List<Directory> dirList;
    protected int oldEntryCount;
    protected char[] dirs = "Directories".toCharArray();
    protected char[] ffs = "Files".toCharArray();
    protected int[] l_nMin;
    protected int[] l_nFocus;
    protected int currColumn;
    protected Directory currDir;
    protected Font topFont;
    protected Font pathFont;
    protected char[] buffer = new char[40];
    private final Map<String, ExtProp> extensionProperties = new HashMap<String, ExtProp>();
    private final Map<Class<?>, ExtProp> classProperties = new HashMap();
    private final Comparator<FileEntry> fileComparator = (o1, o2) -> {
        int c;
        ExtProp p1 = this.getProperty(o1);
        ExtProp p2 = this.getProperty(o2);
        if (p1 != null && p2 != null && (c = p2.priority - p1.priority) != 0) {
            return c;
        }
        return o1.compareTo((Entry)o2);
    };
    private final int nBackground;
    private int scrollerHeight;
    private long checkDirectory;

    public MenuFileBrowser(BuildGame app, Font font, Font topFont, Font pathFont, int x, int y, int width, int nItemHeight, int nListItems, int nBackground) {
        super(null, font);
        this.dirList = new ArrayList<Directory>();
        this.fileList = new ArrayList<FileEntry>();
        this.flags = 7;
        this.app = app;
        this.slider = app.pSlider;
        this.x = x;
        this.y = y;
        this.width = width;
        this.nItemHeight = nItemHeight;
        this.nListItems = nListItems;
        this.topFont = topFont;
        this.pathFont = pathFont;
        this.nBackground = nBackground;
        this.l_nMin = new int[2];
        this.l_nFocus = new int[2];
        this.currColumn = 1;
        this.init();
    }

    public void registerExtension(String ext, int pal, int priority) {
        this.extensionProperties.put(ext.toUpperCase(), new ExtProp(pal, priority));
    }

    public void registerClass(Class<?> cl, int pal, int priority) {
        this.classProperties.put(cl, new ExtProp(pal, priority));
    }

    public abstract void init();

    public abstract void handleFile(FileEntry var1);

    public abstract void invoke(FileEntry var1);

    public abstract void handleDirectory(Directory var1);

    public int getListSize(int column) {
        if (column == 1) {
            return this.fileList.size();
        }
        return this.dirList.size();
    }

    public String getFileName() {
        return this.fileList.get(this.l_nFocus[1]).getName();
    }

    public Directory getDirectory() {
        return this.currDir;
    }

    public int mFontOffset() {
        return this.font.getSize() + this.nItemHeight;
    }

    private void changeDir(Directory dir) {
        if (dir instanceof BackDirectory) {
            dir = ((BackDirectory)dir).getDirectory();
        }
        if (dir.equals(Directory.DUMMY_DIRECTORY) || this.currDir == dir && !dir.revalidate()) {
            return;
        }
        this.dirList.clear();
        this.fileList.clear();
        this.oldEntryCount = dir.getSize();
        this.currDir = dir;
        this.path = File.separator;
        if (!this.app.getCache().isGameDirectory(this.currDir)) {
            Path relativePath = this.currDir.getDirectoryEntry().getRelativePath();
            this.path = this.path + relativePath;
        }
        for (Entry entry : dir.getEntries()) {
            if (!(entry instanceof FileEntry) || !entry.isDirectory()) continue;
            this.dirList.add(((FileEntry)entry).getDirectory());
        }
        this.dirList.sort((a, b) -> NaturalComparator.compare(a.getName(), b.getName()));
        if (!this.app.getCache().isGameDirectory(dir)) {
            this.dirList.add(0, this.getBackDirectory(this.currDir));
        }
        try {
            this.handleDirectory(dir);
        }
        catch (Exception ignore) {
            Console.out.println("Can't handle directory: " + dir.getName(), OsdColor.RED);
        }
        for (Entry entry : dir.getEntries()) {
            if (!(entry instanceof FileEntry) || entry.isDirectory() || this.extensionProperties.get(entry.getExtension()) == null) continue;
            try {
                this.handleFile((FileEntry)entry);
            }
            catch (Exception ignore) {
                Console.out.println("Can't handle file: " + entry.getName(), OsdColor.RED);
            }
        }
        this.sortFiles();
        this.l_nMin[0] = 0;
        this.l_nFocus[0] = 0;
        this.l_nMin[1] = 0;
        this.l_nFocus[1] = 0;
    }

    public void addFile(FileEntry file) {
        this.fileList.add(file);
    }

    public void sortFiles() {
        this.fileList.sort(this.fileComparator);
    }

    protected void drawHeader(Renderer renderer, int x1, int x2, int y) {
        this.topFont.drawTextScaled(renderer, x1, y, this.dirs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        this.topFont.drawTextScaled(renderer, x2, y, this.ffs, 1.0f, -32, this.topPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
    }

    protected void drawPath(Renderer renderer, int x, int y, String path) {
        this.font.drawTextScaled(renderer, x, y, this.calcTextBounds(path, this.width - 2 * this.slider.getScrollerWidth() - 7), 1.0f, -32, this.pathPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
    }

    protected String calcTextBounds(String text, int allowWidth) {
        int delta;
        int symbols;
        int textWidth = this.font.getWidth(text, 1.0f);
        if (allowWidth < textWidth && (text = text.substring(symbols = (delta = textWidth - allowWidth) / this.font.getCharInfo('a').getCellSize())).length() > 6) {
            text = "..." + text.substring(3);
        }
        return text;
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade;
        int pal;
        int i;
        int yColNames = this.y + 3;
        int yPath = yColNames + this.topFont.getSize() + 2;
        int yList = yPath + this.pathFont.getSize() + 2;
        int scrollerWidth = this.slider.getScrollerWidth();
        handler.game.getRenderer().rotatesprite(this.x << 16, this.y << 16, 65536, 0, this.nBackground, 127, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, ConvertType.Normal), Gameutils.coordsConvertYScaled(yList + this.nListItems * this.mFontOffset() + 6));
        int px = this.x + 3;
        this.drawHeader(handler.getRenderer(), px, this.x - 3 + this.width - this.topFont.getWidth(this.ffs, 1.0f), yColNames);
        this.drawPath(handler.getRenderer(), px += scrollerWidth + 3, yPath, "path: " + this.path);
        int py = yList;
        for (i = this.l_nMin[0]; i >= 0 && i < this.l_nMin[0] + this.nListItems && i < this.dirList.size(); ++i) {
            pal = this.listPal;
            shade = handler.getShade(this.currColumn == 0 && i == this.l_nFocus[0] ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            if (this.currColumn == 0 && i == this.l_nFocus[0]) {
                pal = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            this.font.drawTextScaled(handler.getRenderer(), px, py, this.calcTextBounds(this.dirList.get(i).getName(), this.width / 2 - this.slider.getScrollerWidth() - 4), 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            py += this.mFontOffset();
        }
        py = yList;
        for (i = this.l_nMin[1]; i >= 0 && i < this.l_nMin[1] + this.nListItems && i < this.fileList.size(); ++i) {
            int itemPal;
            pal = this.listPal;
            if (this.currColumn == 1 && i == this.l_nFocus[1]) {
                pal = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            shade = handler.getShade(this.currColumn == 1 && i == this.l_nFocus[1] ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            FileEntry obj = this.fileList.get(i);
            String text = obj.getName();
            ExtProp p = this.getProperty(obj);
            if (p != null && (itemPal = p.pal) != 0) {
                pal = itemPal;
            }
            px = this.x + this.width - scrollerWidth - 5;
            this.font.drawTextScaled(handler.getRenderer(), px, py, this.calcTextBounds(text, this.width / 2 - this.slider.getScrollerWidth()), 1.0f, shade, pal, TextAlign.Right, Transparent.None, ConvertType.Normal, this.fontShadow);
            py += this.mFontOffset();
        }
        this.scrollerHeight = this.nListItems * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.fileList.size() - this.nListItems, 1);
        int posy = yList + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin[1] / nList;
        this.scrollX[1] = this.x + this.width - scrollerWidth - 1;
        this.slider.drawScrollerBackground(this.scrollX[1], yList, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollX[1], posy, handler.getShade(this.currColumn == 1 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        nList = Gameutils.BClipLow(this.dirList.size() - this.nListItems, 1);
        posy = yList + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin[0] / nList;
        this.scrollX[0] = this.x + 2;
        this.slider.drawScrollerBackground(this.scrollX[0], yList, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollX[0], posy, handler.getShade(this.currColumn == 0 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        if (System.currentTimeMillis() - this.checkDirectory >= 2000L) {
            if (this.currDir.revalidate()) {
                this.refreshList();
            }
            this.checkDirectory = System.currentTimeMillis();
        }
        handler.mPostDraw(this);
    }

    public String getText(int column, int index) {
        if (column == 0) {
            return this.calcTextBounds(this.dirList.get(index).getName(), this.width / 2 - this.slider.getScrollerWidth() - 4);
        }
        if (column == 1) {
            return this.calcTextBounds(this.fileList.get(index).getName(), this.width / 2 - this.slider.getScrollerWidth());
        }
        return "";
    }

    public int getFocus() {
        int focus = this.l_nFocus[this.currColumn];
        if (focus < this.l_nMin[this.currColumn] || focus >= this.l_nMin[this.currColumn] + this.getListSize(this.currColumn)) {
            return -1;
        }
        return this.l_nFocus[this.currColumn];
    }

    public int getMin() {
        return this.l_nMin[this.currColumn];
    }

    public int getRowCount() {
        return this.nListItems;
    }

    public int getColumn() {
        return this.currColumn;
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case MWUP: {
                if (this.l_nMin[this.currColumn] > 0) {
                    int n = this.currColumn;
                    this.l_nMin[n] = this.l_nMin[n] - 1;
                }
                return false;
            }
            case MWDW: {
                if (this.l_nMin[this.currColumn] < this.getListSize(this.currColumn) - this.nListItems) {
                    int n = this.currColumn;
                    this.l_nMin[n] = this.l_nMin[n] + 1;
                }
                return false;
            }
            case UP: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] - 1;
                if (this.l_nFocus[this.currColumn] >= 0 && this.l_nFocus[this.currColumn] < this.l_nMin[this.currColumn] && this.l_nMin[this.currColumn] > 0) {
                    int n2 = this.currColumn;
                    this.l_nMin[n2] = this.l_nMin[n2] - 1;
                }
                if (this.l_nFocus[this.currColumn] < 0) {
                    this.l_nFocus[this.currColumn] = this.getListSize(this.currColumn) - 1;
                    this.l_nMin[this.currColumn] = this.getListSize(this.currColumn) - this.nListItems;
                    if (this.l_nMin[this.currColumn] < 0) {
                        this.l_nMin[this.currColumn] = 0;
                    }
                }
                return false;
            }
            case DW: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] + 1;
                if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems && this.l_nFocus[this.currColumn] < this.getListSize(this.currColumn)) {
                    int n3 = this.currColumn;
                    this.l_nMin[n3] = this.l_nMin[n3] + 1;
                }
                if (this.l_nFocus[this.currColumn] >= this.getListSize(this.currColumn)) {
                    this.l_nFocus[this.currColumn] = 0;
                    this.l_nMin[this.currColumn] = 0;
                }
                return false;
            }
            case LEFT: {
                if (!this.dirList.isEmpty()) {
                    this.currColumn = 0;
                }
                return false;
            }
            case RIGHT: {
                if (!this.fileList.isEmpty()) {
                    this.currColumn = 1;
                }
                return false;
            }
            case ENTER: 
            case LMB: {
                if (!this.dirList.isEmpty() && this.currColumn == 0) {
                    if (this.l_nFocus[0] == -1) {
                        return false;
                    }
                    this.changeDir(this.dirList.get(this.l_nFocus[0]));
                } else if (!this.fileList.isEmpty() && this.currColumn == 1) {
                    if (this.l_nFocus[1] == -1) {
                        return false;
                    }
                    this.invoke(this.fileList.get(this.l_nFocus[1]));
                }
                return false;
            }
            case ESC: 
            case RMB: {
                return true;
            }
            case BSPACE: {
                if (!this.app.getCache().isGameDirectory(this.currDir)) {
                    this.changeDir(this.getBackDirectory(this.currDir));
                }
                return false;
            }
            case PGUP: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] - (this.nListItems - 1);
                if (this.l_nFocus[this.currColumn] >= 0 && this.l_nFocus[this.currColumn] < this.l_nMin[this.currColumn] && this.l_nMin[this.currColumn] > 0) {
                    int n4 = this.currColumn;
                    this.l_nMin[n4] = this.l_nMin[n4] - (this.nListItems - 1);
                }
                if (this.l_nFocus[this.currColumn] < 0 || this.l_nMin[this.currColumn] < 0) {
                    this.l_nFocus[this.currColumn] = 0;
                    this.l_nMin[this.currColumn] = 0;
                }
                return false;
            }
            case PGDW: {
                int n = this.currColumn;
                this.l_nFocus[n] = this.l_nFocus[n] + (this.nListItems - 1);
                if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems && this.l_nFocus[this.currColumn] < this.getListSize(this.currColumn)) {
                    int n5 = this.currColumn;
                    this.l_nMin[n5] = this.l_nMin[n5] + (this.nListItems - 1);
                }
                if (this.l_nFocus[this.currColumn] >= this.getListSize(this.currColumn) || this.l_nMin[this.currColumn] > this.getListSize(this.currColumn) - this.nListItems) {
                    this.l_nFocus[this.currColumn] = this.getListSize(this.currColumn) - 1;
                    if (this.getListSize(this.currColumn) >= this.nListItems) {
                        this.l_nMin[this.currColumn] = this.getListSize(this.currColumn) - this.nListItems;
                    } else if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems) {
                        this.l_nMin[this.currColumn] = this.getListSize(this.currColumn) - 1;
                    }
                }
                return false;
            }
            case HOME: {
                this.l_nFocus[this.currColumn] = 0;
                this.l_nMin[this.currColumn] = 0;
                return false;
            }
            case END: {
                this.l_nFocus[this.currColumn] = this.getListSize(this.currColumn) - 1;
                if (this.getListSize(this.currColumn) >= this.nListItems) {
                    this.l_nMin[this.currColumn] = this.getListSize(this.currColumn) - this.nListItems;
                } else if (this.l_nFocus[this.currColumn] >= this.l_nMin[this.currColumn] + this.nListItems) {
                    this.l_nMin[this.currColumn] = this.getListSize(this.currColumn) - 1;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        this.currColumn = mx >= this.x + this.width / 2 ? 1 : 0;
        if (!this.scrollTouch[0] && !this.scrollTouch[1] && this.getListSize(this.currColumn) > 0) {
            int py = this.y + 3 + this.pathFont.getSize() + 2 + this.topFont.getSize() + 2;
            for (int i = this.l_nMin[this.currColumn]; i >= 0 && i < this.l_nMin[this.currColumn] + this.nListItems && i < this.getListSize(this.currColumn); ++i) {
                if (mx > this.x && mx < this.scrollX[1] && my > py && my < py + this.font.getSize()) {
                    this.l_nFocus[this.currColumn] = i;
                    return true;
                }
                py += this.mFontOffset();
            }
        }
        return false;
    }

    private Directory getBackDirectory(Directory dir) {
        return new BackDirectory(dir.getDirectoryEntry().getParent());
    }

    private ExtProp getProperty(Object obj) {
        ExtProp extProp = this.classProperties.get(obj.getClass());
        if (extProp != null) {
            return extProp;
        }
        if (obj instanceof FileEntry) {
            return this.extensionProperties.get(((FileEntry)obj).getExtension());
        }
        return null;
    }

    public void refreshList() {
        Directory dir = this.currDir;
        this.currDir = null;
        this.changeDir(dir);
    }

    @Override
    public void open() {
        if (this.currDir == null) {
            this.changeDir(this.app.getCache().getGameDirectory());
        } else {
            this.changeDir(this.currDir);
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < 2; ++i) {
            this.l_nMin[i] = 0;
            this.l_nFocus[i] = 0;
        }
    }

    @Override
    public boolean onMoveSlider(MenuHandler handler, int mx, int my) {
        if (this.getListSize(this.currColumn) <= this.nListItems) {
            return false;
        }
        int nList = Gameutils.BClipLow(this.getListSize(this.currColumn) - this.nListItems, 1);
        int nRange = Math.max(1, this.scrollerHeight);
        int py = this.y + 3 + this.pathFont.getSize() + 2 + this.topFont.getSize() + 2;
        this.l_nFocus[this.currColumn] = -1;
        this.l_nMin[this.currColumn] = Gameutils.BClipRange((my - py) * nList / nRange, 0, nList);
        return true;
    }

    @Override
    public boolean onLockSlider(MenuHandler handler, int mx, int my) {
        this.currColumn = mx >= this.x + this.width / 2 ? 1 : 0;
        if (mx > this.scrollX[this.currColumn] && mx < this.scrollX[this.currColumn] + this.slider.getScrollerWidth()) {
            this.scrollTouch[this.currColumn] = true;
            this.onMoveSlider(handler, mx, my);
            return true;
        }
        return false;
    }

    @Override
    public void onUnlockSlider() {
        this.scrollTouch[0] = false;
        this.scrollTouch[1] = false;
    }

    private static class ExtProp {
        int pal;
        int priority;

        public ExtProp(int pal, int priority) {
            this.pal = pal;
            this.priority = priority;
        }
    }

    private class BackDirectory
    extends Directory {
        private final Directory dir;

        public BackDirectory(Directory dir) {
            this.dir = dir;
        }

        @Override
        public String getName() {
            return MenuFileBrowser.this.back;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }
}

