/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import java.util.Arrays;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;

public abstract class MenuHandler
implements InputListener {
    public int mCount = 0;
    public BuildMenu[] mMenuHistory = new BuildMenu[10];
    public BuildMenu[] mMenus;
    public boolean gShowMenu;
    protected boolean mUseMouse;
    protected BuildGame game;

    public MenuHandler(BuildGame game) {
        this.game = game;
    }

    public abstract int getShade(MenuItem var1);

    public abstract int getPal(Font var1, MenuItem var2);

    public abstract void mPostDraw(MenuItem var1);

    public abstract void mDrawMouse(int var1, int var2);

    public abstract void mDrawBackButton();

    public abstract boolean mCheckBackButton(int var1, int var2);

    public abstract void mSound(MenuItem var1, MenuOpt var2);

    public Renderer getRenderer() {
        return this.game.getRenderer();
    }

    public void mOpen(BuildMenu pMenu, int nItem) {
        if (pMenu == null || this.mCount == 8) {
            return;
        }
        this.mMenuHistory[0] = pMenu;
        this.mMenuHistory[++this.mCount] = pMenu;
        pMenu.open(this, nItem);
        this.gShowMenu = true;
        Gdx.input.setCursorCatched(false);
    }

    public boolean isShowing() {
        return this.gShowMenu;
    }

    public void mClose() {
        Arrays.fill(this.mMenuHistory, null);
        this.mCount = 0;
        this.gShowMenu = false;
        if (!this.game.isActive()) {
            return;
        }
        Renderer ren = this.game.getRenderer();
        Gdx.input.setCursorCatched(true);
        Gdx.input.setCursorPosition(ren.getWidth() / 2, ren.getHeight() / 2);
        this.game.getProcessor().resetPollingStates();
    }

    public void mMenuBack() {
        if (this.mCount > 0) {
            if (this.mMenuHistory[0] != null) {
                this.mMenuHistory[0].mLoadRes(this, MenuOpt.Close);
            }
            this.mCount = Gameutils.BClipLow(this.mCount - 1, 0);
            if (this.mCount > 0) {
                this.mMenuHistory[0] = this.mMenuHistory[this.mCount];
            } else {
                this.mClose();
            }
        }
    }

    @Deprecated
    protected boolean onEvent(MenuOpt opt) {
        if (this.mMenuHistory[0] == null) {
            return false;
        }
        if (this.mMenuHistory[0].mLoadRes(this, opt)) {
            this.mMenuBack();
            return true;
        }
        return false;
    }

    public BuildMenu getCurrentMenu() {
        return this.mMenuHistory[0];
    }

    public BuildMenu getLastMenu() {
        if (this.mCount > 0) {
            return this.mMenuHistory[this.mCount - 1];
        }
        return this.getCurrentMenu();
    }

    public boolean isOpened(BuildMenu pMenu) {
        return pMenu != null && this.getCurrentMenu() == pMenu;
    }

    public void mDrawMenu() {
        if (this.mMenuHistory[0] != null) {
            this.mMenuHistory[0].mDraw(this);
        }
        this.mDrawBackButton();
        if (this.mUseMouse) {
            this.mDrawMouse(Gdx.input.getX(), Gdx.input.getY());
        }
    }

    private void checkFocus(BuildMenu pMenu, int x, int y) {
        Renderer ren = this.game.getRenderer();
        int oxdim = ren.getWidth();
        int xdim = 4 * ren.getHeight() / 3;
        int normxofs = x - oxdim / 2;
        int touchX = Pragmas.scale(normxofs, 320L, xdim) + 160;
        int touchY = Pragmas.mulscale(y, Pragmas.divscale(200L, ren.getHeight(), 16), 16);
        for (int i = 0; i < pMenu.m_pItems.length; i = (int)((short)(i + 1))) {
            if (!pMenu.mCheckMouseFlag(i) || !pMenu.mCheckItemsFlags(i) || !pMenu.m_pItems[i].mouseAction(touchX, touchY)) continue;
            if (pMenu.m_nFocus != i) {
                this.onEvent(MenuOpt.MCHANGE);
            }
            pMenu.m_nFocus = (short)i;
            return;
        }
    }

    protected ScrollableMenuItem getSliderItem() {
        BuildMenu pMenu = this.mMenuHistory[0];
        if (pMenu.m_nFocus != -1 && pMenu.mCheckMouseFlag(pMenu.m_nFocus) && pMenu.m_pItems[pMenu.m_nFocus] instanceof ScrollableMenuItem) {
            return (ScrollableMenuItem)((Object)pMenu.m_pItems[pMenu.m_nFocus]);
        }
        return null;
    }

    protected InputListener getFocusedGameKeyListener() {
        MenuItem item = this.getFocusedItem();
        if (item instanceof InputListener) {
            return (InputListener)((Object)item);
        }
        return null;
    }

    protected MenuItem getFocusedItem() {
        BuildMenu pMenu = this.mMenuHistory[0];
        if (pMenu.m_nFocus != -1) {
            return pMenu.m_pItems[pMenu.m_nFocus];
        }
        return null;
    }

    @Override
    public boolean scrolled(float amountX, float amount) {
        if (!this.game.pCfg.isMenuMouse()) {
            return false;
        }
        InputListener focusedItem = this.getFocusedGameKeyListener();
        if (focusedItem != null && focusedItem.scrolled(amountX, amount)) {
            return true;
        }
        if (amount < 0.0f) {
            this.onEvent(MenuOpt.MWUP);
            return true;
        }
        if (amount > 0.0f) {
            this.onEvent(MenuOpt.MWDW);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int mx, int my) {
        if (!this.game.pCfg.isMenuMouse()) {
            return false;
        }
        this.mUseMouse = true;
        InputListener focusedItem = this.getFocusedGameKeyListener();
        if (focusedItem != null && focusedItem.mouseMoved(mx, my)) {
            return true;
        }
        this.checkFocus(this.mMenuHistory[0], mx, my);
        return true;
    }

    @Override
    public boolean touchDown(int mx, int my, int pointer, int button) {
        if (!this.game.pCfg.isMenuMouse()) {
            return false;
        }
        InputListener focusedItem = this.getFocusedGameKeyListener();
        if (focusedItem != null && focusedItem.touchDown(mx, my, pointer, button)) {
            return true;
        }
        switch (button) {
            case 0: {
                int touchY;
                int xdim;
                Renderer ren;
                int oxdim;
                int normxofs;
                int touchX;
                if (this.mCount > 1 && this.mCheckBackButton(mx, my)) {
                    this.mMenuBack();
                    return true;
                }
                ScrollableMenuItem slider = this.getSliderItem();
                if (slider != null && slider.onLockSlider(this, touchX = Pragmas.scale(normxofs = mx - (oxdim = (ren = this.game.getRenderer()).getWidth()) / 2, 320L, xdim = 4 * ren.getHeight() / 3) + 160, touchY = Pragmas.mulscale(my, Pragmas.divscale(200L, ren.getHeight(), 16), 16))) {
                    return true;
                }
                if (this.onEvent(MenuOpt.LMB)) {
                    this.checkFocus(this.mMenuHistory[0], mx, my);
                    return true;
                }
                return false;
            }
            case 1: {
                return this.onEvent(MenuOpt.RMB);
            }
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (!this.game.pCfg.isMenuMouse()) {
            return false;
        }
        InputListener focusedItem = this.getFocusedGameKeyListener();
        if (focusedItem != null && focusedItem.touchUp(screenX, screenY, pointer, button)) {
            return true;
        }
        ScrollableMenuItem slider = this.getSliderItem();
        if (slider != null) {
            slider.onUnlockSlider();
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDragged(int mx, int my, int pointer) {
        if (!this.game.pCfg.isMenuMouse()) {
            return false;
        }
        InputListener focusedItem = this.getFocusedGameKeyListener();
        if (focusedItem != null && focusedItem.touchDragged(mx, my, pointer)) {
            return true;
        }
        ScrollableMenuItem slider = this.getSliderItem();
        if (slider != null) {
            Renderer ren = this.game.getRenderer();
            int oxdim = ren.getWidth();
            int xdim = 4 * ren.getHeight() / 3;
            int normxofs = mx - oxdim / 2;
            int touchX = Pragmas.scale(normxofs, 320L, xdim) + 160;
            int touchY = Pragmas.mulscale(my, Pragmas.divscale(200L, ren.getHeight(), 16), 16);
            slider.onMoveSlider(this, touchX, touchY);
            return true;
        }
        return false;
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        if (focusedListener instanceof MenuKeyboardList && focusedListener.gameKeyDown(gameKey)) {
            return false;
        }
        if (GameKeys.Show_Console.equals(gameKey)) {
            Console.out.onToggle();
            return true;
        }
        if (focusedListener != null && focusedListener.gameKeyDown(gameKey)) {
            return true;
        }
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            return this.onEvent(MenuOpt.ESC);
        }
        MenuOpt opt = MenuOpt.ANY;
        if (opt != MenuOpt.ANY) {
            this.mUseMouse = false;
            this.onEvent(opt);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyRepeat(int keycode) {
        return this.keyDown(keycode);
    }

    @Override
    public boolean keyDown(int keycode) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        if (focusedListener != null && focusedListener.keyDown(keycode)) {
            return true;
        }
        MenuOpt opt = MenuOpt.ANY;
        switch (keycode) {
            case 19: 
            case 237: {
                opt = MenuOpt.UP;
                break;
            }
            case 20: 
            case 239: {
                opt = MenuOpt.DW;
                break;
            }
            case 21: 
            case 240: {
                opt = MenuOpt.LEFT;
                break;
            }
            case 22: 
            case 238: {
                opt = MenuOpt.RIGHT;
                break;
            }
            case 66: 
            case 96: {
                opt = MenuOpt.ENTER;
                this.game.getProcessor().resetPollingStates();
                break;
            }
            case 62: {
                opt = MenuOpt.SPACE;
                break;
            }
            case 67: {
                opt = MenuOpt.BSPACE;
                break;
            }
            case 112: {
                opt = MenuOpt.DELETE;
                break;
            }
            case 92: {
                opt = MenuOpt.PGUP;
                break;
            }
            case 93: {
                opt = MenuOpt.PGDW;
                break;
            }
            case 3: {
                opt = MenuOpt.HOME;
                break;
            }
            case 123: {
                opt = MenuOpt.END;
            }
        }
        if (opt != MenuOpt.ANY) {
            this.mUseMouse = false;
            this.onEvent(opt);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        InputListener focusedItem = this.getFocusedGameKeyListener();
        return focusedItem != null && focusedItem.keyUp(keycode);
    }

    @Override
    public boolean buttonDown(Controller controller, int buttonCode) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        return focusedListener != null && focusedListener.buttonDown(controller, buttonCode);
    }

    @Override
    public boolean buttonUp(Controller controller, int buttonCode) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        return focusedListener != null && focusedListener.buttonUp(controller, buttonCode);
    }

    @Override
    public boolean axisMoved(Controller controller, int axisCode, float value) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        return focusedListener != null && focusedListener.axisMoved(controller, axisCode, value);
    }

    @Override
    public void processInput(GameProcessor processor) {
        InputListener focusedListener = this.getFocusedGameKeyListener();
        if (focusedListener != null) {
            focusedListener.processInput(processor);
        }
    }

    @Override
    public boolean keyTyped(char character) {
        InputListener focusedItem = this.getFocusedGameKeyListener();
        return focusedItem != null && focusedItem.keyTyped(character);
    }

    public static enum MenuOpt {
        NONE,
        ANY,
        UP,
        DW,
        LEFT,
        RIGHT,
        ENTER,
        ESC,
        SPACE,
        BSPACE,
        DELETE,
        LMB,
        PGUP,
        PGDW,
        HOME,
        END,
        MWUP,
        MWDW,
        RMB,
        MCHANGE,
        Open,
        Close;

    }
}

