/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.font.Font;

public abstract class MenuItem {
    protected FocusListener listener;
    public BuildMenu m_pMenu;
    MenuHandler menuHandler;
    public char[] text;
    public Font font;
    public boolean fontShadow;
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int flags = 0;
    public int pal = 0;
    public int align;

    public MenuItem(Object text, Font textStyle) {
        if (text != null) {
            if (text instanceof String) {
                this.text = ((String)text).toCharArray();
            } else if (text instanceof char[]) {
                this.text = (char[])text;
            }
        }
        this.font = textStyle;
        this.listener = () -> this.m_pMenu.mGetFocusedItem(this);
    }

    public void mCheckEnableItem(boolean nEnable) {
        this.flags = nEnable ? 7 : 1;
    }

    public boolean isEnabled() {
        return (this.flags & 7) == 7;
    }

    public boolean isFocused() {
        return this.listener.isFocused();
    }

    public void dbDrawDimensions(Renderer renderer, int col) {
        int x = Gameutils.coordsConvertXScaled(this.x - 1, ConvertType.Normal);
        int y = Gameutils.coordsConvertYScaled(this.y - 1);
        int x2 = Gameutils.coordsConvertXScaled(this.x + this.width + 1, ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(this.y + this.font.getSize() + 1);
        renderer.drawline256(x * 4096, y * 4096, x2 * 4096, y * 4096, col);
        renderer.drawline256(x * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        renderer.drawline256(x * 4096, y * 4096, x * 4096, y2 * 4096, col);
        renderer.drawline256(x2 * 4096, y * 4096, x2 * 4096, y2 * 4096, col);
    }

    public abstract void draw(MenuHandler var1);

    @Deprecated
    public abstract boolean callback(MenuHandler var1, MenuHandler.MenuOpt var2);

    @Deprecated
    public abstract boolean mouseAction(int var1, int var2);

    public abstract void open();

    public abstract void close();

    protected static interface FocusListener {
        public boolean isFocused();
    }
}

