/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import com.badlogic.gdx.Graphics;
import java.util.List;
import java.util.stream.IntStream;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuResolutionList
extends MenuList {
    private final int nBackground;
    public int transparent = 1;
    public int backgroundPal;
    protected BuildGame game;
    protected List<Graphics.DisplayMode> displayModes;

    public MenuResolutionList(BuildGame game, List<Graphics.DisplayMode> displayModes, Font font, int x, int y, int width, int align, MenuProc specialCall, int rowCount, int nBackground) {
        super(null, font, x, y, width, align, specialCall, rowCount);
        this.nBackground = nBackground;
        this.displayModes = displayModes;
        this.game = game;
        this.len = displayModes.size();
    }

    @Override
    public void open() {
        this.l_nMin = 0;
        Renderer ren = this.game.getRenderer();
        this.l_nFocus = IntStream.range(0, this.displayModes.size()).filter(i -> {
            Graphics.DisplayMode mode = this.displayModes.get(i);
            return ResolutionUtils.getDisplayModeAsString(mode).equalsIgnoreCase(ResolutionUtils.getDisplayModeAsString(ren.getWidth(), ren.getHeight()));
        }).boxed().findAny().orElse(-1);
        if (this.l_nFocus >= this.l_nMin + this.rowCount) {
            this.l_nMin = this.l_nFocus - this.rowCount + 1;
        }
    }

    public Graphics.DisplayMode getSelectedMode() {
        if (this.l_nFocus == -1) {
            Renderer ren = this.game.getRenderer();
            return new ResolutionUtils.UserDisplayMode(ren.getWidth(), ren.getHeight());
        }
        return this.displayModes.get(this.l_nFocus);
    }

    public List<Graphics.DisplayMode> getDisplayModes() {
        return this.displayModes;
    }

    public void setDisplayModes(List<Graphics.DisplayMode> displayModes) {
        this.displayModes = displayModes;
    }

    @Override
    public void draw(MenuHandler handler) {
        handler.game.getRenderer().rotatesprite(this.x - 10 << 16, this.y - 8 << 16, 65536, 0, this.nBackground, 128, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, ConvertType.Normal), Gameutils.coordsConvertYScaled(this.y + this.rowCount * this.mFontOffset() + 3));
        if (!this.displayModes.isEmpty()) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.displayModes.size(); ++i) {
                int pal = handler.getPal(this.font, null);
                int shade = handler.getShade(null);
                Graphics.DisplayMode displayMode = this.displayModes.get(i);
                String modeName = displayMode.toString();
                if (i == this.l_nFocus) {
                    shade = handler.getShade(this);
                    pal = handler.getPal(this.font, this);
                }
                if (this.align == 1) {
                    px = this.width / 2 + this.x - this.font.getWidth(modeName, 1.0f) / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - this.font.getWidth(modeName, 1.0f);
                }
                this.font.drawTextScaled(handler.getRenderer(), px, py, modeName, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                py += this.mFontOffset();
            }
        } else {
            int pal = handler.getPal(this.font, this);
            String text = "List is empty";
            int px = this.x;
            int py = this.y;
            if (this.align == 1) {
                px = this.width / 2 + this.x - this.font.getWidth(text, 1.0f) / 2;
            }
            if (this.align == 2) {
                px = this.x + this.width - 1 - this.font.getWidth(text, 1.0f);
            }
            int shade = handler.getShade(this);
            this.font.drawTextScaled(handler.getRenderer(), px, py, text, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case MWUP: {
                this.ListMouseWheelUp(handler);
                return false;
            }
            case MWDW: {
                this.ListMouseWheelDown(handler, this.displayModes.size());
                return false;
            }
            case UP: {
                this.ListUp(handler, this.displayModes.size());
                return false;
            }
            case DW: {
                this.ListDown(handler, this.displayModes.size());
                return false;
            }
            case LEFT: {
                this.ListLeft(handler);
                return false;
            }
            case RIGHT: {
                this.ListRight(handler);
                return false;
            }
            case ENTER: 
            case LMB: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.l_nFocus != -1 && !this.displayModes.isEmpty() && this.callback != null) {
                    this.callback.run(handler, this);
                }
                return false;
            }
            case ESC: 
            case RMB: {
                this.ListEscape(handler, opt);
                return true;
            }
            case PGUP: {
                this.ListPGUp(handler);
                return false;
            }
            case PGDW: {
                this.ListPGDown(handler, this.displayModes.size());
                return false;
            }
            case HOME: {
                this.ListHome(handler);
                return false;
            }
            case END: {
                this.ListEnd(handler, this.displayModes.size());
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (!this.displayModes.isEmpty()) {
            int px = this.x;
            int py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.displayModes.size(); ++i) {
                int fontx = this.font.getWidth(this.displayModes.get(i).toString(), 1.0f);
                if (this.align == 1) {
                    px = this.width / 2 + this.x - fontx / 2;
                }
                if (this.align == 2) {
                    px = this.x + this.width - 1 - fontx;
                }
                if (mx > px && mx < px + fontx && my > py && my < py + this.font.getSize()) {
                    this.l_nFocus = i;
                    return true;
                }
                py += this.mFontOffset();
            }
        }
        return false;
    }
}

