/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;

public class MenuScroller
extends MenuItem
implements ScrollableMenuItem {
    protected MenuList parent;
    private boolean isLocked;
    protected SliderDrawable slider;
    protected int height;

    public MenuScroller(SliderDrawable slider, MenuList parent, int x) {
        super(null, null);
        this.flags = 2;
        this.parent = parent;
        this.slider = slider;
        this.x = x;
        this.y = parent.y;
        this.height = parent.rowCount * parent.mFontOffset();
        this.width = slider.getScrollerWidth();
    }

    @Override
    public void draw(MenuHandler handler) {
        int nList = Gameutils.BClipLow(this.parent.len - this.parent.rowCount, 1);
        int nRange = this.height - this.slider.getScrollerHeight();
        int posy = this.y + nRange * this.parent.l_nMin / nList;
        this.slider.drawScrollerBackground(this.x, this.y, this.height, 0, this.pal);
        this.slider.drawScroller(this.x, posy, 0, this.pal);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        return this.m_pMenu.mNavigation(opt);
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (mx >= this.x && mx < this.x + this.width && my >= this.y && my < this.y + this.height && this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] != this) {
            for (short i = 0; i < this.m_pMenu.m_nItems; i = (short)(i + 1)) {
                if (this.m_pMenu.m_pItems[i] != this) continue;
                this.m_pMenu.m_nFocus = i;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onMoveSlider(MenuHandler handler, int scaledX, int scaledY) {
        if (this.isLocked) {
            int nList = Gameutils.BClipLow(this.parent.len - this.parent.rowCount, 1);
            int nRange = this.height - this.slider.getScrollerHeight();
            this.parent.l_nFocus = -1;
            this.parent.l_nMin = Gameutils.BClipRange((scaledY - this.y) * nList / nRange, 0, nList);
            return true;
        }
        return false;
    }

    @Override
    public boolean onLockSlider(MenuHandler handler, int mx, int my) {
        int cx = this.x + this.width - this.slider.getSliderRange();
        if (mx > cx && mx < cx + this.slider.getSliderRange() && my >= this.y && my < this.y + this.height) {
            this.isLocked = true;
            this.onMoveSlider(handler, mx, my);
            return true;
        }
        return false;
    }

    @Override
    public void onUnlockSlider() {
        this.isLocked = false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }
}

