/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.Arrays;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.ScrollableMenuItem;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;

public class MenuSlider
extends MenuItem
implements ScrollableMenuItem {
    public int min;
    public int max;
    public int step;
    public int value;
    public boolean digital;
    public float digitalMax;
    public char[] dbuff;
    public MenuProc callback;
    public Font sliderNumbers;
    private boolean isLocked;
    private final SliderDrawable slider;

    public MenuSlider(SliderDrawable slider, Object text, Font textStyle, int x, int y, int width, int value, int min, int max, int step, MenuProc callback, boolean digital) {
        super(text, textStyle);
        this.slider = slider;
        this.flags = 7;
        this.x = x;
        this.y = y;
        this.width = width;
        this.min = min;
        this.max = max;
        this.step = step;
        this.value = Gameutils.BClipRange(value, min, max);
        this.digital = digital;
        this.digitalMax = 0.0f;
        this.callback = callback;
        this.sliderNumbers = this.font;
        this.dbuff = new char[10];
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade = handler.getShade(this);
        if (this.text != null) {
            this.font.drawTextScaled(handler.getRenderer(), this.x, this.y, this.text, 1.0f, shade, handler.getPal(this.font, this), TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        this.slider.drawSliderBackground(this.x + this.width - this.slider.getSliderRange(), this.y, shade, handler.getPal(null, this));
        if (this.digital) {
            Arrays.fill(this.dbuff, '\u0000');
            if (this.digitalMax == 0.0f) {
                Strhandler.Bitoa(this.value, this.dbuff);
            } else {
                String val = Float.toString((float)this.value / this.digitalMax);
                int index = val.indexOf(46);
                Strhandler.buildString(this.dbuff, 0, val);
                Arrays.fill(this.dbuff, index + 4, this.dbuff.length, '\u0000');
            }
            this.sliderNumbers.drawTextScaled(handler.getRenderer(), this.x + this.width - this.slider.getSliderRange() - this.sliderNumbers.getWidth(this.dbuff, 1.0f) - 5, this.y + (this.font.getSize() - this.sliderNumbers.getSize()) / 2, this.dbuff, 1.0f, shade, handler.getPal(this.sliderNumbers, this), TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        int xRange = this.slider.getSliderRange() - this.slider.getSliderWidth();
        int nRange = this.max - this.min;
        int dx = xRange * (this.value - this.min) / nRange - this.slider.getSliderRange();
        this.slider.drawSlider(this.x + this.width + dx, this.y, shade, handler.getPal(null, this));
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case UP: {
                this.m_pMenu.mNavUp();
                break;
            }
            case DW: {
                this.m_pMenu.mNavDown();
                break;
            }
            case LEFT: 
            case MWDW: {
                int val;
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.value <= 0) {
                    int dv = (this.value - this.step) % -this.step;
                    val = this.value - this.step - dv;
                    if (dv < 0) {
                        val += this.step;
                    }
                } else {
                    int dv = (this.value - 1) % this.step;
                    val = this.value - 1 - dv;
                    if (dv < 0) {
                        val -= this.step;
                    }
                }
                this.value = Gameutils.BClipRange(val, this.min, this.max);
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            case RIGHT: 
            case MWUP: {
                int val;
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.value < 0) {
                    int dv = (this.value - 1) % -this.step;
                    val = this.value - 1 - dv;
                    if (dv < 0) {
                        val += this.step;
                    }
                } else {
                    int dv = (this.value + this.step) % this.step;
                    val = this.value + this.step - dv;
                    if (dv < 0) {
                        val -= this.step;
                    }
                }
                this.value = Gameutils.BClipRange(val, this.min, this.max);
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            case ENTER: {
                if ((this.flags & 4) == 0) {
                    return false;
                }
                if (this.callback == null) break;
                this.callback.run(handler, this);
                break;
            }
            default: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.text != null && mx > this.x && mx < this.x + this.font.getWidth(this.text, 1.0f) && my > this.y && my < this.y + this.font.getSize()) {
            return true;
        }
        int cx = this.x + this.width - this.slider.getSliderRange();
        return mx > cx && mx < cx + this.slider.getSliderRange() && my > this.y && my < this.y + this.font.getSize();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean onMoveSlider(MenuHandler handler, int scaledX, int scaledY) {
        if (this.isLocked) {
            int startx = this.x + this.width - this.slider.getSliderRange() + this.slider.getSliderWidth() / 2;
            float dr = (float)(scaledX - startx) / (float)(this.slider.getSliderRange() - this.slider.getSliderWidth() - 1);
            this.value = Gameutils.BClipRange((int)(dr * (float)(this.max - this.min) + (float)this.min), this.min, this.max);
            if (this.callback != null) {
                this.callback.run(handler, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onLockSlider(MenuHandler handler, int mx, int my) {
        if ((this.flags & 4) == 0) {
            return false;
        }
        int cx = this.x + this.width - this.slider.getSliderRange();
        if (mx > cx && mx < cx + this.slider.getSliderRange() && my > this.y && my < this.y + this.font.getSize()) {
            this.isLocked = true;
            this.onMoveSlider(handler, mx, my);
            return true;
        }
        return false;
    }

    @Override
    public void onUnlockSlider() {
        this.isLocked = false;
    }
}

