/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuPrompt;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.InputListener;

public abstract class MenuSlotList
extends MenuList
implements InputListener {
    protected final boolean saveList;
    public boolean deleteQuestion;
    public List<SaveManager.SaveInfo> text;
    public MenuProc updateCallback;
    public MenuProc confirmCallback;
    public List<SaveManager.SaveInfo> displayed;
    public int nListOffset;
    public String typed;
    private final MenuPrompt prompt;
    public int yHelpText;
    public int helpPal;
    public Font questionFont;
    public Font desriptionFont;
    public int specPal;
    public int backgroundPal;
    public int transparent = 1;
    public boolean owncursor = false;
    protected SaveManager saveManager;
    protected Renderer draw;
    protected int nBackground;
    protected int listPal;

    public MenuSlotList(Renderer draw, SaveManager saveManager, Font font, int x, int y, int yHelpText, int width, int nListItems, MenuProc updateCallback, MenuProc confirmCallback, int listPal, int specPal, int nBackground, boolean saveList) {
        super(null, font, x, y, width, 0, null, nListItems);
        this.draw = draw;
        this.prompt = new MenuPrompt(16, 1);
        this.saveManager = saveManager;
        this.nBackground = nBackground;
        this.text = saveManager.getList();
        this.rowCount = nListItems;
        this.nListOffset = 0;
        this.updateCallback = updateCallback;
        this.confirmCallback = confirmCallback;
        this.saveList = saveList;
        this.displayed = new ArrayList<SaveManager.SaveInfo>();
        this.yHelpText = yHelpText;
        this.questionFont = font;
        this.helpPal = listPal;
        this.specPal = specPal;
        this.listPal = listPal;
        this.desriptionFont = font;
    }

    public boolean isTyping() {
        return this.prompt.isCaptured();
    }

    public FileEntry getFileEntry() {
        int ptr = this.l_nFocus;
        if (this.saveList) {
            --ptr;
        }
        if (ptr == -1 || this.displayed.isEmpty()) {
            return Directory.DUMMY_ENTRY;
        }
        return this.displayed.get((int)ptr).entry;
    }

    public String SaveName() {
        int ptr = this.l_nFocus;
        if (this.saveList) {
            --ptr;
        }
        if (ptr == -1 || this.displayed.isEmpty()) {
            return "Empty slot";
        }
        return this.displayed.get((int)ptr).name;
    }

    @Override
    public void draw(MenuHandler handler) {
        int py;
        this.len = this.getListSize();
        handler.game.getRenderer().rotatesprite(this.x + this.width / 2 - 5 << 16, this.y - 3 << 16, 65536, 0, this.nBackground, 128, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, ConvertType.Normal), Gameutils.coordsConvertYScaled(this.y + this.rowCount * this.mFontOffset() + 3));
        if (!this.displayed.isEmpty()) {
            py = this.y;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < this.len; ++i) {
                int ptr = i;
                if (this.saveList) {
                    --ptr;
                }
                int shade = handler.getShade(i == this.l_nFocus && !this.deleteQuestion ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
                char[] rtext = i == 0 && this.saveList ? Strhandler.toCharArray("New savegame") : Strhandler.toCharArray(this.displayed.get((int)ptr).name);
                int pal = this.listPal;
                if (ptr >= 0) {
                    SaveManager.SaveInfo info = this.displayed.get(ptr);
                    if (info.entry == null || !info.entry.exists()) continue;
                    if (info.entry.getName().equalsIgnoreCase("autosave.sav") || info.entry.getName().startsWith("quicksav")) {
                        pal = this.specPal;
                    }
                }
                if (this.prompt.isCaptured() && i == this.l_nFocus && this.m_pMenu.mGetFocusedItem(this)) {
                    this.drawPrompt(handler.getRenderer(), this.x + this.width / 2 + this.nListOffset, py, pal);
                } else {
                    this.font.drawTextScaled(handler.getRenderer(), this.x + this.width / 2 + this.nListOffset, py, rtext, 1.0f, shade, pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                }
                py += this.mFontOffset();
            }
        } else {
            py = this.y;
            int shade = handler.getShade(this.l_nFocus != -1 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            if (this.saveList) {
                if (this.prompt.isCaptured()) {
                    this.drawPrompt(handler.getRenderer(), this.x + this.width / 2 + this.nListOffset, py, this.listPal);
                } else {
                    this.font.drawTextScaled(handler.getRenderer(), this.x + this.width / 2 + this.nListOffset, py, "New saved game", 1.0f, shade, this.listPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
                }
            } else {
                this.font.drawTextScaled(handler.getRenderer(), this.x + this.width / 2 + this.nListOffset, py, "List is empty", 1.0f, shade, this.listPal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            }
        }
        this.pal = this.helpPal;
        if (this.deleteQuestion) {
            int xdim = this.draw.getWidth();
            int ydim = this.draw.getHeight();
            int tile = this.nBackground;
            ArtEntry pic = this.draw.getTile(tile);
            float kt = (float)xdim / (float)ydim;
            float kv = (float)pic.getWidth() / (float)pic.getHeight();
            float scale = kv >= kt ? (float)(ydim + 1) / (float)pic.getHeight() : (float)(xdim + 1) / (float)pic.getWidth();
            handler.game.getRenderer().rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 4, 0x18 | this.transparent);
            int shade = handler.getShade(this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            char[] ctext = Strhandler.toCharArray("Do you want to delete \"" + this.SaveName() + "\"");
            this.questionFont.drawTextScaled(handler.getRenderer(), 160 - this.questionFont.getWidth(ctext, 1.0f) / 2, 100, ctext, 1.0f, shade, this.pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
            ctext = Strhandler.toCharArray("[Y/N]");
            this.questionFont.drawTextScaled(handler.getRenderer(), 160 - this.questionFont.getWidth(ctext, 1.0f) / 2, 110, ctext, 1.0f, shade, this.pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        } else {
            char[] ctext = Strhandler.toCharArray("Press \"DELETE\" to remove the savegame file");
            this.desriptionFont.drawTextScaled(handler.getRenderer(), 160 - this.desriptionFont.getWidth(ctext, 1.0f) / 2, this.yHelpText, ctext, 1.0f, 0, this.pal, TextAlign.Left, Transparent.None, ConvertType.Normal, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    protected void drawPrompt(Renderer renderer, int x, int y, int pal) {
        String input = this.prompt.getTextInput();
        int cursorPos = this.prompt.getCursorPosition();
        int curX = x;
        for (int i = 0; i < input.length(); ++i) {
            x += this.font.drawCharScaled(renderer, x, y, input.charAt(i), 1.0f, -128, pal, Transparent.None, ConvertType.Normal, false);
            if (i != cursorPos - 1) continue;
            curX = x;
        }
        if (this.owncursor) {
            this.drawOwnCursor(curX, y + 1);
            return;
        }
        if (this.prompt.isCaptured() && (System.currentTimeMillis() & 0x100L) == 0L) {
            char ch = '_';
            if (this.prompt.isOsdOverType()) {
                ch = '#';
            }
            this.font.drawCharScaled(renderer, curX, y + 1, ch, 1.0f, -128, pal, Transparent.None, ConvertType.Normal, false);
        }
    }

    protected void drawOwnCursor(int x, int y) {
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case ESC: 
            case RMB: {
                return !this.prompt.isCaptured() && !this.deleteQuestion;
            }
        }
        return false;
    }

    @Override
    public void open() {
        this.l_nFocus = 0;
        this.l_nMin = 0;
        this.text.removeIf(s -> !this.checkFile(s.entry));
        this.updateList();
        if (this.updateCallback != null) {
            this.updateCallback.run(this.menuHandler, this);
        }
    }

    protected int getListSize() {
        int len = this.displayed.size();
        if (this.saveList && !this.displayed.isEmpty()) {
            ++len;
        }
        return len;
    }

    public abstract boolean checkFile(FileEntry var1);

    public void updateList() {
        this.displayed.clear();
        this.displayed.addAll(this.text);
        if (this.saveList) {
            this.displayed.removeIf(s -> s.name.equals("autosave.sav") || s.name.startsWith("quicksav"));
        }
    }

    @Override
    public void close() {
        this.deleteQuestion = false;
        this.onCancel();
    }

    @Override
    public boolean mouseMoved(int mx, int my) {
        return this.prompt.isCaptured() || this.deleteQuestion;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.deleteQuestion || this.prompt.isCaptured()) {
            return false;
        }
        if (!this.displayed.isEmpty()) {
            int px = this.x;
            int py = this.y;
            int len = this.getListSize();
            int ol_nFocus = this.l_nFocus;
            for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.rowCount && i < len; ++i) {
                if (mx > px && mx < px + this.width - 14 && my > py && my < py + this.font.getSize()) {
                    this.l_nFocus = i;
                    if (ol_nFocus != i && this.updateCallback != null) {
                        this.updateCallback.run(this.menuHandler, this);
                    }
                    return true;
                }
                py += this.mFontOffset();
            }
        }
        return false;
    }

    @Override
    public boolean scrolled(float amountX, float amount) {
        if (this.prompt.isCaptured() || this.deleteQuestion) {
            return true;
        }
        if (amount < 0.0f) {
            this.ListMouseWheelUp(this.menuHandler);
            return true;
        }
        if (amount > 0.0f) {
            this.ListMouseWheelDown(this.menuHandler, this.getListSize());
            return true;
        }
        return false;
    }

    @Override
    public boolean keyRepeat(int keycode) {
        if (this.prompt.isCaptured()) {
            return this.prompt.keyRepeat(keycode);
        }
        return false;
    }

    @Override
    public boolean keyDown(int i) {
        if (this.prompt.isCaptured()) {
            switch (i) {
                case 66: 
                case 96: {
                    this.onConfirm();
                    return true;
                }
                case 111: {
                    this.onCancel();
                    return true;
                }
            }
            return this.prompt.keyDown(i);
        }
        switch (i) {
            case 53: {
                if (!this.deleteQuestion) break;
                this.onEnter();
                return true;
            }
            case 42: {
                if (!this.deleteQuestion) break;
                this.onCancel();
                return true;
            }
            case 112: {
                if (!this.saveList && !this.displayed.isEmpty() && this.l_nFocus != -1 || this.saveList && this.l_nFocus != 0) {
                    this.deleteQuestion = true;
                }
                return true;
            }
            case 19: 
            case 237: {
                this.ListUp(this.menuHandler, this.getListSize());
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 20: 
            case 239: {
                this.ListDown(this.menuHandler, this.getListSize());
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 21: 
            case 240: {
                this.ListLeft(this.menuHandler);
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 22: 
            case 238: {
                this.ListRight(this.menuHandler);
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 66: 
            case 96: {
                this.onEnter();
                return true;
            }
            case 111: {
                this.onCancel();
                return true;
            }
            case 92: {
                this.ListPGUp(this.menuHandler);
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 93: {
                this.ListPGDown(this.menuHandler, this.getListSize());
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 3: {
                this.ListHome(this.menuHandler);
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
            case 123: {
                this.ListEnd(this.menuHandler, this.getListSize());
                if (this.updateCallback != null) {
                    this.updateCallback.run(this.menuHandler, this);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int i) {
        this.prompt.keyUp(i);
        return false;
    }

    @Override
    public boolean keyTyped(char c) {
        if (this.prompt.isCaptured()) {
            this.prompt.keyTyped(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (button == 0) {
            this.onEnter();
            return true;
        }
        if (button == 1) {
            return this.onCancel();
        }
        return false;
    }

    protected void onEnter() {
        if (this.deleteQuestion) {
            this.saveManager.delete(this.getFileEntry());
            this.updateList();
            if (this.l_nFocus >= this.displayed.size()) {
                int len = this.getListSize();
                this.l_nFocus = len - 1;
                this.l_nMin = len - this.rowCount;
                if (this.l_nMin < 0) {
                    this.l_nMin = 0;
                }
            }
            if (this.updateCallback != null) {
                this.updateCallback.run(this.menuHandler, this);
            }
            this.deleteQuestion = false;
            return;
        }
        if (this.saveList) {
            if (!this.prompt.isCaptured()) {
                if (this.l_nFocus > 0 && this.l_nFocus < this.displayed.size()) {
                    this.prompt.setTextInput(this.displayed.get((int)(this.l_nFocus - 1)).name);
                }
                this.prompt.setCaptureInput(true);
            }
        } else {
            this.onConfirm();
        }
    }

    protected void onConfirm() {
        this.typed = this.prompt.getTextInput();
        this.prompt.clear();
        this.prompt.setCaptureInput(false);
        if (this.l_nFocus != -1 && this.confirmCallback != null) {
            this.confirmCallback.run(this.menuHandler, this);
            this.updateList();
        }
    }

    protected boolean onCancel() {
        if (this.prompt.isCaptured()) {
            this.prompt.clear();
            this.prompt.setCaptureInput(false);
            return true;
        }
        if (this.deleteQuestion) {
            this.deleteQuestion = false;
            return true;
        }
        this.ListEscape(this.menuHandler, MenuHandler.MenuOpt.ESC);
        return false;
    }
}

