/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;

public abstract class SliderDrawable {
    public abstract int getSliderWidth();

    public abstract int getSliderRange();

    public abstract int getScrollerWidth();

    public abstract int getScrollerHeight();

    public abstract void drawSliderBackground(int var1, int var2, int var3, int var4);

    public abstract void drawSlider(int var1, int var2, int var3, int var4);

    public abstract void drawScrollerBackground(int var1, int var2, int var3, int var4, int var5);

    public abstract void drawScroller(int var1, int var2, int var3, int var4);

    protected void drawSliderBackground(Renderer renderer, int x, int y, int height, int col) {
        int x1 = Gameutils.coordsConvertXScaled(x, ConvertType.Normal);
        int y1 = Gameutils.coordsConvertYScaled(y);
        int x2 = Gameutils.coordsConvertXScaled(x + this.getSliderRange(), ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(y + height);
        renderer.drawline256(x1 * 4096, y1 * 4096, x2 * 4096, y1 * 4096, col);
        renderer.drawline256(x1 * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        renderer.drawline256(x1 * 4096, y1 * 4096, x1 * 4096, y2 * 4096, col);
        renderer.drawline256(x2 * 4096, y1 * 4096, x2 * 4096, y2 * 4096, col);
    }

    protected void drawSlider(Renderer renderer, int x, int y, int height, int col) {
        int x1 = Gameutils.coordsConvertXScaled(x, ConvertType.Normal);
        int y1 = Gameutils.coordsConvertYScaled(y);
        int x2 = Gameutils.coordsConvertXScaled(x + this.getSliderWidth(), ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(y + height);
        renderer.drawline256(x1 * 4096, y1 * 4096, x2 * 4096, y1 * 4096, col);
        renderer.drawline256(x1 * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        renderer.drawline256(x1 * 4096, y1 * 4096, x1 * 4096, y2 * 4096, col);
        renderer.drawline256(x2 * 4096, y1 * 4096, x2 * 4096, y2 * 4096, col);
    }

    protected void drawScrollerBackground(Renderer renderer, int x, int y, int height, int col) {
        int x1 = Gameutils.coordsConvertXScaled(x - 1, ConvertType.Normal);
        int y1 = Gameutils.coordsConvertYScaled(y - 1);
        int x2 = Gameutils.coordsConvertXScaled(x + this.getScrollerWidth() + 1, ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(y + height + 1);
        renderer.drawline256(x1 * 4096, y1 * 4096, x2 * 4096, y1 * 4096, col);
        renderer.drawline256(x1 * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        renderer.drawline256(x1 * 4096, y1 * 4096, x1 * 4096, y2 * 4096, col);
        renderer.drawline256(x2 * 4096, y1 * 4096, x2 * 4096, y2 * 4096, col);
    }

    protected void drawScroller(Renderer renderer, int x, int y, int col) {
        int x1 = Gameutils.coordsConvertXScaled(x, ConvertType.Normal);
        int y1 = Gameutils.coordsConvertYScaled(y);
        int x2 = Gameutils.coordsConvertXScaled(x + this.getScrollerWidth(), ConvertType.Normal);
        int y2 = Gameutils.coordsConvertYScaled(y + this.getScrollerHeight());
        renderer.drawline256(x1 * 4096, y1 * 4096, x2 * 4096, y1 * 4096, col);
        renderer.drawline256(x1 * 4096, y2 * 4096, x2 * 4096, y2 * 4096, col);
        renderer.drawline256(x1 * 4096, y1 * 4096, x1 * 4096, y2 * 4096, col);
        renderer.drawline256(x2 * 4096, y1 * 4096, x2 * 4096, y2 * 4096, col);
    }
}

