/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Types.MemLog;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCommand;
import ru.m210projects.Build.osd.commands.OsdValueRange;
import ru.m210projects.Build.settings.GameConfig;

public class InitScreen
extends ScreenAdapter {
    private final BuildFactory factory;
    private final BuildGame game;
    private int frames;
    private Engine engine;
    private Thread thread;
    private boolean gameInitialized;
    private boolean disposing;

    public InitScreen(BuildGame game) {
        File f;
        FileEntry entry;
        this.game = game;
        GameConfig cfg = game.pCfg;
        this.factory = game.getFactory();
        Directory gameDirectory = game.cache.getGameDirectory();
        Console.out.println("BUILD engine by Ken Silverman (http://www.advsys.net/ken) \r\n" + game.getTitle() + "(BuildGdx v" + "25.011" + ") by [M210\ufffd] (http://m210.duke4.net)");
        Console.out.println("Current date " + game.date.getLaunchDate());
        String osver = System.getProperty("os.version");
        String jrever = System.getProperty("java.version");
        Console.out.println("Running on " + game.OS + " (version " + osver + ")");
        Console.out.println("\t with JRE version: " + jrever + "\r\n");
        Console.out.println("Initializing resource archives");
        try {
            for (String res : this.factory.resources) {
                FileEntry entry2 = gameDirectory.getEntry(res);
                if (!entry2.exists() || entry2.isDirectory()) continue;
                game.cache.addGroup(entry2, CacheResourceMap.CachePriority.NORMAL);
            }
            Console.out.println("Initializing Build 3D engine");
            this.engine = game.pEngine = this.factory.engine();
        }
        catch (Exception e) {
            e.printStackTrace();
            DialogUtil.showMessage("Build Engine Initialization Error!", String.format("There was a problem initialising the Build engine:\r\n%s\r\nat %s", e, e.getStackTrace()[0]), MessageType.Info);
            this.forceExit("Build Engine Initialization Error! " + String.format("There was a problem initialising the Build engine:\r\n%s\r\nat %s", e, e.getStackTrace()[0]));
            return;
        }
        if (this.engine.loadpics() == 0) {
            DialogUtil.showMessage("Build Engine Initialization Error!", "ART files not found " + gameDirectory.getPath().resolve(this.engine.getTileManager().getTilesPath()), MessageType.Info);
            this.forceExit("ART files not found " + gameDirectory.getPath().resolve(this.engine.getTileManager().getTilesPath()));
            return;
        }
        game.pFonts = this.factory.fonts();
        game.initRenderer();
        game.pInt = new Interpolation();
        game.pSavemgr = new SaveManager();
        if (!(!cfg.isAutoloadFolder() || (entry = gameDirectory.getEntry("autoload")).exists() || (f = new File(gameDirectory.getPath().resolve("autoload").toString())).exists() || f.mkdirs() || f.isDirectory())) {
            Console.out.println("Can't create autoload folder", OsdColor.RED);
        }
        this.thread = new Thread(() -> {
            block5: {
                try {
                    game.pNet = this.factory.net();
                    game.pSlider = this.factory.slider();
                    game.pMenu = this.factory.menus();
                    game.baseDef = this.factory.getBaseDef(this.engine);
                    Mmulti.uninitmultiplayer();
                    this.gameInitialized = game.init();
                    this.ConsoleInit();
                }
                catch (InitializationException ie) {
                    ie.printStackTrace();
                    DialogUtil.showMessage("Initialization exception!", ie.getMessage(), MessageType.Info);
                    this.forceExit("Initialization exception! " + ie.getMessage() + " " + Arrays.toString(ie.getStackTrace()));
                }
                catch (OutOfMemoryError me) {
                    me.printStackTrace();
                    String message = "Memory used: [ " + MemLog.used() + " / " + MemLog.total() + " mb ] \r\nPlease, increase the java's heap size.";
                    DialogUtil.showMessage("OutOfMemory!", message, MessageType.Info);
                    this.forceExit(message);
                }
                catch (FileNotFoundException fe) {
                    fe.printStackTrace();
                    String message = fe.toString();
                    DialogUtil.showMessage("File not found!", message, MessageType.Info);
                    this.forceExit("File not found! " + message);
                }
                catch (Throwable e) {
                    if (this.disposing) break block5;
                    game.ThrowError("InitScreen error [" + e.getClass().getSimpleName() + "]: ", e.getStackTrace());
                }
            }
        });
        this.thread.setName("InitEngine thread");
        this.thread.setDaemon(true);
    }

    @Override
    public void show() {
        this.frames = 0;
        Console.out.setFullscreen(true);
        this.gameInitialized = false;
        this.disposing = false;
    }

    @Override
    public void hide() {
        Console.out.setFullscreen(false);
    }

    private void ConsoleInit() {
        Console.out.registerCommand(new OsdValueRange("r_texturemode", "", 0.0f, 2.0f){

            @Override
            public String getDescription() {
                return "Current texturing mode is " + ((InitScreen)InitScreen.this).game.pCfg.getGlfilter().name();
            }

            @Override
            protected void setCheckedValue(float value) {
                ((InitScreen)InitScreen.this).game.pCfg.setGlfilter(TexFilter.valueOf((int)value));
            }
        });
        Console.out.registerCommand(new OsdValueRange("r_detailmapping", "r_detailmapping: use detail textures", 0.0f, 1.0f){

            @Override
            public float getValue() {
                return ((InitScreen)InitScreen.this).game.pCfg.isDetailMapping() ? 1.0f : 0.0f;
            }

            @Override
            protected void setCheckedValue(float value) {
                ((InitScreen)InitScreen.this).game.pCfg.setDetailMapping(value != 0.0f);
            }
        });
        Console.out.registerCommand(new OsdValueRange("r_glowmapping", "r_detailmapping: use detail textures", 0.0f, 1.0f){

            @Override
            public float getValue() {
                return ((InitScreen)InitScreen.this).game.pCfg.isGlowMapping() ? 1.0f : 0.0f;
            }

            @Override
            protected void setCheckedValue(float value) {
                ((InitScreen)InitScreen.this).game.pCfg.setGlowMapping(value != 0.0f);
            }
        });
        Console.out.registerCommand(new OsdCommand("memusage", "mem usage / total"){

            @Override
            public CommandResponse execute(String[] argv) {
                Console.out.println("Memory used: " + MemLog.used() + " / " + MemLog.total() + " mb");
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("net_bufferjitter", "net_bufferjitter"){

            @Override
            public CommandResponse execute(String[] argv) {
                Console.out.println("bufferjitter: " + ((InitScreen)InitScreen.this).game.pNet.bufferJitter);
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("deb_filelist", "deb_filelist"){

            @Override
            public CommandResponse execute(String[] argv) {
                for (Group g : ((InitScreen)InitScreen.this).game.cache.getGroups()) {
                    Console.out.println(String.format("group: \"%s\" priority: %s", new Object[]{g.getName(), ((InitScreen)InitScreen.this).game.cache.getPriority(g)}), OsdColor.BLUE);
                    for (Entry res : g.getEntries()) {
                        String descr = res.isDirectory() ? "directory" : "file";
                        Console.out.println(String.format("\t    %s: \"%s\"", descr, res));
                    }
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("quit", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                ((InitScreen)InitScreen.this).game.gExit = true;
                return CommandResponse.SILENT_RESPONSE;
            }
        });
    }

    public void start() {
        if (this.thread != null) {
            this.thread.start();
        }
    }

    @Override
    public synchronized void dispose() {
        this.disposing = true;
    }

    @Override
    public synchronized void render(float delta) {
        Renderer renderer = this.game.getRenderer();
        if (!this.disposing && renderer.isInited()) {
            renderer.clearview(0);
            this.factory.drawInitScreen();
            if (this.frames++ > 3 && !this.thread.isAlive()) {
                if (this.gameInitialized) {
                    this.game.show();
                } else {
                    DialogUtil.showMessage("Initialization Error", "InitScreen unknown error!", MessageType.Error);
                    Gdx.app.exit();
                }
            }
            Console.out.draw();
        }
    }

    private void forceExit(String consoleMessage) {
        Console.out.println(consoleMessage, OsdColor.RED);
        Console.out.getLogger().close();
        System.exit(1);
    }
}

