/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import java.util.ArrayList;
import java.util.List;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuText;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.InputListener;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;

public abstract class MessageScreen
extends ScreenAdapter
implements InputListener {
    protected final BuildGame game;
    protected final String header;
    protected final String message;
    protected final MessageType type;
    protected MessageListener messageListener;
    protected float gTicks;
    protected float gShowTime;
    protected boolean maySkipped;
    protected final List<MenuItem> messageItems = new ArrayList<MenuItem>();
    protected final List<MenuItem> variantItems = new ArrayList<MenuItem>();
    protected final MenuVariants variants;

    public MessageScreen(BuildGame game, String header, String message, Font headerFont, Font messageFont, MessageType type) {
        String[] lines;
        this.game = game;
        this.header = header;
        this.message = message;
        this.type = type;
        this.messageItems.add(new MenuText(header, headerFont, 160, 40, 1).setFontShadow(true));
        int y = 55;
        for (String line : lines = message.split("\r")) {
            this.messageItems.add(new MenuText(line, messageFont, 160, y += messageFont.getSize(), 1));
            if (y > 100) break;
        }
        y += messageFont.getSize();
        this.variantItems.add(new MenuText(type == MessageType.Info ? "Press any key" : "Do you want to sent a report?", messageFont, 160, y += messageFont.getSize(), 1));
        this.variants = new MenuVariants(game.pEngine, type == MessageType.Info ? "to continue" : "[Y/N]", messageFont, 160, y += 2 * messageFont.getSize()){

            @Override
            public boolean isFocused() {
                return true;
            }

            @Override
            public void positive(MenuHandler menu) {
                MessageScreen.this.onApproved();
            }

            @Override
            public void negative(MenuHandler handler) {
                MessageScreen.this.onCancel();
            }
        };
        this.variantItems.add(this.variants);
        y += 2 * messageFont.getSize();
        if (type != MessageType.Info) {
            this.variantItems.add(new MenuText("You may leave a comment", messageFont, 160, y += messageFont.getSize(), 1));
            this.variantItems.add(new MenuText("in the console before sending.", messageFont, 160, y + messageFont.getSize(), 1));
        }
        BuildMenu dummyMenu = new BuildMenu(game.pMenu);
        for (MenuItem item : this.messageItems) {
            item.m_pMenu = dummyMenu;
        }
        for (MenuItem item : this.variantItems) {
            item.m_pMenu = dummyMenu;
        }
        this.gShowTime = 1.0f;
        this.gTicks = 0.0f;
        this.maySkipped = false;
    }

    public abstract void drawBackground(Renderer var1);

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public void show() {
        this.game.pNet.ready2send = false;
        this.game.getProcessor().resetPollingStates();
    }

    @Override
    public void render(float delta) {
        float f;
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        this.drawBackground(renderer);
        for (MenuItem item : this.messageItems) {
            item.draw(this.game.pMenu);
        }
        if (this.maySkipped) {
            for (MenuItem item : this.variantItems) {
                item.draw(this.game.pMenu);
            }
        }
        this.gTicks += delta;
        if (f >= this.gShowTime) {
            this.maySkipped = true;
        }
        this.game.pEngine.nextpage(delta);
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (GameKeys.Show_Console.equals(gameKey)) {
            Console.out.onToggle();
            return true;
        }
        if (!this.maySkipped) {
            return true;
        }
        if (this.type == MessageType.Info) {
            this.variants.keyDown(66);
            return true;
        }
        if (GameKeys.Open.equals(gameKey)) {
            return this.variants.keyDown(66);
        }
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            return this.variants.keyDown(111);
        }
        return false;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (!this.maySkipped) {
            return true;
        }
        if (this.type == MessageType.Info) {
            this.variants.keyDown(66);
            return true;
        }
        this.variants.keyDown(keycode);
        return true;
    }

    protected void onApproved() {
        if (this.messageListener != null) {
            this.messageListener.onClose(this.type != MessageType.Info);
            return;
        }
        if (this.game.getScreen() instanceof MessageScreen) {
            this.game.show();
        } else {
            this.game.setPrevScreen();
        }
    }

    protected void onCancel() {
        if (this.type == MessageType.Info) {
            this.onApproved();
            return;
        }
        if (this.messageListener != null) {
            this.messageListener.onClose(false);
            return;
        }
        if (this.game.getScreen() instanceof MessageScreen) {
            this.game.show();
        } else {
            this.game.setPrevScreen();
        }
    }

    public static interface MessageListener {
        public void onClose(boolean var1);
    }
}

