/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.Gdx;
import java.util.Arrays;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;

public abstract class MovieScreen
extends SkippableAdapter {
    protected final int TILE_MOVIE;
    protected Runnable callback;
    protected int gCutsClock;
    protected long LastMS;
    protected MovieFile mvfil;
    protected int frame;
    protected long mvtime;
    protected byte[] opalookup;
    protected int nFlags = 74;
    protected int nScale = 65536;
    protected int nPosX = 160;
    protected int nPosY = 100;

    public MovieScreen(BuildGame game, int nTile) {
        super(game);
        this.TILE_MOVIE = nTile;
    }

    protected abstract MovieFile GetFile(String var1);

    protected abstract void StopAllSounds();

    protected abstract byte[] DoDrawFrame(int var1);

    protected abstract Font GetFont();

    protected abstract void DrawEscText(Font var1, int var2);

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.StopAllSounds();
        this.game.getProcessor().resetPollingStates();
        this.LastMS = this.engine.getCurrentTimeMillis();
        this.game.pNet.ResetTimers();
        this.gCutsClock = 0;
        PaletteManager paletteManager = this.engine.getPaletteManager();
        byte[] palookup = paletteManager.makePalookup(0, null, 0, 0, 0, 0);
        this.opalookup = new byte[palookup.length];
        System.arraycopy(palookup, 0, this.opalookup, 0, this.opalookup.length);
        byte[] remapbuf = new byte[256];
        for (int i = 0; i < remapbuf.length; ++i) {
            remapbuf[i] = (byte)i;
        }
        paletteManager.makePalookup(0, remapbuf, 0, 0, 0, 2);
        this.changepalette(this.mvfil.getPalette());
        this.mvfil.playAudio();
    }

    public MovieScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn) {
        if (this.isInited()) {
            return false;
        }
        return this.open(fn);
    }

    protected boolean open(String fn) {
        float scale;
        if (this.mvfil != null) {
            return false;
        }
        this.mvfil = this.GetFile(fn);
        if (this.mvfil == null) {
            return false;
        }
        Renderer renderer = this.game.getRenderer();
        ArtEntry pic = renderer.getTile(this.TILE_MOVIE);
        if (!(pic instanceof DynamicArtEntry && pic.exists() && pic.getWidth() == this.mvfil.getHeight() && pic.getHeight() == this.mvfil.getWidth() || (pic = this.engine.allocatepermanenttile(this.TILE_MOVIE, this.mvfil.getHeight(), this.mvfil.getWidth())).exists())) {
            return false;
        }
        ((DynamicArtEntry)pic).clearData();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        float kt = (float)pic.getHeight() / (float)pic.getWidth();
        float kv = (float)xdim / (float)ydim;
        if (kv >= kt) {
            scale = (float)ydim / (float)pic.getWidth();
            scale /= (float)ydim / 200.0f;
        } else {
            scale = (float)xdim / (float)pic.getHeight();
            scale /= (float)(4 * ydim) / 960.0f;
        }
        this.nScale = (int)(scale * 65536.0f);
        this.frame = 0;
        this.mvtime = 0L;
        this.LastMS = -1L;
        if (this.game.isCurrentScreen(this)) {
            this.show();
        }
        return true;
    }

    public boolean isInited() {
        return this.mvfil != null;
    }

    protected void changepalette(byte[] pal) {
        if (pal == null || pal.length != 768) {
            return;
        }
        PaletteManager paletteManager = this.engine.getPaletteManager();
        paletteManager.changePalette(pal);
        int white = -1;
        int k = 0;
        for (int i = 0; i < 256; i += 3) {
            int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j <= k) continue;
            k = j;
            white = i;
        }
        if (white == -1) {
            return;
        }
        int palnum = 251;
        byte[] remapbuf = new byte[768];
        Arrays.fill(remapbuf, (byte)white);
        paletteManager.makePalookup(palnum, remapbuf, 0, 1, 0, 1);
    }

    protected boolean play() {
        if (this.game.getProcessor().isKeyJustPressed(-1)) {
            this.anyKeyPressed();
        }
        Renderer renderer = this.game.getRenderer();
        if (this.mvfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getCurrentTimeMillis();
            }
            DynamicArtEntry pic = (DynamicArtEntry)renderer.getTile(this.TILE_MOVIE);
            long ms = this.engine.getCurrentTimeMillis();
            long dt = ms - this.LastMS;
            this.mvtime += dt;
            float tick = this.mvfil.getRate();
            if ((float)this.mvtime >= tick) {
                if (this.frame < this.mvfil.getFrames()) {
                    pic.copyData(this.DoDrawFrame(this.frame));
                    ++this.frame;
                } else {
                    return false;
                }
                this.mvtime -= (long)tick;
            }
            this.LastMS = ms;
            if (!pic.hasSize()) {
                return false;
            }
            renderer.rotatesprite(this.nPosX << 16, this.nPosY << 16, this.nScale, 512, this.TILE_MOVIE, 0, 0, this.nFlags);
            return true;
        }
        return false;
    }

    @Override
    public void skip() {
        this.close();
        super.skip();
    }

    protected void callback() {
        this.close();
        if (this.callback != null) {
            Gdx.app.postRunnable(this.callback);
            this.callback = null;
        }
    }

    @Override
    public void draw(float delta) {
        if (!this.play() && this.skipCallback != null) {
            this.callback();
        }
        if (this.engine.getTotalClock() - this.gCutsClock < 200 && this.escSkip) {
            this.DrawEscText(this.GetFont(), 251);
        }
    }

    public void anyKeyPressed() {
        this.game.getProcessor().prepareNext();
        this.gCutsClock = this.engine.getTotalClock();
    }

    protected void close() {
        if (this.mvfil != null) {
            PaletteManager paletteManager = this.engine.getPaletteManager();
            if (this.opalookup != null) {
                paletteManager.makePalookup(0, this.opalookup, 0, 0, 0, 2);
            }
            paletteManager.setbrightness(paletteManager.getPaletteGamma(), paletteManager.getBasePalette());
            this.mvfil.close();
        }
        this.mvfil = null;
        this.LastMS = -1L;
        this.frame = 0;
    }

    public static interface MovieFile {
        public int getFrames();

        public float getRate();

        public byte[] getFrame(int var1);

        public byte[] getPalette();

        public int getWidth();

        public int getHeight();

        public void close();

        public void playAudio();
    }
}

