/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.PropertyIgnoreCase;

public class IniFile {
    protected Map<String, Integer> context;
    protected List<Integer> pointer;
    protected List<Integer> length;
    protected int nContext = -1;
    protected PropertyIgnoreCase ini;
    protected StringReader reader;
    protected String name;
    protected byte[] data;

    protected IniFile() {
    }

    public IniFile(byte[] data, String name) {
        this.name = Strhandler.toLowerCase(name);
        this.init(data);
    }

    public String getName() {
        return this.name;
    }

    public String getKeyString(String key) {
        String out = this.ini.getPropertyIgnoreCase(key, "");
        return out.trim();
    }

    public String getKeyString(String key, int num) {
        String line = this.ini.getPropertyIgnoreCase(key, "");
        if (line.isEmpty()) {
            return "";
        }
        String[] values = line.split(",");
        if (values.length < num) {
            return "";
        }
        line = values[num];
        line = line.replaceAll("\"", "");
        line = line.trim();
        return line;
    }

    public int getKeyInt(String key, int num) {
        int pos;
        String line = this.ini.getPropertyIgnoreCase(key);
        if (line == null) {
            return 0;
        }
        line = line.trim();
        int startpos = 0;
        int keynum = 0;
        for (pos = 0; pos < line.length(); ++pos) {
            if (line.charAt(pos) != ',') continue;
            if (keynum == num) break;
            ++keynum;
            startpos = pos + 1;
        }
        line = line.substring(startpos, pos);
        if (!(line = line.replaceAll("[^0-9]", "")).isEmpty()) {
            return Integer.parseInt(line);
        }
        return 0;
    }

    public int getKeyInt(String key) {
        String s = this.ini.getPropertyIgnoreCase(key);
        if (s != null && !s.isEmpty()) {
            if (!(s = s.replaceAll("[^0-9-]", "")).isEmpty()) {
                return Integer.parseInt(s);
            }
            return 0;
        }
        return -1;
    }

    protected boolean isContext(String line) {
        return (line = line.trim()).startsWith("[") && line.endsWith("]");
    }

    protected void init(byte[] data) {
        this.data = data;
        if (data == null) {
            return;
        }
        this.ini = new PropertyIgnoreCase();
        this.context = new HashMap<String, Integer>();
        this.pointer = new ArrayList<Integer>();
        this.length = new ArrayList<Integer>();
        int ptr = 0;
        while (ptr < data.length) {
            char c;
            StringBuilder line = new StringBuilder();
            while (ptr < data.length && (c = (char)data[ptr++]) != '\n') {
                line.append(c);
            }
            if (!this.isContext(line.toString())) continue;
            this.pointer.add(ptr - line.length() - 1);
            line = new StringBuilder(Strhandler.toLowerCase(line.toString().replaceAll("[^a-zA-Z0-9_-]", "")));
            this.context.put(line.toString(), this.pointer.size() - 1);
        }
        if (!this.pointer.isEmpty()) {
            for (int i = 0; i < this.pointer.size() - 1; ++i) {
                if (i + 1 >= this.pointer.size()) continue;
                this.length.add(this.pointer.get(i + 1) - this.pointer.get(i));
            }
            this.length.add(data.length - this.pointer.get(this.pointer.size() - 1));
        }
    }

    public boolean set(String context) {
        this.nContext = this.context.getOrDefault(Strhandler.toLowerCase(context), -1);
        if (this.nContext == -1) {
            return false;
        }
        String l = new String(this.data, (int)this.pointer.get(this.nContext), (int)this.length.get(this.nContext));
        if (!l.contains("\\\\")) {
            l = l.replace("\\", "\\\\");
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new StringReader(l);
        try {
            this.ini.clear();
            this.ini.load(this.reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nContext = -1;
            return false;
        }
        return true;
    }

    public void close() {
        if (this.ini != null) {
            this.ini.clear();
        }
    }
}

