/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;

public class SaveManager {
    private final List<SaveInfo> saveInfoList = new ArrayList<SaveInfo>();
    private final HashMap<String, SaveInfo> SavHash = new HashMap();
    public static final int Screenshot = Engine.MAXTILES - 1;

    public SaveInfo getSlot(int num) {
        return this.saveInfoList.get(num);
    }

    public List<SaveInfo> getList() {
        return this.saveInfoList;
    }

    public void add(String savname, long time, FileEntry entry) {
        String filename = entry.getName();
        SaveInfo info = this.SavHash.get(filename);
        if (info == null) {
            info = new SaveInfo(savname, time, entry);
            this.saveInfoList.add(0, info);
            this.SavHash.put(filename, info);
        } else {
            this.saveInfoList.remove(info);
            info.update(savname, time, entry);
            this.saveInfoList.add(0, info);
        }
    }

    public void delete(FileEntry entry) {
        SaveInfo info = this.SavHash.get(entry.getName());
        if (info != null && entry.exists() && entry.delete()) {
            this.saveInfoList.remove(info);
            entry.getParent().revalidate();
        }
    }

    public FileEntry getLast() {
        if (!this.saveInfoList.isEmpty()) {
            return this.saveInfoList.get((int)0).entry;
        }
        return Directory.DUMMY_ENTRY;
    }

    public void sort() {
        Collections.sort(this.saveInfoList);
    }

    public static class SaveInfo
    implements Comparable<SaveInfo> {
        public String name;
        public long time;
        public FileEntry entry;

        public SaveInfo(String name, long time, FileEntry entry) {
            this.update(name, time, entry);
        }

        public void update(String name, long time, FileEntry entry) {
            this.name = name;
            this.time = time;
            this.entry = entry;
        }

        @Override
        public int compareTo(SaveInfo obj) {
            if (obj.time == this.time) {
                return 0;
            }
            return obj.time < this.time ? -1 : 1;
        }
    }
}

