/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Mirror;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.PixmapOutputStream;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.DefaultScreenFade;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.TileManager;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public abstract class AbstractRenderer
implements Renderer {
    public static DefaultScreenFade DEFAULT_SCREEN_FADE = new DefaultScreenFade("Default");
    protected final GameConfig config;
    private final char[] fpsbuffer = new char[32];
    private final byte[] shortbuf = new byte[2];
    private final Mirror mirror = new Mirror();
    public int fpscol = 31;
    public int parallaxyoffs;
    public int parallaxyscale;
    public boolean offscreenrendering;
    public boolean showinvisibility;
    public float TRANSLUSCENT1 = 0.66f;
    public float TRANSLUSCENT2 = 0.33f;
    public int xdimen = -1;
    public int ydimen;
    public int xdimenscale;
    public int xdimscale;
    public int viewingrange;
    public int yxaspect;
    public int xyaspect;
    public int wx1;
    public int wy1;
    public int wx2;
    public int wy2;
    public int windowx1;
    public int windowy1;
    public int windowx2;
    public int windowy2;
    public byte[] gotpic;
    public byte[] gotsector;
    public RenderedSpriteList tSpriteList;
    public int globalposx;
    public int globalposy;
    public int globalposz;
    public float globalhoriz;
    public float globalang;
    public float pitch;
    public int globalcursectnum;
    public int globalvisibility;
    public int globalshade;
    public int globalpal;
    public int cosglobalang;
    public int singlobalang;
    public int cosviewingrangeglobalang;
    public int sinviewingrangeglobalang;
    public int beforedrawrooms = 1;
    public boolean inpreparemirror = false;
    protected Engine engine;
    protected int xdim;
    protected int ydim;
    protected int totalclocklock;
    protected int setviewcnt = 0;
    protected int[] bakwindowx1;
    protected int[] bakwindowy1;
    protected int[] bakwindowx2;
    protected int[] bakwindowy2;
    protected DynamicArtEntry baktile;
    protected TileManager tileManager;
    protected PaletteManager paletteManager;
    protected BoardService boardService;
    private long fpstime = 0L;
    public float backBufferScale = 1.0f;

    public AbstractRenderer(GameConfig config) {
        this.config = config;
        this.gotpic = new byte[Engine.MAXTILES + 7 >> 3];
        this.gotsector = new byte[Engine.MAXSECTORS + 7 >> 3];
        this.tSpriteList = new RenderedSpriteList();
        this.bakwindowx1 = new int[4];
        this.bakwindowy1 = new int[4];
        this.bakwindowx2 = new int[4];
        this.bakwindowy2 = new int[4];
        this.parallaxyoffs = 0;
        this.parallaxyscale = 65536;
    }

    public GameConfig getConfig() {
        return this.config;
    }

    protected boolean isShowFPS() {
        return this.config.isgShowFPS();
    }

    protected float getFpsScale() {
        return this.config.getgFpsScale();
    }

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public ArtEntry getTile(int tilenum) {
        return this.tileManager.getTile(tilenum);
    }

    @Override
    public int getParallaxScale() {
        return this.parallaxyscale;
    }

    @Override
    public void setParallaxScale(int parallaxScale) {
        this.parallaxyscale = parallaxScale;
    }

    @Override
    public int getParallaxOffset() {
        return this.parallaxyoffs;
    }

    @Override
    public void setParallaxOffset(int offset) {
        this.parallaxyoffs = offset;
    }

    @Override
    public void init(Engine engine) {
        this.engine = engine;
        this.tileManager = engine.getTileManager();
        this.paletteManager = engine.getPaletteManager();
        this.boardService = engine.getBoardService();
        byte[] pal = this.paletteManager.getBasePalette();
        this.fpscol = 0;
        int k = 0;
        for (int i = 0; i < 256; i += 3) {
            int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
            if (j <= k) continue;
            k = j;
            this.fpscol = i;
        }
        this.backBufferScale = Gdx.graphics.getBackBufferScale();
    }

    @Override
    public void changepalette(byte[] palette) {
    }

    @Override
    public void setview(int x1, int y1, int x2, int y2) {
        this.windowx1 = x1;
        this.wx1 = x1 << 12;
        this.windowy1 = y1;
        this.wy1 = y1 << 12;
        this.windowx2 = x2;
        this.wx2 = x2 + 1 << 12;
        this.windowy2 = y2;
        this.wy2 = y2 + 1 << 12;
        this.setaspect();
    }

    @Override
    public int getWidth() {
        return this.xdim;
    }

    @Override
    public int getHeight() {
        return this.ydim;
    }

    public void setgotpic(int tilenume) {
        int n = tilenume >> 3;
        this.gotpic[n] = (byte)(this.gotpic[n] | (byte)Engine.pow2char[tilenume & 7]);
    }

    @Override
    public int animateoffs(int tilenum, int nInfo) {
        long clock;
        long index = 0L;
        ArtEntry tile = this.getTile(tilenum);
        int speed = tile.getAnimSpeed();
        if ((nInfo & 0xC000) == 32768) {
            this.shortbuf[0] = (byte)(nInfo & 0xFF);
            this.shortbuf[1] = (byte)(nInfo >>> 8 & 0xFF);
            clock = (long)this.totalclocklock + CRC32.getChecksum(this.shortbuf) >> speed;
        } else {
            clock = this.totalclocklock >> speed;
        }
        int frames = tile.getAnimFrames();
        if (frames > 0) {
            switch (tile.getType()) {
                case OSCIL: {
                    index = clock % ((long)frames * 2L);
                    if (index < (long)frames) break;
                    index = (long)frames * 2L - index;
                    break;
                }
                case FORWARD: {
                    index = clock % (long)(frames + 1);
                    break;
                }
                case BACKWARD: {
                    index = -(clock % (long)(frames + 1));
                    break;
                }
            }
        }
        return (int)index;
    }

    @Override
    public void nextpage() {
        if (this.isShowFPS()) {
            this.printfps(this.getFpsScale());
        }
        this.totalclocklock = this.engine.getTotalClock();
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat) {
        this.rotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, 0, 0, this.xdim - 1, this.ydim - 1);
    }

    protected abstract void drawrooms();

    protected abstract ByteBuffer getFrame(TileData.PixelFormat var1, int var2, int var3);

    @Override
    public int drawrooms(float daposx, float daposy, float daposz, float daang, float dahoriz, int dacursectnum) {
        this.beforedrawrooms = 0;
        this.globalposx = (int)daposx;
        this.globalposy = (int)daposy;
        this.globalposz = (int)daposz;
        this.globalang = Gameutils.BClampAngle(daang);
        this.globalhoriz = dahoriz - 100.0f;
        this.pitch = (float)(-EngineUtils.getAngle(160, (int)(dahoriz - 100.0f))) / 5.688889f;
        this.globalcursectnum = (short)dacursectnum;
        this.totalclocklock = this.engine.getTotalClock();
        this.cosglobalang = (int)Gameutils.BCosAngle(this.globalang);
        this.singlobalang = (int)Gameutils.BSinAngle(this.globalang);
        this.cosviewingrangeglobalang = Pragmas.mulscale(this.cosglobalang, this.viewingrange, 16);
        this.sinviewingrangeglobalang = Pragmas.mulscale(this.singlobalang, this.viewingrange, 16);
        Arrays.fill(this.gotpic, (byte)0);
        Arrays.fill(this.gotsector, (byte)0);
        this.tSpriteList.reset();
        this.drawrooms();
        return 0;
    }

    @Override
    public Mirror preparemirror(int dax, int day, int daz, float daang, float dahoriz, int dawall, int dasector) {
        BoardService boardService = this.engine.getBoardService();
        int x = boardService.getWall(dawall).getX();
        int dx = boardService.getWall(boardService.getWall(dawall).getPoint2()).getX() - x;
        int y = boardService.getWall(dawall).getY();
        int dy = boardService.getWall(boardService.getWall(dawall).getPoint2()).getY() - y;
        int j = dx * dx + dy * dy;
        if (j == 0) {
            return this.mirror;
        }
        int i = (dax - x) * dx + (day - y) * dy << 1;
        this.mirror.setX((x << 1) + Pragmas.scale(dx, i, j) - dax);
        this.mirror.setY((y << 1) + Pragmas.scale(dy, i, j) - day);
        this.mirror.setAngle(Gameutils.BClampAngle((float)(EngineUtils.getAngle(dx, dy) << 1) - daang));
        this.inpreparemirror = true;
        return this.mirror;
    }

    @Override
    public boolean screencapture(OutputStream os, int captureWidth, int captureHeight, TileData.PixelFormat pixelFormat) {
        int xf = Pragmas.divscale(this.xdim, captureWidth, 16);
        int yf = Pragmas.divscale(this.ydim, captureHeight, 16);
        try {
            ByteBuffer frame = this.getFrame(pixelFormat, this.xdim, -this.ydim);
            switch (pixelFormat) {
                case Pal8: {
                    for (int fx = 0; fx < captureWidth; ++fx) {
                        int base = Pragmas.mulscale(fx, xf, 16);
                        for (int fy = 0; fy < captureHeight; ++fy) {
                            int pos = base + Pragmas.mulscale(fy, yf, 16) * this.xdim;
                            StreamUtils.writeByte(os, frame.get(pos));
                        }
                    }
                    return true;
                }
                case Rgb: {
                    for (int fy = 0; fy < captureHeight; ++fy) {
                        int base = Pragmas.mulscale(fy, yf, 16) * this.xdim;
                        for (int fx = 0; fx < captureWidth; ++fx) {
                            int pos = 3 * (base + Pragmas.mulscale(fx, xf, 16));
                            StreamUtils.writeByte(os, frame.get(pos));
                            StreamUtils.writeByte(os, frame.get(pos + 1));
                            StreamUtils.writeByte(os, frame.get(pos + 2));
                        }
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String screencapture(Directory dir, String fn) {
        int d;
        int c;
        int b;
        int a;
        fn = fn.replaceAll("[^a-zA-Z0-9_. \\[\\]-]", "");
        fn = fn.substring(0, fn.lastIndexOf(46) - 4);
        int capturecount = 0;
        while (true) {
            if (capturecount > 9999) {
                return null;
            }
            a = capturecount / 1000 % 10;
            b = capturecount / 100 % 10;
            c = capturecount / 10 % 10;
            d = capturecount % 10;
            if (!dir.getEntry(fn + a + b + c + d + ".png").exists()) break;
            ++capturecount;
        }
        int w = this.xdim;
        int h = this.ydim;
        Path path = dir.getPath().resolve(fn + a + b + c + d + ".png");
        try (PixmapOutputStream os = new PixmapOutputStream(new Pixmap(w, h, Pixmap.Format.RGB888), path);){
            if (this.screencapture(os, w, h, TileData.PixelFormat.Rgb)) {
                String string = path.getFileName().toString();
                return string;
            }
        }
        catch (Exception e) {
            Console.out.println(e.toString(), OsdColor.RED);
        }
        finally {
            dir.revalidate();
        }
        return null;
    }

    @Override
    public byte[] getRenderedPics() {
        return this.gotpic;
    }

    @Override
    public byte[] getRenderedSectors() {
        return this.gotsector;
    }

    @Override
    public RenderedSpriteList getRenderedSprites() {
        return this.tSpriteList;
    }

    @Override
    public void addRenderedSprite(int spritenum) {
        TSprite tspr = (TSprite)this.tSpriteList.obtain();
        tspr.set(this.boardService.getSprite(spritenum));
        tspr.setOwner(spritenum);
    }

    @Override
    public boolean gotPic(int picnum) {
        return (this.gotpic[picnum >> 3] & Engine.pow2char[picnum & 7]) != 0;
    }

    @Override
    public boolean gotSector(int sectnum) {
        return (this.gotsector[sectnum >> 3] & Engine.pow2char[sectnum & 7]) != 0;
    }

    protected void printfps(float scale) {
        if (System.currentTimeMillis() - this.fpstime >= 1000L) {
            int fps = Gdx.graphics.getFramesPerSecond();
            float rate = Gdx.graphics.getDeltaTime() * 1000.0f;
            if (fps <= 9999 && rate <= 9999.0f) {
                Strhandler.buildString(this.fpsbuffer, 0, String.format(Locale.US, "%.2fms %dfps", (double)Math.round(rate * 100.0f) / 100.0, fps));
            }
            this.fpstime = System.currentTimeMillis();
        }
        EngineUtils.getLargeFont().drawText((Renderer)this, this.windowx2 - 1, this.windowy1 + 1, this.fpsbuffer, scale, 0, this.fpscol, TextAlign.Right, Transparent.None, false);
    }
}

