/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;

public class DefaultMapSettings
implements IOverheadMapSettings {
    protected final BoardService boardService;

    public DefaultMapSettings(BoardService boardService) {
        this.boardService = boardService;
    }

    @Override
    public boolean isShowSprites(IOverheadMapSettings.MapView view) {
        return false;
    }

    @Override
    public boolean isShowFloorSprites() {
        return false;
    }

    @Override
    public boolean isShowRedWalls() {
        return true;
    }

    @Override
    public boolean isShowAllPlayers() {
        return false;
    }

    @Override
    public boolean isSpriteVisible(IOverheadMapSettings.MapView view, int index) {
        if (view == IOverheadMapSettings.MapView.Polygons) {
            return false;
        }
        switch (this.boardService.getSprite(index).getCstat() & 0x30) {
            case 0: {
                return true;
            }
            case 16: {
                return false;
            }
            case 32: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isWallVisible(int w, int s) {
        Wall wal = this.boardService.getWall(w);
        Sector sec = this.boardService.getSector(s);
        if (wal.getNextsector() != 0) {
            return wal.getNextwall() <= w && (this.boardService.getSector(wal.getNextsector()).getCeilingz() != sec.getCeilingz() || this.boardService.getSector(wal.getNextsector()).getFloorz() != sec.getFloorz() || ((wal.getCstat() | this.boardService.getWall(wal.getNextwall()).getCstat()) & 0x30) != 0 || !this.isFullMap() && !Engine.show2dsector.getBit(wal.getNextsector()));
        }
        return true;
    }

    @Override
    public int getWallColor(int w, int sec) {
        Wall wal = this.boardService.getWall(w);
        return 31;
    }

    @Override
    public int getSpriteColor(int s) {
        Sprite spr = this.boardService.getSprite(s);
        return 31;
    }

    @Override
    public int getPlayerSprite(int player) {
        return -1;
    }

    @Override
    public int getPlayerPicnum(int player) {
        int spr = this.getPlayerSprite(player);
        return spr != -1 ? (int)this.boardService.getSprite(spr).getPicnum() : -1;
    }

    @Override
    public int getPlayerZoom(int player, int czoom) {
        Sprite pPlayer = this.boardService.getSprite(this.getPlayerSprite(player));
        int nZoom = czoom * (Pragmas.klabs(this.boardService.getSector(pPlayer.getSectnum()).getFloorz() - pPlayer.getZ() >> 8) + pPlayer.getYrepeat());
        return Gameutils.BClipRange(nZoom, 22000, 131072);
    }

    @Override
    public boolean isFullMap() {
        return false;
    }

    @Override
    public boolean isScrollMode() {
        return false;
    }

    @Override
    public int getViewPlayer() {
        return 0;
    }

    @Override
    public int getSpriteX(int spr) {
        return this.boardService.getSprite(spr).getX();
    }

    @Override
    public int getSpriteY(int spr) {
        return this.boardService.getSprite(spr).getY();
    }

    @Override
    public int getSpritePicnum(int spr) {
        return this.boardService.getSprite(spr).getPicnum();
    }

    @Override
    public int getWallX(int w) {
        return this.boardService.getWall(w).getX();
    }

    @Override
    public int getWallY(int w) {
        return this.boardService.getWall(w).getY();
    }
}

