/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Types.PaletteManager;

public class GLFog {
    protected int FOGDISTCONST = 48;
    protected final float FULLVIS_BEGIN = 2.9E30f;
    protected final float FULLVIS_END = 3.0E30f;
    public int shade;
    public int pal;
    public float combvis;
    public boolean nofog;
    public boolean isEnabled;
    protected PaletteManager paletteManager;
    protected final float[] color = new float[4];
    protected float start;
    protected float end;
    protected float curstart;
    protected float curend;
    protected float[] curcolor = new float[4];
    protected GL10 gl;

    public void init(GL10 gl, PaletteManager paletteManager) {
        if (Gdx.graphics.getGLVersion().getVendorString().compareTo("NVIDIA Corporation") == 0) {
            gl.glHint(3156, 4354);
        } else {
            gl.glHint(3156, 4352);
        }
        this.gl = gl;
        gl.glFogi(2917, 9729);
        this.paletteManager = paletteManager;
    }

    public void copy(GLFog src) {
        this.shade = src.shade;
        this.combvis = src.combvis;
        this.pal = src.pal;
    }

    public void clear() {
        this.shade = 0;
        this.combvis = 0.0f;
        this.pal = 0;
    }

    public void calc() {
        int numshades = this.paletteManager.getShadeCount();
        if (this.combvis == 0.0f) {
            this.start = 2.9E30f;
            this.end = 3.0E30f;
        } else if (this.shade >= numshades - 1) {
            this.start = -1.0f;
            this.end = 0.001f;
        } else {
            this.start = this.shade > 0 ? 0.0f : (float)(-(this.FOGDISTCONST * this.shade)) / this.combvis;
            this.end = (float)(this.FOGDISTCONST * (numshades - 1 - this.shade)) / this.combvis;
        }
        Color palookupfog = this.paletteManager.getFogColor(this.pal);
        this.color[0] = (float)palookupfog.r / 63.0f;
        this.color[1] = (float)palookupfog.g / 63.0f;
        this.color[2] = (float)palookupfog.b / 63.0f;
        this.color[3] = 1.0f;
        this.gl.glFogfv(2918, this.color, 0);
        this.gl.glFogf(2915, this.start);
        this.gl.glFogf(2916, this.end);
    }

    public void setFogScale(int var) {
        this.FOGDISTCONST = var;
    }

    public void apply() {
    }

    public void enable() {
        if (!this.nofog) {
            this.isEnabled = true;
            this.gl.glEnable(2912);
        }
    }

    public void disable() {
        this.isEnabled = false;
        this.gl.glDisable(2912);
    }
}

