/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Matrix4;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.GDXRenderer;
import ru.m210projects.Build.Render.GdxRender.Shaders.ShaderManager;
import ru.m210projects.Build.Render.ModelHandle.GLModel;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.GLVoxel;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.Types.Spriteext;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class GDXModelRenderer {
    private final Matrix4 transform = new Matrix4();
    private final GDXRenderer parent;
    private final Engine engine;
    private final BoardService boardService;

    public GDXModelRenderer(GDXRenderer parent) {
        this.parent = parent;
        this.engine = parent.getEngine();
        this.boardService = this.engine.getBoardService();
    }

    public boolean mddraw(GLModel m, Sprite tspr) {
        float b;
        boolean isFloorAligned;
        if (m == null) {
            return false;
        }
        boolean bl = isFloorAligned = (tspr.getCstat() & 0x30) == 32;
        if (m.getType() == ModelInfo.Type.Voxel && isFloorAligned) {
            return false;
        }
        ShaderManager.Shader shader = ShaderManager.Shader.RGBWorldShader;
        if (m.getType() == ModelInfo.Type.Voxel && this.parent.getTexFormat() == TileData.PixelFormat.Pal8) {
            shader = ShaderManager.Shader.IndexedWorldShader;
        }
        this.parent.switchShader(shader);
        DefScript defs = this.parent.defs;
        ShaderManager manager = this.parent.manager;
        Matrix4 transport = this.prepareTransform(m, tspr);
        if (m.getType() == ModelInfo.Type.Voxel) {
            GLVoxel vox = (GLVoxel)m;
            this.transform.translate(-vox.xpiv / 64.0f, -vox.ypiv / 64.0f, -vox.zpiv / 64.0f);
            if (isFloorAligned) {
                this.transform.rotate(-1.0f, 0.0f, 0.0f, 90.0f);
                this.transform.translate(0.0f, -vox.ypiv / 64.0f, -vox.zpiv / 64.0f);
            }
        } else if (m instanceof MDModel) {
            ((MDModel)m).updateanimation(defs.mdInfo, tspr, this.engine.getTimer().getTicsPerSecond(), this.parent.getConfig().isAnimSmoothing());
            if (m.getType() == ModelInfo.Type.Md3) {
                this.transform.scale(0.015625f, 0.015625f, -0.015625f);
            }
        }
        manager.transform(transport);
        manager.frustum(null);
        byte shade = tspr.getShade();
        int pal = tspr.getPal() & 0xFF;
        float alpha = 1.0f;
        int numshades = this.engine.getPaletteManager().getShadeCount();
        float g = b = (float)(numshades - Math.min(Math.max(shade, 0), numshades)) / (float)numshades;
        float r = b;
        if (this.parent.defs != null) {
            Color p = this.parent.defs.texInfo.getTints(pal);
            r *= (float)p.r / 255.0f;
            g *= (float)p.g / 255.0f;
            b *= (float)p.b / 255.0f;
        }
        if ((tspr.getCstat() & 2) != 0) {
            alpha = (tspr.getCstat() & 0x200) == 0 ? this.parent.TRANSLUSCENT1 : this.parent.TRANSLUSCENT2;
        }
        manager.color(r, g, b, alpha);
        manager.textureTransform(this.parent.texture_transform.idt(), 0);
        int vis = this.getVisibility(tspr);
        if (m.getType() != ModelInfo.Type.Voxel) {
            this.parent.calcFog(pal, shade, vis);
        }
        Gdx.gl.glEnable(3042);
        Tile2model t2m = defs.mdInfo.getParams(tspr.getPicnum());
        m.render(pal, shade, t2m != null ? t2m.skinnum : 0, vis, alpha);
        Gdx.gl.glFrontFace(2304);
        return true;
    }

    private int getVisibility(Sprite tspr) {
        int vis = this.parent.globalvisibility;
        if (this.boardService.getSector(tspr.getSectnum()).getVisibility() != 0) {
            vis = Pragmas.mulscale(this.parent.globalvisibility, this.boardService.getSector(tspr.getSectnum()).getVisibility() + 16 & 0xFF, 4);
        }
        return vis;
    }

    private Matrix4 prepareTransform(GLModel m, Sprite tspr) {
        BuildCamera cam = this.parent.cam;
        ArtEntry pic = this.parent.getTile(tspr.getPicnum());
        short orientation = tspr.getCstat();
        boolean xflip = (orientation & 4) != 0;
        boolean yflip = (orientation & 8) != 0;
        boolean isWallAligned = (orientation & 0x30) == 16;
        boolean isFloorAligned = (orientation & 0x30) == 32;
        float xoff = tspr.getXoffset();
        float yoff = yflip ? (float)(-tspr.getYoffset()) : (float)tspr.getYoffset();
        float posx = tspr.getX();
        float posy = tspr.getY();
        float posz = tspr.getZ();
        if (m.getType() == ModelInfo.Type.Voxel) {
            GLVoxel vox = (GLVoxel)m;
            if ((orientation & 0x80) == 0) {
                posz -= (float)(vox.zsiz * tspr.getYrepeat() << 1);
            }
            if (yflip && (orientation & 0x10) == 0) {
                posz += ((float)pic.getHeight() * 0.5f - vox.zpiv) * (float)tspr.getYrepeat() * 8.0f;
            }
        } else {
            if ((orientation & 0x80) != 0 && !isFloorAligned) {
                posz += (float)(pic.getHeight() * tspr.getYrepeat() << 1);
            }
            if (yflip) {
                posz -= (float)(pic.getHeight() * tspr.getYrepeat() << 2);
            }
        }
        float f = (float)tspr.getXrepeat() / 32.0f * m.getScale();
        float g = (float)tspr.getYrepeat() / 32.0f * m.getScale();
        if (!isWallAligned && !isFloorAligned) {
            f *= 0.8f;
        }
        this.transform.setToTranslation(posx / cam.xscale, posy / cam.xscale, posz / cam.yscale);
        float yoffset = 0.0f;
        if (m instanceof MDModel) {
            MDModel md = (MDModel)m;
            this.transform.translate(0.0f, 0.0f, -md.getYOffset(false) * g);
            yoffset = md.getYOffset(true);
        }
        this.transform.scale(f, f, yflip ? -g : g);
        Spriteext sprext = this.parent.defs.mapInfo.getSpriteInfo(tspr.getOwner());
        float ang = tspr.getAng() + (sprext != null ? sprext.angoff : (short)0);
        this.transform.rotate(0.0f, 0.0f, 1.0f, (float)Gameutils.AngleToDegrees(ang));
        this.transform.scale(isFloorAligned ? -1.0f : 1.0f, xflip ^ isFloorAligned ? -1.0f : 1.0f, 1.0f);
        if (m.getType() == ModelInfo.Type.Voxel) {
            this.transform.rotate(0.0f, 0.0f, -1.0f, 90.0f);
        }
        this.transform.translate(-xoff / 64.0f, 0.0f, -yoff / 64.0f - yoffset);
        if (m.isRotating()) {
            this.transform.rotate(0.0f, 0.0f, -1.0f, this.engine.getTotalClock() % 360);
        }
        if (m instanceof MDModel) {
            this.transform.scale(0.01f, 0.01f, 0.01f);
            this.transform.rotate(1.0f, 0.0f, 0.0f, -90.0f);
        }
        Gdx.gl.glEnable(2884);
        if (yflip ^ xflip) {
            Gdx.gl.glFrontFace(m.getType() != ModelInfo.Type.Md2 ? 2305 : 2304);
        } else {
            Gdx.gl.glFrontFace(m.getType() != ModelInfo.Type.Md2 ? 2304 : 2305);
        }
        return this.transform;
    }
}

