/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Scanner.WallFrustum2d;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.LinkedList;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.collections.Pool;

public class RayCaster {
    private static int SEGMENT_INDEX = 0;
    protected final BoardService boardService;
    private final Pool<Segment> pSegmentPool = new Pool<Segment>(() -> new Segment());
    private final Pool<EndPoint> pEndpointPool = new Pool<EndPoint>(() -> new EndPoint());
    protected Array<Segment> segments = new Array(true, 128, Segment.class);
    protected Array<EndPoint> endpoints = new Array(true, 128, EndPoint.class);
    protected SegmentList open = new SegmentList();
    protected byte[] gotwall = new byte[Engine.MAXWALLS >> 3];
    protected byte[] handled = new byte[Engine.MAXWALLS >> 3];
    protected boolean globalcheck;
    protected BuildCamera camera;
    protected Comparator<EndPoint> comparator = (a, b) -> {
        if (a.angle != b.angle) {
            return a.angle > b.angle ? 1 : -1;
        }
        if (a.begin != b.begin) {
            return !a.begin ? 1 : -1;
        }
        return 0;
    };
    protected Comparator<Segment> wallfront = (a, b) -> {
        double cross3;
        boolean t2;
        float x11 = a.p1.x;
        float y11 = a.p1.y;
        float x21 = a.p2.x;
        float y21 = a.p2.y;
        float x12 = b.p1.x;
        float y12 = b.p1.y;
        float x22 = b.p2.x;
        float y22 = b.p2.y;
        float dx = x21 - x11;
        float dy = y21 - y11;
        double f = 0.001;
        double invf = 0.999;
        double py = (double)y12 * 0.999 + (double)y22 * 0.001;
        double px = (double)x12 * 0.999 + (double)x22 * 0.001;
        double cross = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean t1 = cross < 1.0E-5;
        px = (double)x22 * 0.999 + (double)x12 * 0.001;
        py = (double)y22 * 0.999 + (double)y12 * 0.001;
        double cross1 = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean bl = t2 = cross1 < 1.0E-5;
        if (t1 == t2) {
            boolean bl2 = t1 = (double)(dx * (this.camera.getY() - y11) - dy * (this.camera.getX() - x11)) < 1.0E-5;
            if (t2 == t1) {
                return 0;
            }
        }
        t1 = (cross3 = (double)(dx = x22 - x12) * ((py = (double)y11 * 0.999 + (double)y21 * 0.001) - (double)y12) - (double)(dy = y22 - y12) * ((px = (double)x11 * 0.999 + (double)x21 * 0.001) - (double)x12)) < 1.0E-5;
        px = (double)x21 * 0.999 + (double)x11 * 0.001;
        py = (double)y21 * 0.999 + (double)y11 * 0.001;
        double cross4 = (double)dx * (py - (double)y12) - (double)dy * (px - (double)x12);
        boolean bl3 = t2 = cross4 < 1.0E-5;
        if (t1 == t2) {
            if (this.globalcheck && Math.abs(cross) < 1.0E-5 && Math.abs(cross1) < 1.0E-5 && Math.abs(cross3) < 1.0E-5 && Math.abs(cross4) < 1.0E-5 && a.isPortal() && !b.isPortal()) {
                return -1;
            }
            t1 = (double)(dx * (this.camera.getY() - y12) - dy * (this.camera.getX() - x12)) < 1.0E-5;
            return t2 != t1 ? 0 : -1;
        }
        return 1;
    };

    public RayCaster(BoardService boardService) {
        this.boardService = boardService;
    }

    public void init(BuildCamera camera, boolean globalcheck) {
        this.camera = camera;
        this.segments.clear();
        this.endpoints.clear();
        Gameutils.fill(this.gotwall, 0);
        Gameutils.fill(this.handled, 0);
        this.globalcheck = globalcheck;
        this.pSegmentPool.reset();
        this.pEndpointPool.reset();
    }

    public void addSegment(int id, float x1, float y1, float x2, float y2) {
        EndPoint p1 = this.pEndpointPool.obtain();
        EndPoint p2 = this.pEndpointPool.obtain();
        Segment segment = this.pSegmentPool.obtain();
        p1.x = x1;
        p1.y = y1;
        p2.x = x2;
        p2.y = y2;
        p1.segment = segment;
        p2.segment = segment;
        segment.p1 = p1;
        segment.p2 = p2;
        segment.wallid = id;
        this.segments.add(segment);
        this.endpoints.add(p1, p2);
        int n = id >> 3;
        this.handled[n] = (byte)(this.handled[n] | (byte)Engine.pow2char[id & 7]);
    }

    public void update() {
        float cameraX = this.camera.getX();
        float cameraY = this.camera.getY();
        for (int i = 0; i < this.segments.size; ++i) {
            Segment segment = ((Segment[])this.segments.items)[i];
            segment.p1.angle = this.atan2(segment.p1.y - cameraY, segment.p1.x - cameraX);
            segment.p2.angle = this.atan2(segment.p2.y - cameraY, segment.p2.x - cameraX);
            float dAngle = segment.p2.angle - segment.p1.angle;
            if (dAngle <= -2.0f) {
                dAngle += 4.0f;
            }
            if (dAngle > 2.0f) {
                dAngle -= 4.0f;
            }
            segment.p1.begin = (double)dAngle > 0.0;
            segment.p2.begin = !segment.p1.begin;
        }
        this.sweep();
    }

    public float atan2(float dx, float dy) {
        float len = (float)Math.sqrt(dx * dx + dy * dy);
        if (len == 0.0f) {
            return 0.0f;
        }
        dx /= len;
        if (dy >= 0.0f) {
            return dx;
        }
        if (dx >= 0.0f) {
            return 2.0f - dx;
        }
        return -(2.0f + dx);
    }

    public void add(int cursectnum, int z, WallFrustum2d frust) {
        Wall wal = this.boardService.getWall(z);
        Wall wal2 = this.boardService.getWall(wal.getPoint2());
        if (frust == null || frust.sectnum == cursectnum) {
            this.addSegment(z, wal.getX(), wal.getY(), wal2.getX(), wal2.getY());
        } else {
            WallFrustum2d f = frust;
            do {
                if (f.isGreater180()) {
                    this.addSegment(z, wal.getX(), wal.getY(), wal2.getX(), wal2.getY());
                    continue;
                }
                this.addClippedSegment(f, z);
            } while ((f = f.next) != null);
        }
    }

    public void addClippedSegment(WallFrustum2d frustum, int z) {
        Plane[] planes = frustum.planes;
        Wall p1 = this.boardService.getWall(z);
        Wall p2 = this.boardService.getWall(p1.getPoint2());
        float p1x = p1.getX();
        float p1y = p1.getY();
        float p2x = p2.getX();
        float p2y = p2.getY();
        float cameraX = this.camera.getX();
        float cameraY = this.camera.getY();
        for (int i = 0; i < 2; ++i) {
            Vector3 p = planes[i].normal;
            float t1 = p.dot(p1x - cameraX, p1y - cameraY, 0.0f);
            float t2 = p.dot(p2x - cameraX, p2y - cameraY, 0.0f);
            if (t1 < 1.0E-4f && t2 < 1.0E-4f) {
                float angle1 = this.atan2(p1y - cameraY, p1x - cameraX);
                float angle2 = this.atan2(p2y - cameraY, p2x - cameraX);
                float dAngle = angle2 - angle1;
                if (dAngle >= 0.01f) {
                    int n = z >> 3;
                    this.handled[n] = (byte)(this.handled[n] | (byte)Engine.pow2char[z & 7]);
                }
                return;
            }
            if (t1 >= -1.0E-4f == t2 >= -1.0E-4f) continue;
            float r = t1 / (t1 - t2);
            float dx = p2x - p1x;
            float dy = p2y - p1y;
            if (t1 >= -1.0E-4f) {
                p2x = (float)Math.ceil(dx * r + p1x);
                p2y = (float)Math.ceil(dy * r + p1y);
                continue;
            }
            p1x = (float)Math.ceil(dx * r + p1x);
            p1y = (float)Math.ceil(dy * r + p1y);
        }
        this.addSegment(z, p1x, p1y, p2x, p2y);
    }

    public boolean check(int z) {
        if ((this.handled[z >> 3] & Engine.pow2char[z & 7]) == 0) {
            return true;
        }
        return (this.gotwall[z >> 3] & Engine.pow2char[z & 7]) != 0;
    }

    protected void sweep() {
        this.endpoints.sort(this.comparator);
        this.open.clear();
        for (int i = 0; i < 2; ++i) {
            for (int pi = 0; pi < this.endpoints.size; ++pi) {
                EndPoint p = ((EndPoint[])this.endpoints.items)[pi];
                Segment current_old = (Segment)this.open.getFirst();
                while (current_old != null && current_old.isPortal()) {
                    if (i == 1) {
                        int wallid = current_old.wallid;
                        int n = wallid >> 3;
                        this.gotwall[n] = (byte)(this.gotwall[n] | (byte)Engine.pow2char[wallid & 7]);
                    }
                    this.open.remove(current_old);
                    current_old = (Segment)this.open.getFirst();
                }
                if (p.begin) {
                    this.open.add(p.segment, this.wallfront);
                } else {
                    this.open.remove(p.segment);
                }
                if (current_old == null || current_old.equals(this.open.getFirst()) || i != 1 || current_old == null) continue;
                int z = current_old.wallid;
                int n = z >> 3;
                this.gotwall[n] = (byte)(this.gotwall[n] | (byte)Engine.pow2char[z & 7]);
            }
        }
    }

    public class Segment
    extends ListNode<Segment>
    implements Pool.Poolable {
        public EndPoint p1;
        public EndPoint p2;
        public int wallid;

        protected Segment() {
            super(SEGMENT_INDEX++);
        }

        public boolean isPortal() {
            return RayCaster.this.boardService.getWall(this.wallid).getNextsector() != -1;
        }

        public void insertBefore(Segment listNode) {
            this.link(listNode.parent, listNode.prev, listNode);
            listNode.prev = this;
            if (this.prev != null) {
                this.getPrev().next = this;
            }
        }

        public Segment getPrev() {
            return (Segment)this.prev;
        }

        @Override
        public void reset() {
            this.p2 = null;
            this.p1 = null;
            this.prev = null;
            this.next = null;
            this.parent = null;
            this.wallid = -1;
        }

        @Override
        public LinkedList<Segment> getParent() {
            return this.parent;
        }

        @Override
        public Segment get() {
            return this;
        }

        public Segment getValue() {
            return this;
        }
    }

    public class EndPoint {
        public float x;
        public float y;
        public boolean begin;
        public Segment segment;
        public float angle;
    }

    public class SegmentList
    extends LinkedList<Segment> {
        public void add(Segment item, Comparator<Segment> c) {
            if (item == null || this.equals(item.getParent())) {
                return;
            }
            Segment listNode = this.compare(item, c);
            if (listNode == null) {
                this.addLast(item);
            } else {
                item.insertBefore(listNode);
                if (listNode.equals(this.first)) {
                    this.first = item;
                }
                ++this.size;
            }
        }

        @Nullable
        protected Segment compare(ListNode<Segment> item, Comparator<Segment> c) {
            ListNode node;
            for (node = this.first; node != null && c.compare(item.get(), (Segment)node.get()) >= 0; node = node.getNext()) {
            }
            return (Segment)node;
        }

        public void clear() {
            this.last = null;
            this.first = null;
            this.size = 0;
        }
    }
}

