/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import ru.m210projects.Build.Board;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Wall;

public class SectorInfo {
    public Clockdir[] loopinfo = new Clockdir[Engine.MAXWALLS];
    public boolean[] isOccluder = new boolean[Engine.MAXWALLS];
    public boolean[] isContour = new boolean[Engine.MAXWALLS];
    public int[] numloops = new int[Engine.MAXSECTORS];
    public boolean[] hasOccluders = new boolean[Engine.MAXSECTORS];
    public boolean[] isCorrupt = new boolean[Engine.MAXSECTORS];

    public void init(Engine engine) {
        Board board = engine.getBoardService().getBoard();
        for (int i = 0; i < board.getSectorCount(); ++i) {
            Sector sec = board.getSector(i);
            this.hasOccluders[i] = false;
            Clockdir dir = this.clockdir(board.getWall(sec.getWallptr()));
            boolean hasContour = false;
            int numloops = 0;
            int startwall = sec.getWallptr();
            int endwall = sec.getEndWall();
            for (int z = startwall; z <= endwall; ++z) {
                Wall wal = board.getWall(z);
                this.loopinfo[z] = dir == null ? this.clockdir(wal) : dir;
                short nextsector = wal.getNextsector();
                if (dir == Clockdir.CCW && nextsector == -1) {
                    this.isOccluder[z] = true;
                    this.hasOccluders[i] = true;
                } else {
                    this.isOccluder[z] = false;
                }
                boolean bl = this.isContour[z] = dir == Clockdir.CW && nextsector == -1;
                if (wal.getPoint2() >= z) continue;
                ++numloops;
                if (dir == Clockdir.CW) {
                    hasContour = true;
                }
                dir = null;
            }
            this.numloops[i] = numloops;
            if (numloops > 0 && !hasContour) {
                this.isCorrupt[i] = true;
                System.err.println("Error: sector " + i + " doesn't have contour!");
                continue;
            }
            this.isCorrupt[i] = false;
        }
    }

    public boolean isEqualsWalls(Wall w1, Wall w2) {
        return w1.getX() == w2.getX() && w1.getY() == w2.getY() && w1.getPoint2() == w2.getPoint2();
    }

    public Clockdir clockdir(Wall wallstart) {
        Wall wal2;
        int minx = Integer.MAX_VALUE;
        Wall themin = null;
        Wall wal = wallstart;
        do {
            int x;
            if ((x = (wal2 = wal.getWall2()).getX()) >= minx) continue;
            minx = x;
            themin = wal;
        } while (!this.isEqualsWalls(wal = wal2, wallstart));
        if (themin == null) {
            return Clockdir.CW;
        }
        int x0 = themin.getX();
        int y0 = themin.getY();
        int x1 = themin.getWall2().getX();
        int y1 = themin.getWall2().getY();
        int x2 = themin.getWall2().getWall2().getX();
        int y2 = themin.getWall2().getWall2().getY();
        if (y1 >= y2 && y1 <= y0) {
            return Clockdir.CW;
        }
        if (y1 >= y0 && y1 <= y2) {
            return Clockdir.CCW;
        }
        int templong = (x0 - x1) * (y2 - y1) - (x2 - x1) * (y0 - y1);
        if (templong < 0) {
            return Clockdir.CW;
        }
        return Clockdir.CCW;
    }

    public boolean isCorruptSector(int i) {
        return this.isCorrupt[i];
    }

    public boolean isInnerWall(int i) {
        return this.loopinfo[i] == Clockdir.CCW;
    }

    public boolean isContourWall(int i) {
        return this.isContour[i];
    }

    public boolean isOccluderWall(int i) {
        return this.isOccluder[i];
    }

    public boolean hasOccluders(int sectnum) {
        return this.hasOccluders[sectnum];
    }

    public int getNumloops(int sectnum) {
        return this.numloops[sectnum];
    }

    public static enum Clockdir {
        CW(0),
        CCW(1);

        private final int value;

        private Clockdir(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

