/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Scanner;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GdxRender.BuildCamera;
import ru.m210projects.Build.Render.GdxRender.Scanner.PolygonClipper;
import ru.m210projects.Build.Render.GdxRender.Scanner.PotentiallyVisibleSet;
import ru.m210projects.Build.Render.GdxRender.Scanner.VisibleSector;
import ru.m210projects.Build.Render.GdxRender.Scanner.WallFrustum3d;
import ru.m210projects.Build.Render.GdxRender.Tesselator;
import ru.m210projects.Build.Render.GdxRender.WorldMesh;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Types.QuickSort;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.collections.Pool;

public abstract class SectorScanner {
    private final Pool<WallFrustum3d> pFrustumPool = new Pool<WallFrustum3d>(WallFrustum3d::new);
    private final Pool<VisibleSector> pSectorPool = new Pool<VisibleSector>(VisibleSector::new);
    private final Vector2 projPoint = new Vector2();
    private final PotentiallyVisibleSet pvs;
    private final WallFrustum3d[] portqueue;
    private final int queuemask;
    private final VisibleSector[] handled;
    private final WallFrustum3d[] gotviewport;
    private final byte[] gotwall;
    private final byte[] wallflags;
    protected Engine engine;
    public int[] maskwall = new int[Engine.MAXWALLS];
    public int maskwallcnt;
    private Sector skyFloor;
    private Sector skyCeiling;
    private final PolygonClipper cl = new PolygonClipper();
    private final RenderedSpriteList tSpriteList;
    private BuildCamera camera;
    private boolean showinvisibility = false;
    protected QuickSort.IntComparator wallcomp = (o1, o2) -> {
        if (!this.wallfront(o1, o2)) {
            return -1;
        }
        return 0;
    };
    private static final Vector3[] tmpVec = new Vector3[]{new Vector3(), new Vector3(), new Vector3(), new Vector3()};

    public SectorScanner(Engine engine) {
        this.engine = engine;
        this.pvs = new PotentiallyVisibleSet(engine);
        this.portqueue = new WallFrustum3d[512];
        this.queuemask = this.portqueue.length - 1;
        this.tSpriteList = new RenderedSpriteList();
        this.gotviewport = new WallFrustum3d[Engine.MAXSECTORS];
        this.handled = new VisibleSector[Engine.MAXSECTORS];
        this.gotwall = new byte[Engine.MAXWALLS >> 3];
        this.wallflags = new byte[Engine.MAXWALLS];
    }

    public void setShowInvisibility(boolean showinvisibility) {
        this.showinvisibility = showinvisibility;
    }

    public void init() {
        this.pvs.info.init(this.engine);
    }

    public void clear() {
        this.pSectorPool.reset();
        this.pFrustumPool.reset();
    }

    public void process(ArrayList<VisibleSector> sectors, BuildCamera cam, WorldMesh mesh, int sectnum, int width, int height) {
        int frustumSectnum;
        WallFrustum3d pFrustum;
        BoardService boardService = this.engine.getBoardService();
        this.camera = cam;
        if (!boardService.isValidSector(sectnum)) {
            return;
        }
        this.pvs.process(cam, mesh, sectnum);
        Arrays.fill(this.gotviewport, null);
        Gameutils.fill(this.gotwall, 0);
        Gameutils.fill(this.wallflags, 0);
        Arrays.fill(this.handled, null);
        this.skyCeiling = null;
        this.skyFloor = null;
        this.maskwallcnt = 0;
        this.tSpriteList.reset();
        int pqtail = 0;
        int pqhead = 0;
        this.portqueue[pqtail++ & this.queuemask] = this.pFrustumPool.obtain().set(cam, sectnum, width, height);
        this.gotviewport[sectnum] = pFrustum = this.portqueue[pqhead];
        while (pqhead != pqtail) {
            frustumSectnum = pFrustum.sectnum;
            VisibleSector sec = this.handled[frustumSectnum];
            if (this.handled[frustumSectnum] == null) {
                sec = this.pSectorPool.obtain().set(frustumSectnum);
            }
            if (!pFrustum.handled) {
                pFrustum.handled = true;
                Sector sector = boardService.getSector(frustumSectnum);
                if (sector != null) {
                    for (ListNode<Wall> wn = sector.getWallNode(); wn != null; wn = wn.getNext()) {
                        WallFrustum3d portal;
                        Wall wal = wn.get();
                        int z = wn.getIndex();
                        if (!this.pvs.checkWall(z)) continue;
                        short nextsectnum = wal.getNextsector();
                        if (!pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Max, frustumSectnum, z))) continue;
                        int n = z >> 3;
                        this.gotwall[n] = (byte)(this.gotwall[n] | (byte)Engine.pow2char[z & 7]);
                        Sector nextSector = boardService.getSector(nextsectnum);
                        if (sector.isParallaxFloor() && (nextSector == null || !nextSector.isParallaxFloor()) && pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.SkyLower, frustumSectnum, z))) {
                            int n2 = z;
                            this.wallflags[n2] = (byte)(this.wallflags[n2] | 8);
                        }
                        if (sector.isParallaxCeiling() && (nextSector == null || !nextSector.isParallaxCeiling()) && pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.SkyUpper, frustumSectnum, z))) {
                            int n3 = z;
                            this.wallflags[n3] = (byte)(this.wallflags[n3] | 0x10);
                        }
                        if (nextSector == null) continue;
                        if (pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Lower, frustumSectnum, z))) {
                            int n4 = z;
                            this.wallflags[n4] = (byte)(this.wallflags[n4] | 1);
                        }
                        if (pFrustum.wallInFrustum(mesh.getPoints(WorldMesh.Heinum.Upper, frustumSectnum, z))) {
                            int n5 = z;
                            this.wallflags[n5] = (byte)(this.wallflags[n5] | 2);
                        }
                        if (!this.pvs.checkSector(nextsectnum)) continue;
                        if (nextSector != null && ((sector.getCeilingstat() & nextSector.getCeilingstat() & 1) != 0 || (sector.getFloorstat() & nextSector.getFloorstat() & 1) != 0)) {
                            portal = pFrustum.clone(this.pFrustumPool);
                            portal.sectnum = nextsectnum;
                        } else {
                            ArrayList<Tesselator.Vertex> points = mesh.getPoints(WorldMesh.Heinum.Portal, frustumSectnum, z);
                            if (points == null) continue;
                            WallFrustum3d clip = null;
                            boolean bNearPlaneClipped = this.NearPlaneCheck(cam, points);
                            if (bNearPlaneClipped) {
                                float posx = cam.getX();
                                float posy = cam.getY();
                                if (sector.isParallaxCeiling() || sector.isParallaxFloor() || this.projectionToWall(posx, posy, wal, this.projPoint) && Math.abs(posx - this.projPoint.x) + Math.abs(posy - this.projPoint.y) <= cam.near * cam.xscale * 2.0f) {
                                    clip = pFrustum.clone(this.pFrustumPool);
                                    clip.sectnum = nextsectnum;
                                }
                            }
                            if ((frustumSectnum == sectnum || bNearPlaneClipped) && clip == null && (points = this.cl.ClipPolygon(cam.frustum, points)).size() < 3 || wal.isOneWay() && clip == null) continue;
                            if (clip != null) {
                                portal = clip;
                            } else {
                                if (nextSector != null && !nextSector.isParallaxCeiling() && !nextSector.isParallaxFloor() && !pFrustum.wallInFrustum(points)) continue;
                                portal = pFrustum.build(cam, this.pFrustumPool, points, nextsectnum);
                            }
                        }
                        if (portal == null) continue;
                        int n6 = z;
                        this.wallflags[n6] = (byte)(this.wallflags[n6] | 4);
                        if (this.gotviewport[nextsectnum] == null) {
                            this.portqueue[pqtail++ & this.queuemask] = this.gotviewport[nextsectnum] = portal;
                            continue;
                        }
                        WallFrustum3d nextp = this.gotviewport[nextsectnum];
                        if ((nextp = nextp.expand(portal)) == null || this.handled[nextsectnum] == null) continue;
                        this.portqueue[pqtail++ & this.queuemask] = nextp;
                    }
                }
            }
            if (this.handled[frustumSectnum] == null) {
                this.handled[frustumSectnum] = sec;
            }
            if (pFrustum.next != null) {
                pFrustum = pFrustum.next;
                continue;
            }
            pFrustum = this.portqueue[++pqhead & this.queuemask];
        }
        pqtail = 0;
        pqhead = 0;
        this.portqueue[pqtail++ & this.queuemask] = this.gotviewport[sectnum];
        this.gotviewport[sectnum] = null;
        do {
            pFrustum = this.portqueue[pqhead++ & this.queuemask];
            frustumSectnum = pFrustum.sectnum;
            Sector sector = boardService.getSector(frustumSectnum);
            VisibleSector sec = this.handled[frustumSectnum];
            if (sec == null || sector == null) continue;
            if (Engine.automapping == 1) {
                Engine.show2dsector.setBit(frustumSectnum);
            }
            boolean isParallaxCeiling = sector.isParallaxCeiling();
            boolean isParallaxFloor = sector.isParallaxFloor();
            for (ListNode<Wall> wn = sector.getWallNode(); wn != null; wn = wn.getNext()) {
                Wall wal = wn.get();
                int z = wn.getIndex();
                short nextsectnum = wal.getNextsector();
                if ((this.gotwall[z >> 3] & Engine.pow2char[z & 7]) == 0) continue;
                if (nextsectnum != -1 && this.gotviewport[nextsectnum] != null) {
                    this.portqueue[pqtail++ & this.queuemask] = this.gotviewport[nextsectnum];
                    this.gotviewport[nextsectnum] = null;
                }
                if (wal.isMasked() || wal.isOneWay()) {
                    this.maskwall[this.maskwallcnt++] = z;
                }
                if ((this.wallflags[z] & 0x18) != 0) {
                    int n = z;
                    this.wallflags[n] = (byte)(this.wallflags[n] & 0xFFFFFFE7);
                    if (isParallaxCeiling && this.engine.getTile(sector.getCeilingpicnum()).hasSize()) {
                        this.skyCeiling = sector;
                    }
                    if (isParallaxFloor && this.engine.getTile(sector.getFloorpicnum()).hasSize()) {
                        this.skyFloor = sector;
                    }
                    sec.skywalls.add(z);
                }
                sec.walls.add(z);
                sec.wallflags.add(this.wallflags[z]);
            }
            byte secflags = 0;
            if (!isParallaxFloor && this.isSectorVisible(pFrustum, cam.frustum.planes[0], true, frustumSectnum)) {
                secflags = (byte)(secflags | 1);
            }
            if (!isParallaxCeiling && this.isSectorVisible(pFrustum, cam.frustum.planes[0], false, frustumSectnum)) {
                secflags = (byte)(secflags | 2);
            }
            this.checkSprites(pFrustum, frustumSectnum);
            sec.secflags = secflags;
            sec.setFrustum(pFrustum.getPlanes());
            sectors.add(sec);
        } while (pqhead != pqtail);
        QuickSort.sort(this.maskwall, this.maskwallcnt, this.wallcomp);
    }

    protected boolean wallfront(int o1, int o2) {
        double cross3;
        boolean t2;
        BoardService boardService = this.engine.getBoardService();
        Wall w1 = boardService.getWall(o1);
        Wall w2 = boardService.getWall(o2);
        if (w1 == null || w2 == null) {
            return true;
        }
        Wall wp1 = w1.getWall2();
        float x11 = w1.getX();
        float y11 = w1.getY();
        float x21 = wp1.getX();
        float y21 = wp1.getY();
        Wall wp2 = w2.getWall2();
        float x12 = w2.getX();
        float y12 = w2.getY();
        float x22 = wp2.getX();
        float y22 = wp2.getY();
        float dx = x21 - x11;
        float dy = y21 - y11;
        double f = 0.001;
        double invf = 0.999;
        double py = (double)y12 * 0.999 + (double)y22 * 0.001;
        double px = (double)x12 * 0.999 + (double)x22 * 0.001;
        double cross = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean t1 = cross < 1.0E-5;
        px = (double)x22 * 0.999 + (double)x12 * 0.001;
        py = (double)y22 * 0.999 + (double)y12 * 0.001;
        double cross1 = (double)dx * (py - (double)y11) - (double)dy * (px - (double)x11);
        boolean bl = t2 = cross1 < 1.0E-5;
        if (t1 == t2) {
            boolean bl2 = t1 = (double)(dx * (this.camera.getY() - y11) - dy * (this.camera.getX() - x11)) < 1.0E-5;
            if (t2 == t1) {
                return true;
            }
        }
        t1 = (cross3 = (double)(dx = x22 - x12) * ((py = (double)y11 * 0.999 + (double)y21 * 0.001) - (double)y12) - (double)(dy = y22 - y12) * ((px = (double)x11 * 0.999 + (double)x21 * 0.001) - (double)x12)) < 1.0E-5;
        px = (double)x21 * 0.999 + (double)x11 * 0.001;
        py = (double)y21 * 0.999 + (double)y11 * 0.001;
        double cross4 = (double)dx * (py - (double)y12) - (double)dy * (px - (double)x12);
        boolean bl3 = t2 = cross4 < 1.0E-5;
        if (t1 == t2) {
            t1 = (double)(dx * (this.camera.getY() - y12) - dy * (this.camera.getX() - x12)) < 1.0E-5;
            return t2 != t1;
        }
        return false;
    }

    public Sector getLastSkySector(WorldMesh.Heinum h) {
        if (h == WorldMesh.Heinum.SkyLower) {
            return this.skyFloor;
        }
        return this.skyCeiling;
    }

    private boolean checkWallRange(Sector sector, int z) {
        return z >= sector.getWallptr() && z < sector.getWallptr() + sector.getWallnum();
    }

    private void checkSprites(WallFrustum3d pFrustum, int sectnum) {
        BoardService service = this.engine.getBoardService();
        float x = pFrustum.getCamera().getX();
        float y = pFrustum.getCamera().getY();
        for (ListNode<Sprite> node = service.getSectNode(sectnum); node != null; node = node.getNext()) {
            int z = node.getIndex();
            Sprite spr = node.get();
            if ((spr.getCstat() & 0x8000) != 0 && !this.showinvisibility || spr.getXrepeat() <= 0 || spr.getYrepeat() <= 0) continue;
            int xs = (int)((float)spr.getX() - x);
            int ys = (int)((float)spr.getY() - y);
            if ((spr.getCstat() & 0x70) == 80 && Pragmas.dmulscale(EngineUtils.cos(spr.getAng()), -xs, EngineUtils.sin(spr.getAng()), -ys, 6) <= 0 || !this.spriteInFrustum(pFrustum, spr)) continue;
            this.addTSprite(z);
        }
    }

    public boolean spriteInFrustum(WallFrustum3d frustum, Sprite tspr) {
        Vector3[] points = tmpVec;
        float SIZEX = 0.5f;
        float SIZEY = 0.5f;
        Matrix4 mat = this.getSpriteMatrix(tspr);
        if (mat != null) {
            points[0].set(-SIZEX, SIZEY, 0.0f).mul(mat);
            points[1].set(SIZEX, SIZEY, 0.0f).mul(mat);
            points[2].set(SIZEX, -SIZEY, 0.0f).mul(mat);
            points[3].set(-SIZEX, -SIZEY, 0.0f).mul(mat);
            WallFrustum3d n = frustum;
            do {
                if (!n.wallInFrustum(points, 4)) continue;
                return true;
            } while ((n = n.next) != null);
        }
        return false;
    }

    protected abstract Matrix4 getSpriteMatrix(Sprite var1);

    private void addTSprite(int spritenum) {
        Sprite spr = this.engine.getBoardService().getSprite(spritenum);
        if (spr != null) {
            TSprite tspr = (TSprite)this.tSpriteList.obtain();
            tspr.set(spr);
            tspr.setOwner(spritenum);
        }
    }

    private boolean isSectorVisible(WallFrustum3d frustum, Plane near, boolean isFloor, int sectnum) {
        int i;
        frustum.rebuild();
        BoardService boardService = this.engine.getBoardService();
        Sector sec = boardService.getSector(sectnum);
        if (sec == null) {
            return false;
        }
        float positionZ = frustum.getCamera().getZ();
        int n = i = near == null ? 0 : -1;
        while (i < frustum.planes.length) {
            block5: {
                Plane plane = i == -1 ? near : frustum.planes[i];
                for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                    int wz;
                    Wall wal = wn.get();
                    int n2 = wz = isFloor ? this.engine.getflorzofslope((short)sectnum, wal.getX(), wal.getY()) : this.engine.getceilzofslope((short)sectnum, wal.getX(), wal.getY());
                    if (isFloor && !sec.isFloorSlope() && positionZ > (float)wz || !isFloor && !sec.isCeilingSlope() && positionZ < (float)wz || plane == null || plane.testPoint(wal.getX(), wal.getY(), wz) == Plane.PlaneSide.Back) {
                        continue;
                    }
                    break block5;
                }
                if (frustum.next != null) {
                    return this.isSectorVisible(frustum.next, null, isFloor, sectnum);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean NearPlaneCheck(BuildCamera cam, ArrayList<? extends Vector3> points) {
        Plane near = cam.frustum.planes[0];
        for (int i = 0; i < points.size(); ++i) {
            if (near.testPoint(points.get(i)) != Plane.PlaneSide.Back) continue;
            return true;
        }
        return false;
    }

    public boolean projectionToWall(float posx, float posy, Wall w, Vector2 n) {
        Wall p2 = w.getWall2();
        int dx = p2.getX() - w.getX();
        int dy = p2.getY() - w.getY();
        float i = (float)dx * (posx - (float)w.getX()) + (float)dy * (posy - (float)w.getY());
        if (i < 0.0f) {
            n.set(w.getX(), w.getY());
            return false;
        }
        float j = dx * dx + dy * dy;
        if (i > j) {
            n.set(p2.getX(), p2.getY());
            return false;
        }
        n.set((float)dx * (i /= j) + (float)w.getX(), (float)dy * i + (float)w.getY());
        return true;
    }

    public int getSpriteCount() {
        return this.tSpriteList.getSize();
    }

    public RenderedSpriteList getSprites() {
        return this.tSpriteList;
    }

    public int getMaskwallCount() {
        return this.maskwallcnt;
    }

    public int[] getMaskwalls() {
        return this.maskwall;
    }
}

