/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.GdxRender.Shaders;

public class SkyShader {
    public static final String vertex = "#version 110\nattribute vec4 a_position;\nuniform mat4 u_projTrans;\nuniform mat4 u_transform;\nuniform bool u_mirror;\nvarying vec4 v_pos;\n\nvoid main()\n{\n    v_pos = u_transform * a_position;\n    gl_Position = u_projTrans * v_pos;\n    if(u_mirror)\n        gl_Position.x *= -1.0;\n}\n";
    public static final String fragment = "#version 110\n#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform sampler2D u_palette;\nuniform sampler2D u_palookup;\nuniform int u_numshades;\nuniform int u_shade;\nuniform float u_alpha;\nuniform vec3 u_camera;\nvarying vec4 v_pos;\nconst float PI = 3.1415926538;\n\nfloat getpalookup(int dashade) {\n    float shade = (min(max(float(dashade), 0.0), float(u_numshades - 1)));\n    return shade / 64.0;\n}\n\nvoid main()\n{\n    vec4 pix = normalize(v_pos - vec4(u_camera, 1.0));\n    vec2 uv = vec2((atan(pix.y, pix.x) + PI) / (2.0 * PI), pix.z / 2.0);\n    uv = uv + 0.5;\n    float fi = texture2D(u_texture, uv).r;\n    if(fi == 1.0) fi -= 0.5 / 256.0;\n    float index = texture2D(u_palookup, vec2(fi, getpalookup(u_shade))).r;\n    if(index == 1.0) index -= 0.5 / 256.0;\n    gl_FragColor = vec4(texture2D(u_palette, vec2(index, 0.0)).rgb, u_alpha);\n}";
    public static final String fragmentRGB = "uniform sampler2D u_texture;\nuniform vec3 u_camera;\nvarying vec4 v_pos;\nconst float PI = 3.1415926538;\n\nvoid main()\n{\n    vec4 pix = normalize(v_pos - vec4(u_camera, 1.0));\n    vec2 uv = vec2((atan(pix.y, pix.x) + PI) / (2.0 * PI), pix.z / 2.0);\n    uv = uv + 0.5;\n    gl_FragColor = texture2D(u_texture, uv);\n}";
}

