/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD2;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Header;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Triangle;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class MD2Builder {
    public final MD2Header header;
    public MD2Triangle[] triangles;
    public float[][] texCoords;
    public MD2Frame[] frames;
    public int[] glcmds;

    public MD2Builder(MD2Info md) throws IOException {
        Entry bb = md.getFileEntry();
        this.header = md.header;
        this.triangles = this.loadTriangles(bb);
        this.texCoords = this.loadTexCoords(bb);
        this.frames = this.loadFrames(bb);
        this.glcmds = this.loadGLCommands(bb);
    }

    private MD2Frame[] loadFrames(Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, this.header.offsetFrames);
            MD2Frame[] frames = new MD2Frame[this.header.numFrames];
            for (int i = 0; i < this.header.numFrames; ++i) {
                MD2Frame frame = new MD2Frame();
                frame.vertices = new float[this.header.numVertices][3];
                float scaleX = StreamUtils.readFloat(is);
                float scaleY = StreamUtils.readFloat(is);
                float scaleZ = StreamUtils.readFloat(is);
                float transX = StreamUtils.readFloat(is);
                float transY = StreamUtils.readFloat(is);
                float transZ = StreamUtils.readFloat(is);
                frame.name = StreamUtils.readString(is, 16);
                for (int j = 0; j < this.header.numVertices; ++j) {
                    float x = (float)StreamUtils.readUnsignedByte(is) * scaleX + transX;
                    float y = (float)StreamUtils.readUnsignedByte(is) * scaleY + transY;
                    float z = (float)StreamUtils.readUnsignedByte(is) * scaleZ + transZ;
                    StreamUtils.readUnsignedByte(is);
                    frame.vertices[j][0] = x;
                    frame.vertices[j][1] = y;
                    frame.vertices[j][2] = z;
                }
                frames[i] = frame;
            }
            MD2Frame[] mD2FrameArray = frames;
            return mD2FrameArray;
        }
    }

    private MD2Triangle[] loadTriangles(Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, this.header.offsetTriangles);
            MD2Triangle[] triangles = new MD2Triangle[this.header.numTriangles];
            for (int i = 0; i < this.header.numTriangles; ++i) {
                MD2Triangle triangle = new MD2Triangle();
                triangle.vertices[0] = StreamUtils.readShort(is);
                triangle.vertices[1] = StreamUtils.readShort(is);
                triangle.vertices[2] = StreamUtils.readShort(is);
                triangle.texCoords[0] = StreamUtils.readShort(is);
                triangle.texCoords[1] = StreamUtils.readShort(is);
                triangle.texCoords[2] = StreamUtils.readShort(is);
                triangles[i] = triangle;
            }
            MD2Triangle[] mD2TriangleArray = triangles;
            return mD2TriangleArray;
        }
    }

    private int[] loadGLCommands(Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, this.header.offsetGLCommands);
            int[] glcmds = new int[this.header.numGLCommands];
            for (int i = 0; i < this.header.numGLCommands; ++i) {
                glcmds[i] = StreamUtils.readInt(is);
            }
            int[] nArray = glcmds;
            return nArray;
        }
    }

    private float[][] loadTexCoords(Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, this.header.offsetTexCoords);
            float[][] texCoords = new float[this.header.numTexCoords][2];
            float width = this.header.skinWidth;
            float height = this.header.skinHeight;
            for (int i = 0; i < this.header.numTexCoords; ++i) {
                short u = StreamUtils.readShort(is);
                short v = StreamUtils.readShort(is);
                texCoords[i][0] = (float)u / width;
                texCoords[i][1] = (float)v / height;
            }
            float[][] fArray = texCoords;
            return fArray;
        }
    }
}

