/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.HashMap;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Frame;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Header;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Shader;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Surface;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Vertice;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class MD3Builder {
    public MD3Header head;
    public MD3Frame[] frames;
    public HashMap<String, Matrix4>[] tags;
    public MD3Surface[] surfaces;

    public MD3Builder(MD3Info md) throws IOException {
        Entry bb = md.getFileEntry();
        this.head = md.header;
        MD3Frame[] frames = this.loadFrames(this.head, bb);
        HashMap<String, Matrix4>[] tags = this.loadTags(this.head, bb);
        MD3Surface[] surfaces = this.loadSurfaces(this.head, bb);
        this.frames = frames;
        this.tags = tags;
        this.surfaces = surfaces;
    }

    private MD3Frame[] loadFrames(MD3Header header, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, header.offsetFrames);
            MD3Frame[] out = new MD3Frame[header.numFrames];
            for (int i = 0; i < header.numFrames; ++i) {
                MD3Frame frame = new MD3Frame();
                frame.min = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                frame.max = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                frame.origin = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                frame.radius = Float.valueOf(StreamUtils.readFloat(is));
                frame.name = StreamUtils.readString(is, 16);
                out[i] = frame;
            }
            MD3Frame[] mD3FrameArray = out;
            return mD3FrameArray;
        }
    }

    private HashMap<String, Matrix4>[] loadTags(MD3Header header, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, header.offsetTags);
            HashMap[] out = new HashMap[header.numFrames];
            for (int k = 0; k < header.numFrames; ++k) {
                out[k] = new HashMap();
                for (int i = 0; i < header.numTags; ++i) {
                    String tagName = StreamUtils.readString(is, 64);
                    Vector3 pos = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                    Vector3 xAxis = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                    Vector3 yAxis = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                    Vector3 zAxis = new Vector3(StreamUtils.readFloat(is), StreamUtils.readFloat(is), StreamUtils.readFloat(is));
                    Matrix4 mat = new Matrix4();
                    mat.set(xAxis, yAxis, zAxis, pos);
                    out[k].put(tagName, mat);
                }
            }
            HashMap[] hashMapArray = out;
            return hashMapArray;
        }
    }

    private MD3Surface[] loadSurfaces(MD3Header header, Entry bb) throws IOException {
        int offsetSurfaces = header.offsetSurfaces;
        MD3Surface[] out = new MD3Surface[header.numSurfaces];
        for (int i = 0; i < header.numSurfaces; ++i) {
            try (InputStream is = bb.getInputStream();){
                StreamUtils.skip(is, offsetSurfaces);
                MD3Surface surf = new MD3Surface();
                surf.id = StreamUtils.readInt(is);
                surf.nam = StreamUtils.readString(is, 64);
                surf.flags = StreamUtils.readInt(is);
                surf.numframes = StreamUtils.readInt(is);
                surf.numshaders = StreamUtils.readInt(is);
                surf.numverts = StreamUtils.readInt(is);
                surf.numtris = StreamUtils.readInt(is);
                surf.ofstris = StreamUtils.readInt(is);
                surf.ofsshaders = StreamUtils.readInt(is);
                surf.ofsuv = StreamUtils.readInt(is);
                surf.ofsxyzn = StreamUtils.readInt(is);
                surf.ofsend = StreamUtils.readInt(is);
                surf.tris = this.loadTriangles(surf, offsetSurfaces, bb);
                surf.shaders = this.loadShaders(surf, offsetSurfaces, bb);
                surf.uv = this.loadUVs(surf, offsetSurfaces, bb);
                surf.xyzn = this.loadVertices(surf, offsetSurfaces, bb);
                offsetSurfaces += surf.ofsend;
                out[i] = surf;
                continue;
            }
        }
        return out;
    }

    private int[][] loadTriangles(MD3Surface surf, int offsetSurfaces, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, offsetSurfaces + surf.ofstris);
            int[][] out = new int[surf.numtris][3];
            for (int i = 0; i < surf.numtris; ++i) {
                out[i][0] = StreamUtils.readInt(is);
                out[i][1] = StreamUtils.readInt(is);
                out[i][2] = StreamUtils.readInt(is);
            }
            int[][] nArray = out;
            return nArray;
        }
    }

    private FloatBuffer loadUVs(MD3Surface surf, int offsetSurfaces, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, offsetSurfaces + surf.ofsuv);
            FloatBuffer out = BufferUtils.newFloatBuffer(2 * surf.numverts);
            for (int i = 0; i < surf.numverts; ++i) {
                out.put(StreamUtils.readFloat(is));
                out.put(StreamUtils.readFloat(is));
            }
            out.flip();
            FloatBuffer floatBuffer = out;
            return floatBuffer;
        }
    }

    private MD3Vertice[][] loadVertices(MD3Surface surf, int offsetSurfaces, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, offsetSurfaces + surf.ofsxyzn);
            MD3Vertice[][] out = new MD3Vertice[surf.numframes][surf.numverts];
            for (int i = 0; i < surf.numframes; ++i) {
                for (int j = 0; j < surf.numverts; ++j) {
                    MD3Vertice xyzn = new MD3Vertice();
                    xyzn.x = StreamUtils.readShort(is);
                    xyzn.y = StreamUtils.readShort(is);
                    xyzn.z = StreamUtils.readShort(is);
                    xyzn.nlat = (short)StreamUtils.readUnsignedByte(is);
                    xyzn.nlng = (short)StreamUtils.readUnsignedByte(is);
                    out[i][j] = xyzn;
                }
            }
            MD3Vertice[][] mD3VerticeArray = out;
            return mD3VerticeArray;
        }
    }

    private MD3Shader[] loadShaders(MD3Surface surf, int offsetSurfaces, Entry bb) throws IOException {
        try (InputStream is = bb.getInputStream();){
            StreamUtils.skip(is, offsetSurfaces + surf.ofsshaders);
            MD3Shader[] out = new MD3Shader[surf.numshaders];
            for (int i = 0; i < surf.numshaders; ++i) {
                MD3Shader shader = new MD3Shader();
                shader.name = StreamUtils.readString(is, 64);
                shader.index = StreamUtils.readInt(is);
                out[i] = shader;
            }
            MD3Shader[] mD3ShaderArray = out;
            return mD3ShaderArray;
        }
    }
}

