/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import java.io.IOException;
import java.io.InputStream;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Header;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class MD3Info
extends MDInfo {
    public final MD3Header header;

    public MD3Info(Entry res) throws Exception {
        super(res, ModelInfo.Type.Md3);
        this.header = this.loadHeader(res);
        if (this.header.ident != 860898377 || this.header.version != 15) {
            throw new Exception("Wrong file header IDP3");
        }
        try (InputStream is = res.getInputStream();){
            StreamUtils.skip(is, this.header.offsetFrames);
            this.frames = new String[this.header.numFrames];
            this.numframes = this.header.numFrames;
            for (int i = 0; i < this.header.numFrames; ++i) {
                StreamUtils.skip(is, 40);
                this.frames[i] = StreamUtils.readString(is, 16);
            }
        }
    }

    protected MD3Header loadHeader(Entry res) throws IOException {
        try (InputStream is = res.getInputStream();){
            MD3Header header = new MD3Header();
            header.ident = StreamUtils.readInt(is);
            header.version = StreamUtils.readInt(is);
            header.filename = StreamUtils.readString(is, 64);
            header.flags = StreamUtils.readInt(is);
            header.numFrames = StreamUtils.readInt(is);
            header.numTags = StreamUtils.readInt(is);
            header.numSurfaces = StreamUtils.readInt(is);
            header.numSkins = StreamUtils.readInt(is);
            header.offsetFrames = StreamUtils.readInt(is);
            header.offsetTags = StreamUtils.readInt(is);
            header.offsetSurfaces = StreamUtils.readInt(is);
            header.offsetEnd = StreamUtils.readInt(is);
            MD3Header mD3Header = header;
            return mD3Header;
        }
    }
}

