/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.ModelHandle.MDModel.MD3;

import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Builder;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Surface;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Vertice;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MDModel;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.Types.GL10;

public abstract class MD3ModelGL10
extends MDModel {
    private final ShortBuffer indices;
    private final FloatBuffer vertices;
    private final MD3Surface[] surfaces;
    private final int numSurfaces;
    private final GL10 gl10;

    public MD3ModelGL10(GL10 gl10, MD3Info md) throws IOException {
        super(md);
        this.gl10 = gl10;
        MD3Builder builder = new MD3Builder(md);
        this.surfaces = builder.surfaces;
        this.numSurfaces = builder.head.numSurfaces;
        int maxtris = 0;
        int maxverts = 0;
        for (int i = 0; i < this.numSurfaces; ++i) {
            MD3Surface surf = this.surfaces[i];
            maxtris = Math.max(maxtris, surf.numtris);
            maxverts = Math.max(maxverts, surf.numverts);
        }
        this.indices = BufferUtils.newShortBuffer(maxtris * 3);
        this.vertices = BufferUtils.newFloatBuffer(maxverts * 3);
    }

    protected abstract int bindSkin(int var1, int var2, int var3);

    @Override
    public boolean render(int pal, int pad1, int skinnum, int pad2, float pad3) {
        boolean isRendered = false;
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            int i;
            MD3Surface s = this.surfaces[surfi];
            int texunits = this.bindSkin(pal, skinnum, surfi);
            if (texunits == -1) break;
            this.vertices.clear();
            for (i = 0; i < s.numverts; ++i) {
                MD3Vertice v0 = s.xyzn[this.cframe][i];
                MD3Vertice v1 = s.xyzn[this.nframe][i];
                this.vertices.put((float)v0.x * this.cScale.x + (float)v1.x * this.nScale.x);
                this.vertices.put((float)v0.z * this.cScale.z + (float)v1.z * this.nScale.z);
                this.vertices.put((float)v0.y * this.cScale.y + (float)v1.y * this.nScale.y);
            }
            this.vertices.flip();
            this.indices.clear();
            for (i = s.numtris - 1; i >= 0; --i) {
                for (int j = 0; j < 3; ++j) {
                    this.indices.put((short)s.tris[i][j]);
                }
            }
            this.indices.flip();
            int l = 33984;
            do {
                this.gl10.glClientActiveTexture(l++);
                this.gl10.glEnableClientState(32888);
                this.gl10.glTexCoordPointer(2, 5126, 0, s.uv);
            } while (l <= texunits);
            this.gl10.glEnableClientState(32884);
            this.gl10.glVertexPointer(3, 5126, 0, this.vertices);
            this.gl10.glDrawElements(4, 0, 5123, this.indices);
            while (texunits > 33984) {
                this.gl10.glMatrixMode(5890);
                this.gl10.glLoadIdentity();
                this.gl10.glMatrixMode(5888);
                this.gl10.glTexEnvf(8960, 34163, 1.0f);
                this.gl10.glDisable(3553);
                this.gl10.glDisableClientState(32888);
                this.gl10.glClientActiveTexture(texunits - 1);
                this.gl10.glActiveTexture(--texunits);
            }
            this.gl10.glDisableClientState(32884);
            isRendered = true;
        }
        if (this.usesalpha) {
            this.gl10.glDisable(3008);
        }
        this.gl10.glDisable(2884);
        this.gl10.glLoadIdentity();
        return isRendered;
    }

    @Override
    public MDModel setScale(Vector3 cScale, Vector3 nScale) {
        this.cScale.set(cScale);
        this.nScale.set(nScale);
        this.cScale.scl(0.015625f);
        this.nScale.scl(0.015625f);
        return this;
    }

    @Override
    public void loadSkins(int pal, int skinnum) {
        for (int surfi = 0; surfi < this.numSurfaces; ++surfi) {
            this.getSkin(pal, skinnum, surfi);
        }
    }

    @Override
    public ModelInfo.Type getType() {
        return ModelInfo.Type.Md3;
    }

    @Override
    public ShaderProgram getShader() {
        return null;
    }
}

