/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.FloatBuffer;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.IOverheadMapSettings;
import ru.m210projects.Build.Render.OrphoRenderer;
import ru.m210projects.Build.Render.Polymost.Polygon;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.RenderedSpriteList;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.TSprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.Types.font.AtlasCharInfo;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.CharInfo;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.FontType;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class Polymost2D
extends OrphoRenderer {
    private final Polymost parent;
    private final TextureManager textureCache;
    private final FloatBuffer vertices = BufferUtils.newFloatBuffer(8);
    private final FloatBuffer textures = BufferUtils.newFloatBuffer(8);
    private final float[] trapextx = new float[2];
    private final int RS_CENTERORIGIN = 0x40000000;
    private final Polygon[] drawpoly = new Polygon[4];
    private final BoardService boardService;
    protected int globalx1;
    protected int globaly1;
    protected int globalx2;
    protected int globaly2;
    protected int[] xb1 = new int[Polymost.MAXWALLSB];
    protected int[] xb2 = new int[Polymost.MAXWALLSB];
    protected float[] rx1 = new float[Polymost.MAXWALLSB];
    protected float[] ry1 = new float[Polymost.MAXWALLSB];
    protected int asm1;
    protected int asm2;
    private GL10 gl;
    private int guniqhudid;
    private int allocpoints = 0;
    private int[] slist;
    private int[] npoint2;
    private raster[] rst;
    private Sprite hudsprite;
    private double guo;
    private double gux;
    private double guy;
    private double gvo;
    private double gvx;
    private double gvy;
    private short globalpicnum;
    private int globalorientation;

    public Polymost2D(Polymost parent, IOverheadMapSettings settings) {
        super(parent, settings);
        this.parent = parent;
        this.boardService = parent.getBoardService();
        this.textureCache = parent.textureCache;
        for (int i = 0; i < 4; ++i) {
            this.drawpoly[i] = new Polygon();
        }
        this.vertices.put(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f});
        this.textures.put(new float[]{0.0f, 0.0f, 0.9999f, 0.0f, 0.9999f, 0.9999f, 0.0f, 0.9999f});
        this.vertices.rewind();
        this.textures.rewind();
    }

    @Override
    public void drawmapview(int dax, int day, int zoome, int ang) {
        int baky1;
        int bakx1;
        int y;
        int x;
        int oy;
        int ox;
        int j;
        int i;
        int npoints;
        int s;
        Sector sec = null;
        int numsectors = this.boardService.getSectorCount();
        this.parent.beforedrawrooms = 0;
        int cx1 = this.parent.windowx1 << 12;
        int cy1 = this.parent.windowy1 << 12;
        int cx2 = (this.parent.windowx2 + 1 << 12) - 1;
        int cy2 = (this.parent.windowy2 + 1 << 12) - 1;
        int bakgxvect = Pragmas.divscale(EngineUtils.sin(1536 - ang), zoome <<= 8, 28);
        int bakgyvect = Pragmas.divscale(EngineUtils.sin(2048 - ang), zoome, 28);
        int xvect = Pragmas.mulscale(EngineUtils.sin(2048 - ang), zoome, 8);
        int yvect = Pragmas.mulscale(EngineUtils.sin(1536 - ang), zoome, 8);
        int xvect2 = Pragmas.mulscale(xvect, this.parent.yxaspect, 16);
        int yvect2 = Pragmas.mulscale(yvect, this.parent.yxaspect, 16);
        for (s = 0; s < numsectors; ++s) {
            ListNode<Sprite> node;
            int startwall;
            sec = this.boardService.getSector(s);
            if (!this.mapSettings.isFullMap() && !Engine.show2dsector.getBit(s)) continue;
            npoints = 0;
            i = 0;
            j = startwall = sec.getWallptr();
            if (startwall < 0) continue;
            int w = sec.getWallnum();
            while (w > 0) {
                Wall wal = this.boardService.getWall(j);
                if (wal != null) {
                    ox = wal.getX() - dax;
                    oy = wal.getY() - day;
                    x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                    y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                    i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                    this.rx1[npoints] = x;
                    this.ry1[npoints] = y;
                    this.xb1[npoints] = wal.getPoint2() - startwall;
                    if (this.xb1[npoints] < 0) {
                        this.xb1[npoints] = 0;
                    }
                    ++npoints;
                }
                --w;
                ++j;
            }
            if ((i & 0xF0) != 240) continue;
            bakx1 = (int)this.rx1[0];
            baky1 = Pragmas.mulscale((long)((int)this.ry1[0]) - ((long)this.ydim << 11), this.parent.xyaspect, 16) + (this.ydim << 11);
            if (this.mapSettings.isShowFloorSprites()) {
                for (node = this.boardService.getSectNode(s); node != null; node = node.getNext()) {
                    int j1 = node.getIndex();
                    if ((node.get().getCstat() & 0x30) != 32 || (node.get().getCstat() & 0x48) == 72 || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, j1)) continue;
                    this.parent.addRenderedSprite(j1);
                }
            }
            if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Polygons)) {
                for (node = this.boardService.getSectNode(s); node != null; node = node.getNext()) {
                    int i1 = node.getIndex();
                    if (!Engine.show2dsprite.getBit(i1) || !this.mapSettings.isSpriteVisible(IOverheadMapSettings.MapView.Polygons, i1)) continue;
                    this.parent.addRenderedSprite(i1);
                }
            }
            int n = s >> 3;
            this.parent.gotsector[n] = (byte)(this.parent.gotsector[n] | Engine.pow2char[s & 7]);
            this.globalorientation = sec.getFloorstat();
            if ((this.globalorientation & 1) != 0) continue;
            this.parent.globalpal = sec.getFloorpal();
            this.globalpicnum = sec.getFloorpicnum();
            if (this.globalpicnum >= Engine.MAXTILES) {
                this.globalpicnum = 0;
            }
            this.parent.setgotpic(this.globalpicnum);
            ArtEntry pic = this.parent.getTile(this.globalpicnum);
            if (!pic.hasSize()) continue;
            if (pic.getType() != AnimType.NONE) {
                this.globalpicnum = (short)(this.globalpicnum + (short)this.parent.animateoffs(this.globalpicnum, s));
                pic = this.parent.getTile(this.globalpicnum);
            }
            int numshades = this.parent.getPaletteManager().getShadeCount();
            this.parent.globalshade = Math.max(Math.min(sec.getFloorshade(), numshades - 1), 0);
            if ((this.globalorientation & 0x40) == 0) {
                this.parent.globalposx = dax;
                this.globalx1 = bakgxvect;
                this.globaly1 = bakgyvect;
                this.parent.globalposy = day;
                this.globalx2 = bakgxvect;
                this.globaly2 = bakgyvect;
            } else {
                ox = this.boardService.getWall(this.boardService.getWall(startwall).getPoint2()).getX() - this.boardService.getWall(startwall).getX();
                i = EngineUtils.sqrt(ox * ox + (oy = this.boardService.getWall(this.boardService.getWall(startwall).getPoint2()).getY() - this.boardService.getWall(startwall).getY()) * oy);
                if (i == 0) continue;
                i = 0x100000 / i;
                this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = (bakx1 >> 4) - (this.xdim << 7);
                oy = (baky1 >> 4) - (this.ydim << 7);
                this.parent.globalposx = Pragmas.dmulscale(-oy, this.globalx1, -ox, this.globaly1, 28);
                this.parent.globalposy = Pragmas.dmulscale(-ox, this.globalx1, oy, this.globaly1, 28);
                this.globalx2 = -this.globalx1;
                this.globaly2 = -this.globaly1;
                short daslope = this.boardService.getSector(s).getFloorheinum();
                i = EngineUtils.sqrt(daslope * daslope + 0x1000000);
                this.parent.globalposy = Pragmas.mulscale(this.parent.globalposy, i, 12);
                this.globalx2 = Pragmas.mulscale(this.globalx2, i, 12);
                this.globaly2 = Pragmas.mulscale(this.globaly2, i, 12);
            }
            int globalxshift = 8 - pic.getSizex();
            int globalyshift = 8 - pic.getSizey();
            if ((this.globalorientation & 8) != 0) {
                ++globalxshift;
                ++globalyshift;
            }
            if ((this.globalorientation & 4) > 0) {
                i = this.parent.globalposx;
                this.parent.globalposx = -this.parent.globalposy;
                this.parent.globalposy = -i;
                i = this.globalx2;
                this.globalx2 = this.globaly1;
                this.globaly1 = i;
                i = this.globalx1;
                this.globalx1 = -this.globaly2;
                this.globaly2 = -i;
            }
            if ((this.globalorientation & 0x10) > 0) {
                this.globalx1 = -this.globalx1;
                this.globaly1 = -this.globaly1;
                this.parent.globalposx = -this.parent.globalposx;
            }
            if ((this.globalorientation & 0x20) > 0) {
                this.globalx2 = -this.globalx2;
                this.globaly2 = -this.globaly2;
                this.parent.globalposy = -this.parent.globalposy;
            }
            this.asm1 = this.globaly1 << globalxshift;
            this.asm2 = this.globalx2 << globalyshift;
            this.globalx1 <<= globalxshift;
            this.globaly2 <<= globalyshift;
            this.parent.globalposx = (this.parent.globalposx << 20 + globalxshift) + (sec.getFloorxpanning() << 24);
            this.parent.globalposy = (this.parent.globalposy << 20 + globalyshift) - (sec.getFloorypanning() << 24);
            this.fillpolygon(npoints);
        }
        if (this.mapSettings.isShowSprites(IOverheadMapSettings.MapView.Polygons) || this.mapSettings.isShowFloorSprites()) {
            int gap = 1;
            RenderedSpriteList tsprite = this.parent.getRenderedSprites();
            int sortnum = this.parent.getRenderedSprites().getSize();
            while (gap < sortnum) {
                gap = (gap << 1) + 1;
            }
            gap >>= 1;
            while (gap > 0) {
                block6: for (i = 0; i < sortnum - gap; ++i) {
                    for (j = i; j >= 0; j -= gap) {
                        TSprite tspr1 = (TSprite)tsprite.get(j);
                        TSprite tspr2 = (TSprite)tsprite.get(j + gap);
                        if (this.boardService.getSprite(tspr1.getOwner()).getZ() <= this.boardService.getSprite(tspr2.getOwner()).getZ()) continue block6;
                        short owner1 = tspr1.getOwner();
                        tspr1.setOwner(tspr2.getOwner());
                        tspr2.setOwner(owner1);
                    }
                }
                gap >>= 1;
            }
            for (s = sortnum - 1; s >= 0; --s) {
                Sprite spr = this.boardService.getSprite(((TSprite)tsprite.get(s)).getOwner());
                if ((spr.getCstat() & 0x8000) != 0) continue;
                npoints = 0;
                if (spr.getPicnum() >= Engine.MAXTILES) {
                    spr.setPicnum(0);
                }
                ArtEntry pic = this.parent.getTile(spr.getPicnum());
                byte xoff = (byte)(pic.getOffsetX() + spr.getXoffset());
                byte yoff = (byte)(pic.getOffsetY() + spr.getYoffset());
                if ((spr.getCstat() & 4) > 0) {
                    xoff = -xoff;
                }
                if ((spr.getCstat() & 8) > 0) {
                    yoff = -yoff;
                }
                int cosang = EngineUtils.cos(spr.getAng());
                int sinang = EngineUtils.sin(spr.getAng());
                int xspan = pic.getWidth();
                short xrepeat = spr.getXrepeat();
                int yspan = pic.getHeight();
                short yrepeat = spr.getYrepeat();
                ox = ((xspan >> 1) + xoff) * xrepeat;
                oy = ((yspan >> 1) + yoff) * yrepeat;
                int x1 = spr.getX() + Pragmas.mulscale(sinang, ox, 16) + Pragmas.mulscale(cosang, oy, 16);
                int y1 = spr.getY() + Pragmas.mulscale(sinang, oy, 16) - Pragmas.mulscale(cosang, ox, 16);
                int l = xspan * xrepeat;
                int x2 = x1 - Pragmas.mulscale(sinang, l, 16);
                int y2 = y1 + Pragmas.mulscale(cosang, l, 16);
                l = yspan * yrepeat;
                int k = -Pragmas.mulscale(cosang, l, 16);
                int x3 = x2 + k;
                int x4 = x1 + k;
                k = -Pragmas.mulscale(sinang, l, 16);
                int y3 = y2 + k;
                int y4 = y1 + k;
                this.xb1[0] = 1;
                this.xb1[1] = 2;
                this.xb1[2] = 3;
                this.xb1[3] = 0;
                npoints = 4;
                i = 0;
                ox = x1 - dax;
                oy = y1 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[0] = x;
                this.ry1[0] = y;
                ox = x2 - dax;
                oy = y2 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[1] = x;
                this.ry1[1] = y;
                ox = x3 - dax;
                oy = y3 - day;
                x = Pragmas.dmulscale(ox, xvect, -oy, yvect, 16) + (this.xdim << 11);
                y = Pragmas.dmulscale(oy, xvect2, ox, yvect2, 16) + (this.ydim << 11);
                i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y);
                this.rx1[2] = x;
                this.ry1[2] = y;
                x = (int)(this.rx1[0] + this.rx1[2] - this.rx1[1]);
                y = (int)(this.ry1[0] + this.ry1[2] - this.ry1[1]);
                this.rx1[3] = x;
                this.ry1[3] = y;
                if (((i |= this.getclipmask(x - cx1, cx2 - x, y - cy1, cy2 - y)) & 0xF0) != 240) continue;
                bakx1 = (int)this.rx1[0];
                baky1 = Pragmas.mulscale((long)((int)this.ry1[0]) - ((long)this.ydim << 11), this.parent.xyaspect, 16) + (this.ydim << 11);
                this.globalpicnum = spr.getPicnum();
                this.parent.globalpal = spr.getPal();
                this.parent.setgotpic(this.globalpicnum);
                ArtEntry sprpic = this.parent.getTile(this.globalpicnum);
                if (!sprpic.hasSize()) continue;
                if (sprpic.getType() != AnimType.NONE) {
                    this.globalpicnum = (short)(this.globalpicnum + this.parent.animateoffs(this.globalpicnum, s));
                    sprpic = this.parent.getTile(this.globalpicnum);
                }
                this.parent.globalshade = (this.boardService.getSector(spr.getSectnum()).getCeilingstat() & 1) > 0 ? (int)this.boardService.getSector(spr.getSectnum()).getCeilingshade() : (int)this.boardService.getSector(spr.getSectnum()).getFloorshade();
                int numshades = this.parent.getPaletteManager().getShadeCount();
                this.parent.globalshade = Math.max(Math.min(this.parent.globalshade + spr.getShade() + 6, numshades - 1), 0);
                ox = x2 - x1;
                oy = y2 - y1;
                i = ox * ox + oy * oy;
                if (i == 0) continue;
                i = 0x40000000 / i;
                this.globalx1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly1 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = y1 - y4;
                oy = x4 - x1;
                i = ox * ox + oy * oy;
                if (i == 0) continue;
                i = 0x40000000 / i;
                this.globalx2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgxvect, oy, bakgyvect, 10), i, 10);
                this.globaly2 = Pragmas.mulscale(Pragmas.dmulscale(ox, bakgyvect, -oy, bakgxvect, 10), i, 10);
                ox = pic.getSizex();
                if (Engine.pow2long[ox] != xspan) {
                    this.globalx1 = Pragmas.mulscale(this.globalx1, xspan, ++ox);
                    this.globaly1 = Pragmas.mulscale(this.globaly1, xspan, ox);
                }
                bakx1 = (bakx1 >> 4) - (this.xdim << 7);
                baky1 = (baky1 >> 4) - (this.ydim << 7);
                this.parent.globalposx = Pragmas.dmulscale(-baky1, this.globalx1, -bakx1, this.globaly1, 28);
                this.parent.globalposy = Pragmas.dmulscale(bakx1, this.globalx2, -baky1, this.globaly2, 28);
                if ((spr.getCstat() & 4) > 0) {
                    this.globalx1 = -this.globalx1;
                    this.globaly1 = -this.globaly1;
                    this.parent.globalposx = -this.parent.globalposx;
                }
                this.asm1 = this.globaly1 << 2;
                this.globalx1 <<= 2;
                this.parent.globalposx <<= 22;
                this.asm2 = this.globalx2 << 2;
                this.globaly2 <<= 2;
                this.parent.globalposy <<= 22;
                this.globalorientation = (spr.getCstat() & 2) << 7 | (spr.getCstat() & 0x200) >> 2;
                this.fillpolygon(npoints);
            }
        }
    }

    protected void setpolymost2dview() {
        if (this.parent.gloy1 != -1.0f || this.parent.gloy1 != (float)this.parent.windowy1) {
            this.parent.glViewport(0.0f, 0.0f, this.xdim, this.ydim);
            this.gl.glMatrixMode(5889);
            this.gl.glLoadIdentity();
            this.gl.glOrthof(0.0f, this.xdim, this.ydim, 0.0f, -1.0f, 1.0f);
            this.gl.glMatrixMode(5888);
            this.gl.glLoadIdentity();
        }
        this.parent.gloy1 = -1.0f;
        this.gl.glDisable(2929);
        this.gl.glDisable(3553);
        this.gl.glDisable(3042);
    }

    protected void fillpolygon(int npoints) {
        for (int z = 0; z < npoints; ++z) {
            if (this.xb1[z] < npoints) continue;
            this.xb1[z] = 0;
        }
        if (!this.parent.getPaletteManager().isValidPalette(this.parent.globalpal)) {
            this.parent.globalpal = 0;
        }
        this.setpolymost2dview();
        this.gl.glEnable(3008);
        this.gl.glEnable(3553);
        int method = this.globalorientation >> 7 & 3;
        if (method == 0) {
            this.gl.glDisable(3042);
        } else {
            this.gl.glEnable(3042);
        }
        GLTile pth = this.parent.bind(this.parent.getTile(this.globalpicnum), this.parent.globalpal, this.parent.globalshade, 0, method);
        if (pth == null) {
            return;
        }
        this.textureCache.deactivateEffects(this.gl);
        this.parent.bind(pth);
        this.globalx1 = Pragmas.mulscale(this.globalx1, this.parent.xyaspect, 16);
        this.globaly2 = Pragmas.mulscale(this.globaly2, this.parent.xyaspect, 16);
        this.gux = (double)this.asm1 / 4.294967296E9;
        this.gvx = (double)this.asm2 / 4.294967296E9;
        this.guy = (double)this.globalx1 / 4.294967296E9;
        this.gvy = (double)(-this.globaly2) / 4.294967296E9;
        this.guo = ((double)this.xdim * this.gux + (double)this.ydim * this.guy) * -0.5 + (double)this.parent.globalposx / 4.294967296E9;
        this.gvo = ((double)this.xdim * this.gvx + (double)this.ydim * this.gvy) * -0.5 - (double)this.parent.globalposy / 4.294967296E9;
        int i = npoints - 1;
        while (i >= 0) {
            int n = i;
            this.rx1[n] = this.rx1[n] / 4096.0f;
            int n2 = i--;
            this.ry1[n2] = this.ry1[n2] / 4096.0f;
        }
        this.tessectrap(this.rx1, this.ry1, this.xb1, npoints);
    }

    private void drawtrap(float x0, float x1, float y0, float x2, float x3, float y1) {
        if (y0 == y1) {
            return;
        }
        this.drawpoly[0].px = x0;
        this.drawpoly[0].py = y0;
        this.drawpoly[2].py = y1;
        int n = 3;
        if (x0 == x1) {
            this.drawpoly[1].px = x3;
            this.drawpoly[1].py = y1;
            this.drawpoly[2].px = x2;
        } else if (x2 == x3) {
            this.drawpoly[1].px = x1;
            this.drawpoly[1].py = y0;
            this.drawpoly[2].px = x3;
        } else {
            this.drawpoly[1].px = x1;
            this.drawpoly[1].py = y0;
            this.drawpoly[2].px = x3;
            this.drawpoly[3].px = x2;
            this.drawpoly[3].py = y1;
            n = 4;
        }
        this.gl.glBegin(6);
        for (int i = 0; i < n; ++i) {
            this.drawpoly[i].px = Math.min(Math.max(this.drawpoly[i].px, (double)this.trapextx[0]), (double)this.trapextx[1]);
            this.gl.glTexCoord2d(this.drawpoly[i].px * this.gux + this.drawpoly[i].py * this.guy + this.guo, this.drawpoly[i].px * this.gvx + this.drawpoly[i].py * this.gvy + this.gvo);
            this.gl.glVertex2d(this.drawpoly[i].px, this.drawpoly[i].py);
        }
        this.gl.glEnd();
    }

    private void tessectrap(float[] px, float[] py, int[] point2, int numpoints) {
        float m1;
        float m0;
        int k;
        int j;
        int i;
        if (numpoints + 16 > this.allocpoints) {
            this.allocpoints = numpoints + 16;
            this.rst = new raster[this.allocpoints];
            for (i = 0; i < this.allocpoints; ++i) {
                this.rst[i] = new raster();
            }
            this.slist = new int[this.allocpoints];
            this.npoint2 = new int[this.allocpoints];
        }
        for (i = 0; i < numpoints; ++i) {
            this.npoint2[i] = point2[i];
        }
        int npoints = numpoints;
        int z = 0;
        for (i = 0; i < numpoints; ++i) {
            j = this.npoint2[i];
            if (point2[i] < i && i < numpoints - 1) {
                z = 3;
            }
            if (j < 0 || (k = this.npoint2[j]) < 0) continue;
            m0 = (px[j] - px[i]) * (py[k] - py[j]);
            m1 = (py[j] - py[i]) * (px[k] - px[j]);
            if (m0 < m1) {
                z |= 1;
                continue;
            }
            if (m0 > m1) {
                z |= 2;
                continue;
            }
            this.npoint2[i] = k;
            this.npoint2[j] = -1;
            --npoints;
            --i;
        }
        if (z == 0) {
            return;
        }
        this.trapextx[0] = this.trapextx[1] = px[0];
        j = 0;
        for (i = 0; i < numpoints; ++i) {
            if (this.npoint2[i] < 0) continue;
            if (px[i] < this.trapextx[0]) {
                this.trapextx[0] = px[i];
            }
            if (px[i] > this.trapextx[1]) {
                this.trapextx[1] = px[i];
            }
            this.slist[j++] = i;
        }
        this.parent.globalfog.apply();
        if (z != 3) {
            this.gl.glBegin(6);
            for (i = 0; i < npoints; ++i) {
                j = this.slist[i];
                this.gl.glTexCoord2f((float)((double)px[j] * this.gux + (double)py[j] * this.guy + this.guo), (float)((double)px[j] * this.gvx + (double)py[j] * this.gvy + this.gvo));
                this.gl.glVertex2d(px[j], py[j]);
            }
            this.gl.glEnd();
            return;
        }
        for (int gap = npoints >> 1; gap != 0; gap >>= 1) {
            for (i = 0; i < npoints - gap; ++i) {
                for (j = i; j >= 0 && !(py[this.npoint2[this.slist[j]]] <= py[this.npoint2[this.slist[j + gap]]]); j -= gap) {
                    k = this.slist[j];
                    this.slist[j] = this.slist[j + gap];
                    this.slist[j + gap] = k;
                }
            }
        }
        int numrst = 0;
        for (z = 0; z < npoints; ++z) {
            float x1;
            float x0;
            int i0 = this.slist[z];
            int i1 = this.npoint2[i0];
            if (py[i0] == py[i1] || this.npoint2[i1] == -1) continue;
            int i2 = i1;
            int i3 = this.npoint2[i1];
            if (py[i1] == py[i3]) {
                i2 = i3;
                i3 = this.npoint2[i3];
            }
            if (py[i1] < py[i0] && py[i2] < py[i3]) {
                for (i = numrst; i > 0 && !(this.rst[i - 1].xi * (py[i1] - this.rst[i - 1].y) + this.rst[i - 1].x < px[i1]); --i) {
                    this.rst[i + 1].set(this.rst[i - 1]);
                }
                numrst += 2;
                if ((i & 1) != 0) {
                    j = i - 1;
                    x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
                    x1 = (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
                    this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
                    this.rst[j].x = x0;
                    this.rst[j].y = py[i1];
                    this.rst[j + 3].x = x1;
                    this.rst[j + 3].y = py[i1];
                }
                m0 = (px[i0] - px[i1]) / (py[i0] - py[i1]);
                m1 = (px[i3] - px[i2]) / (py[i3] - py[i2]);
                j = (px[i1] > px[i2] || i1 == i2 && m0 >= m1 ? 1 : 0) + i;
                if (j < 0) continue;
                k = (i << 1) + 1 - j;
                this.rst[j].i = i0;
                this.rst[j].xi = m0;
                this.rst[j].x = px[i1];
                this.rst[j].y = py[i1];
                this.rst[k].i = i3;
                this.rst[k].xi = m1;
                this.rst[k].x = px[i2];
                this.rst[k].y = py[i2];
                continue;
            }
            if (i1 == i2) {
                for (i = 0; i < numrst && this.rst[i].i != i1; ++i) {
                }
            } else {
                for (i = 0; i < numrst && this.rst[i].i != i1 && this.rst[i].i != i2; ++i) {
                }
            }
            if (py[i1] > py[i0] && py[i2] > py[i3]) {
                for (j = i & 0xFFFFFFFE; j <= i + 1; j += 2) {
                    x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
                    x1 = i == j && i1 == i2 ? x0 : (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
                    this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
                    this.rst[j].x = x0;
                    this.rst[j].y = py[i1];
                    this.rst[j + 1].x = x1;
                    this.rst[j + 1].y = py[i1];
                }
                numrst -= 2;
                while (i < numrst) {
                    this.rst[i].set(this.rst[i + 2]);
                    ++i;
                }
                continue;
            }
            x0 = (py[i1] - this.rst[j].y) * this.rst[j].xi + this.rst[j].x;
            x1 = (py[i1] - this.rst[j + 1].y) * this.rst[j + 1].xi + this.rst[j + 1].x;
            this.drawtrap(this.rst[j].x, this.rst[j + 1].x, this.rst[j].y, x0, x1, py[i1]);
            this.rst[j].x = x0;
            this.rst[j].y = py[i1];
            this.rst[j + 1].x = x1;
            this.rst[j + 1].y = py[i1];
            if (py[i0] < py[i3]) {
                this.rst[i].x = px[i2];
                this.rst[i].y = py[i2];
                this.rst[i].i = i3;
            } else {
                this.rst[i].x = px[i1];
                this.rst[i].y = py[i1];
                this.rst[i].i = i0;
            }
            this.rst[i].xi = (px[this.rst[i].i] - this.rst[i].x) / (py[this.rst[i].i] - py[i1]);
        }
    }

    @Override
    public int printext(Font font, int xpos, int ypos, char[] text, float scale, int shade, int palnum, TextAlign textAlign, Transparent transparent, boolean shadow) {
        if (font == null || text == null || text.length == 0) {
            return 0;
        }
        if (shadow) {
            this.printext(font, xpos + (int)scale, ypos + (int)scale, text, scale, 127, palnum, textAlign, transparent, false);
        }
        this.setpolymost2dview();
        float scaleyf = scale;
        if (font.isVerticalScaled()) {
            scaleyf *= 1.2f;
        }
        this.gl.glDisable(3008);
        this.gl.glDepthMask(false);
        this.gl.glEnable(3553);
        this.gl.glEnable(3042);
        this.parent.globalpal = palnum;
        this.parent.globalshade = shade;
        this.parent.globalfog.apply();
        int alignx = 0;
        if (textAlign != TextAlign.Left) {
            int width = 0;
            for (int pos = 0; pos < text.length && text[pos] != '\u0000'; ++pos) {
                CharInfo charInfo = font.getCharInfo(text[pos]);
                width += (int)((float)charInfo.getCellSize() * scale);
            }
            if (textAlign == TextAlign.Center) {
                width >>= 1;
            }
            xpos -= width;
        }
        GLTile pth = null;
        int currentTile = -1;
        for (int c = 0; c < text.length && text[c] != '\u0000'; ++c) {
            CharInfo charInfo = font.getCharInfo(text[c]);
            int tile = charInfo.tile;
            float cellsizx = scale * (float)charInfo.getCellSize();
            this.globalpicnum = (short)tile;
            if (tile != -1) {
                float ty2;
                float tx2;
                float ty1;
                float tx1;
                int charsizex = (int)(scale * (float)charInfo.getWidth());
                int charsizey = (int)(scaleyf * (float)charInfo.getHeight());
                int xoffset = (int)(scale * (float)charInfo.xOffset);
                int yoffset = (int)(scaleyf * (float)charInfo.yOffset);
                if (currentTile != tile) {
                    if (currentTile != -1) {
                        this.gl.glEnd();
                    }
                    Color polyColor = this.parent.getshadefactor(shade, 0);
                    if (transparent == Transparent.Bit1) {
                        polyColor.a = this.parent.TRANSLUSCENT1;
                    } else if (transparent == Transparent.Bit2) {
                        polyColor.a = this.parent.TRANSLUSCENT2;
                    }
                    if (charInfo.getFontType() == FontType.BITMAP_FONT) {
                        pth = this.textureCache.getBitmapFontAtlas((BitmapFont)charInfo.getParent());
                        this.parent.bind(pth);
                        palnum = this.parent.getPaletteManager().getColorIndex(0, palnum, shade);
                        Palette curpalette = this.parent.getPaletteManager().getCurrentPalette();
                        this.gl.glColor4ub(curpalette.getRed(palnum), curpalette.getGreen(palnum), curpalette.getBlue(palnum), (int)(polyColor.a * 255.0f));
                    } else {
                        ArtEntry charTile;
                        if (!this.parent.getPaletteManager().isValidPalette(palnum)) {
                            palnum = 0;
                        }
                        if (!(charTile = this.parent.getTile(tile)).exists()) continue;
                        pth = this.parent.bind(charTile, palnum, shade, 0, 5);
                        this.gl.glColor4f(polyColor.r, polyColor.g, polyColor.b, polyColor.a);
                    }
                    if (pth == null) {
                        currentTile = -1;
                        continue;
                    }
                    if (pth.getPixelFormat() == TileData.PixelFormat.Pal8) {
                        this.parent.getShader().setTransparent(polyColor.a);
                    }
                    currentTile = tile;
                    this.gl.glBegin(4);
                }
                int vx1 = xpos + xoffset;
                int vy1 = ypos + yoffset;
                int vx2 = vx1 + charsizex;
                int vy2 = vy1 + charsizey;
                if (charInfo instanceof AtlasCharInfo) {
                    AtlasCharInfo atlasCharInfo = (AtlasCharInfo)charInfo;
                    tx1 = atlasCharInfo.getTx1();
                    ty1 = atlasCharInfo.getTy1();
                    tx2 = atlasCharInfo.getTx2();
                    ty2 = atlasCharInfo.getTy2();
                } else {
                    tx1 = 0.0f;
                    ty1 = 0.0f;
                    float tileScale = charInfo.getTileScale();
                    float tsizx = pth.getWidth();
                    float tsizy = pth.getHeight();
                    if (pth.isHighTile()) {
                        tsizx = (float)GLInfo.calcSize(pth.getWidth()) / pth.getXScale();
                        tsizy = (float)GLInfo.calcSize(pth.getHeight()) / pth.getYScale();
                    }
                    tx2 = (float)charInfo.getWidth() / (tsizx * tileScale);
                    ty2 = (float)charInfo.getHeight() / (tsizy * tileScale);
                }
                this.gl.glTexCoord2f(tx1, ty1);
                this.gl.glVertex2i(vx1, vy1);
                this.gl.glTexCoord2f(tx1, ty2);
                this.gl.glVertex2i(vx1, vy2);
                this.gl.glTexCoord2f(tx2, ty2);
                this.gl.glVertex2i(vx2, vy2);
                this.gl.glTexCoord2f(tx1, ty1);
                this.gl.glVertex2i(vx1, vy1);
                this.gl.glTexCoord2f(tx2, ty1);
                this.gl.glVertex2i(vx2, vy1);
                this.gl.glTexCoord2f(tx2, ty2);
                this.gl.glVertex2i(vx2, vy2);
            }
            xpos += (int)cellsizx;
            alignx += (int)cellsizx;
        }
        this.gl.glEnd();
        this.gl.glDepthMask(true);
        this.textureCache.deactivateEffects(this.gl);
        return (int)((float)alignx / scale);
    }

    @Override
    public void drawline256(int x1, int y1, int x2, int y2, int col) {
        float fy2;
        float fx2;
        float fy1;
        float fx1;
        boolean hasShader;
        this.setpolymost2dview();
        this.parent.globalfog.apply();
        boolean bl = hasShader = this.parent.getShader() != null && this.parent.getShader().isBinded();
        if (hasShader) {
            this.parent.getShader().unbind();
        }
        if (!this.checkIntersect(fx1 = (float)x1 / 4096.0f, fy1 = (float)y1 / 4096.0f, fx2 = (float)x2 / 4096.0f, fy2 = (float)y2 / 4096.0f)) {
            return;
        }
        PaletteManager paletteManager = this.parent.getPaletteManager();
        Palette curpalette = paletteManager.getCurrentPalette();
        col = paletteManager.getColorIndex(0, col);
        this.gl.glBegin(1);
        this.gl.glColor4ub(curpalette.getRed(col), curpalette.getGreen(col), curpalette.getBlue(col), 255);
        this.gl.glVertex2f(fx1, fy1);
        this.gl.glVertex2f(fx2, fy2);
        this.gl.glEnd();
        if (hasShader) {
            this.parent.getShader().bind();
        }
    }

    private boolean checkIntersect(float x1, float y1, float x2, float y2) {
        float tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        return x2 >= 0.0f && x1 <= (float)this.xdim && y2 >= 0.0f && y1 <= (float)this.ydim;
    }

    @Override
    public void rotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2) {
        if (picnum >= Engine.MAXTILES) {
            return;
        }
        if (cx1 > cx2 || cy1 > cy2) {
            return;
        }
        if (z <= 16) {
            return;
        }
        ArtEntry pic = this.parent.getTile(picnum);
        if (pic.getType() != AnimType.NONE) {
            picnum += this.parent.animateoffs(picnum, 0);
            pic = this.parent.getTile(picnum);
        }
        if (!pic.hasSize()) {
            return;
        }
        if ((dastat & 0x80) == 0 || this.parent.beforedrawrooms != 0) {
            this.dorotatesprite(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, this.guniqhudid);
        }
    }

    protected void dorotatesprite(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int ourxyaspect = this.parent.xyaspect;
        if (this.parent.getConfig().isUseModels() && this.parent.defs != null && this.parent.defs.mdInfo.getHudInfo(picnum, dastat) != null && this.parent.defs.mdInfo.getHudInfo((int)picnum, (int)dastat).angadd != 0) {
            Tile2model entry;
            Tile2model tile2model = entry = this.parent.defs != null ? this.parent.defs.mdInfo.getParams(picnum) : null;
            if (entry != null && entry.model != null && entry.framenum >= 0) {
                this.dorotatesprite3d(sx, sy, z, a, picnum, dashade, dapalnum, dastat, cx1, cy1, cx2, cy2, uniqid);
                return;
            }
        }
        short ogpicnum = this.globalpicnum;
        this.globalpicnum = (short)picnum;
        int ogshade = this.parent.globalshade;
        this.parent.globalshade = dashade;
        int ogpal = this.parent.globalpal;
        this.parent.globalpal = dapalnum & 0xFF;
        if ((dastat & 0xA) == 2) {
            this.parent.glViewport(this.parent.windowx1, this.ydim - (this.parent.windowy2 + 1), this.parent.windowx2 - this.parent.windowx1 + 1, this.parent.windowy2 - this.parent.windowy1 + 1);
        } else {
            this.parent.glViewport(0.0f, 0.0f, this.xdim, this.ydim);
            this.parent.glox1 = -1.0f;
        }
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glOrthof(0.0f, this.xdim - 1, this.ydim - 1, 0.0f, -1.0f, 1.0f);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glDisable(3008);
        this.gl.glEnable(3553);
        int method = 0;
        if ((dastat & 0x40) == 0) {
            method = 1;
            if ((dastat & 1) != 0) {
                method = (dastat & 0x20) == 0 ? 2 : 3;
            }
        } else {
            method |= 0x100;
        }
        method |= 4;
        ArtEntry pic = this.parent.getTile(this.globalpicnum);
        int xsiz = pic.getWidth();
        int ysiz = pic.getHeight();
        int xoff = 0;
        int yoff = 0;
        if ((dastat & 0x10) == 0) {
            xoff = pic.getOffsetX() + (xsiz >> 1);
            yoff = pic.getOffsetY() + (ysiz >> 1);
        }
        if ((dastat & 4) != 0) {
            yoff = ysiz - yoff;
        }
        if ((dastat & 2) == 0) {
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * this.xdim) {
                ourxyaspect = 54613;
            }
        } else {
            int zoomsc;
            int oxdim;
            int xdim = oxdim = this.xdim;
            int ouryxaspect = this.parent.yxaspect;
            ourxyaspect = this.parent.xyaspect;
            int normxofs = sx - 0xA00000;
            int normyofs = sy - 0x640000;
            if ((dastat & 0x400) == 0 && 4 * this.ydim <= 3 * xdim) {
                xdim = 4 * this.ydim / 3;
                ouryxaspect = 78643;
                ourxyaspect = 54613;
            }
            if ((dastat & 8) == 0) {
                int twice_midcx = cx1 + cx2 + 2;
                int scaledxofs = Pragmas.scale(normxofs, Pragmas.scale(this.parent.xdimen, xdim, oxdim), 320L);
                int xbord = 0;
                if ((dastat & 0x300) != 0) {
                    xbord = Pragmas.scale(oxdim - xdim, twice_midcx, oxdim);
                    if ((dastat & 0x200) == 0) {
                        xbord = -xbord;
                    }
                }
                sx = (twice_midcx + xbord << 15) + scaledxofs;
                zoomsc = this.parent.xdimenscale;
                sy = (cy1 + cy2 + 2 << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            } else {
                sx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
                if ((dastat & 0x200) != 0) {
                    sx += oxdim - xdim << 16;
                } else if ((dastat & 0x100) == 0) {
                    sx += oxdim - xdim << 15;
                }
                if ((dastat & 0x40000000) != 0) {
                    sx += oxdim << 15;
                }
                zoomsc = Pragmas.scale(xdim, ouryxaspect, 320L);
                sy = (this.ydim << 15) + Pragmas.mulscale(normyofs, zoomsc, 16);
            }
            z = Pragmas.mulscale(z, zoomsc, 16);
        }
        this.gl.glEnable(12288);
        this.gl.glClipPlanef(12288, 1.0f, 0.0f, 0.0f, -cx1);
        this.gl.glEnable(12289);
        this.gl.glClipPlanef(12289, -1.0f, 0.0f, 0.0f, cx2);
        this.gl.glEnable(12290);
        this.gl.glClipPlanef(12290, 0.0f, 1.0f, 0.0f, -cy1);
        this.gl.glEnable(12291);
        this.gl.glClipPlanef(12291, 0.0f, -1.0f, 0.0f, cy2);
        float aspectFix = (dastat & 2) != 0 || (dastat & 8) == 0 ? (float)ourxyaspect / 65536.0f : 1.0f;
        float scale = (float)z / 65536.0f;
        float cx = (float)sx / 65536.0f;
        float cy = (float)sy / 65536.0f;
        this.gl.glTranslatef(cx, cy, 0.0f);
        this.gl.glScalef(1.0f, 1.0f / aspectFix, 0.0f);
        this.gl.glRotatef(360.0f * (float)a / 2048.0f, 0.0f, 0.0f, 1.0f);
        this.gl.glScalef(scale * aspectFix, scale * aspectFix, 0.0f);
        this.gl.glTranslatef(-xoff, -yoff, 0.0f);
        this.gl.glScalef(xsiz, ysiz, 0.0f);
        this.drawrotate(method, dastat);
        this.gl.glDisable(12288);
        this.gl.glDisable(12289);
        this.gl.glDisable(12290);
        this.gl.glDisable(12291);
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.globalpicnum = ogpicnum;
        this.parent.globalshade = ogshade;
        this.parent.globalpal = ogpal & 0xFF;
    }

    protected void drawrotate(int method, int dastat) {
        float oy2;
        float ox2;
        GLTile pth;
        if (this.globalpicnum >= Engine.MAXTILES) {
            this.globalpicnum = 0;
        }
        if (!this.parent.getPaletteManager().isValidPalette(this.parent.globalpal)) {
            this.parent.globalpal = 0;
        }
        this.parent.setgotpic(this.globalpicnum);
        ArtEntry pic = this.parent.getTile(this.globalpicnum);
        int tsizx = pic.getWidth();
        int tsizy = pic.getHeight();
        if (!pic.exists()) {
            tsizy = 1;
            tsizx = 1;
            method = 1;
        }
        if ((pth = this.parent.bind(pic, this.parent.globalpal, this.parent.globalshade, 0, method)) == null) {
            return;
        }
        this.parent.globalfog.apply();
        int texunits = this.textureCache.getTextureUnits();
        if (pth.isHighTile()) {
            tsizx = pth.getWidth();
            tsizy = pth.getHeight();
        }
        if (GLInfo.texnpot == 0) {
            int yy;
            int xx;
            for (xx = 1; xx < tsizx; xx += xx) {
            }
            ox2 = 1.0f / (float)xx;
            for (yy = 1; yy < tsizy; yy += yy) {
            }
            oy2 = 1.0f / (float)yy;
        } else {
            ox2 = 1.0f / (float)tsizx;
            oy2 = 1.0f / (float)tsizy;
        }
        if ((method & 3) == 0) {
            this.gl.glDisable(3042);
            this.gl.glDisable(3008);
        } else {
            this.gl.glEnable(3042);
            this.gl.glEnable(3008);
        }
        this.gl.glEnableClientState(32884);
        this.gl.glVertexPointer(2, 5126, 0, this.vertices);
        int j = 0;
        while (j <= texunits) {
            if (GLInfo.multisample != 0) {
                this.gl.glActiveTexture(33984 + j);
                this.gl.glClientActiveTexture(33984 + j++);
            } else {
                ++j;
            }
            this.gl.glEnableClientState(32888);
            this.gl.glTexCoordPointer(2, 5126, 0, this.textures);
            this.gl.glMatrixMode(5890);
            this.gl.glPushMatrix();
            this.gl.glLoadIdentity();
            this.gl.glScalef(tsizx, tsizy, 1.0f);
            this.gl.glScalef(ox2, oy2, 1.0f);
            if ((dastat & 4) == 0) continue;
            this.gl.glScalef(1.0f, -1.0f, 1.0f);
            this.gl.glTranslatef(0.0f, -1.0f, 0.0f);
        }
        this.gl.glDrawArrays(6, 0, 4);
        if (GLInfo.multisample != 0) {
            j = 0;
            while (j <= texunits) {
                this.gl.glMatrixMode(5890);
                this.gl.glLoadIdentity();
                this.gl.glMatrixMode(5888);
                this.gl.glTexEnvf(8960, 34163, 1.0f);
                this.gl.glDisable(3553);
                this.gl.glClientActiveTexture(33984 + j++);
                this.gl.glDisableClientState(32888);
            }
        } else {
            this.gl.glDisableClientState(32888);
        }
        this.gl.glDisableClientState(32884);
        this.gl.glMatrixMode(5890);
        this.gl.glPopMatrix();
        this.textureCache.deactivateEffects(this.gl);
    }

    private void dorotatesprite3d(int sx, int sy, int z, int a, int picnum, int dashade, int dapalnum, int dastat, int cx1, int cy1, int cx2, int cy2, int uniqid) {
        int xoff = 0;
        int yoff = 0;
        if (this.hudsprite == null) {
            this.hudsprite = new Sprite();
        }
        this.hudsprite.reset((byte)0);
        Hudtyp hudInfo = null;
        if (this.parent.defs == null || (hudInfo = this.parent.defs.mdInfo.getHudInfo(picnum, dastat)) != null && (hudInfo.flags & 1) != 0) {
            return;
        }
        float ogchang = this.parent.gchang;
        this.parent.gchang = 1.0f;
        float ogshang = this.parent.gshang;
        this.parent.gshang = 0.0f;
        float d = (float)z / 1.0737418E9f;
        float ogctang = this.parent.gctang;
        this.parent.gctang = (float)EngineUtils.cos(a) * d;
        float ogstang = this.parent.gstang;
        this.parent.gstang = (float)EngineUtils.sin(a) * d;
        int ogshade = this.parent.globalshade;
        this.parent.globalshade = dashade;
        int ogpal = this.parent.globalpal;
        this.parent.globalpal = dapalnum;
        double ogxyaspect = this.parent.gxyaspect;
        this.parent.gxyaspect = 1.0;
        int oldviewingrange = this.parent.viewingrange;
        this.parent.viewingrange = 65536;
        float x1 = hudInfo.xadd;
        float y1 = hudInfo.yadd;
        float z1 = hudInfo.zadd;
        if ((hudInfo.flags & 2) == 0) {
            float fx = (float)sx * 1.5258789E-5f;
            float fy = (float)sy * 1.5258789E-5f;
            if ((dastat & 0x10) != 0) {
                float sinang;
                float cosang;
                ArtEntry pic = this.parent.getTile(picnum);
                int xsiz = pic.getWidth();
                int ysiz = pic.getHeight();
                xoff = pic.getOffsetX() + (xsiz >> 1);
                yoff = pic.getOffsetY() + (ysiz >> 1);
                d = (float)z / 1.0737418E9f;
                float cosang2 = cosang = (float)EngineUtils.cos(a) * d;
                float sinang2 = sinang = (float)EngineUtils.sin(a) * d;
                if ((dastat & 2) != 0 || (dastat & 8) == 0) {
                    d = (float)this.parent.xyaspect / 65536.0f;
                    cosang2 *= d;
                    sinang2 *= d;
                }
                fx = (float)((double)fx + (-((double)xoff) * (double)cosang2 + (double)yoff * (double)sinang2));
                fy = (float)((double)fy + (-((double)xoff) * (double)sinang - (double)yoff * (double)cosang));
            }
            if ((dastat & 2) == 0) {
                x1 = (float)((double)x1 + ((double)fx / (double)(this.xdim << 15) - 1.0));
                y1 = (float)((double)y1 + ((double)fy / (double)(this.ydim << 15) - 1.0));
            } else {
                x1 = (float)((double)x1 + ((double)fx / 160.0 - 1.0));
                y1 = (float)((double)y1 + ((double)fy / 100.0 - 1.0));
            }
        }
        if ((dastat & 4) != 0) {
            x1 = -x1;
            y1 = -y1;
        }
        this.hudsprite.setAng((short)((float)hudInfo.angadd + this.parent.globalang));
        this.hudsprite.setXrepeat(32);
        this.hudsprite.setYrepeat(32);
        float cos = this.parent.gcosang * 16.0f;
        float sin = this.parent.gsinang * 16.0f;
        this.hudsprite.setX((int)((cos * z1 - sin * x1) * 1024.0f + (float)this.parent.globalposx));
        this.hudsprite.setY((int)((sin * z1 + cos * x1) * 1024.0f + (float)this.parent.globalposy));
        this.hudsprite.setZ((int)((float)this.parent.globalposz + y1 * 16384.0f * 0.8f));
        this.hudsprite.setPicnum((short)picnum);
        this.hudsprite.setShade((byte)dashade);
        this.hudsprite.setPal((short)dapalnum);
        this.hudsprite.setOwner((short)(uniqid + this.boardService.getSpriteCount()));
        this.hudsprite.setCstat((short)((dastat & 1) + ((dastat & 0x20) << 4) + ((dastat & 4) << 1)));
        if ((dastat & 0xA) == 2) {
            this.parent.glViewport(this.parent.windowx1, this.ydim - (this.parent.windowy2 + 1), this.parent.windowx2 - this.parent.windowx1 + 1, this.parent.windowy2 - this.parent.windowy1 + 1);
        } else {
            this.parent.glViewport(0.0f, 0.0f, this.xdim, this.ydim);
            this.parent.glox1 = -1.0f;
        }
        this.gl.glMatrixMode(5889);
        float f = 1.0f;
        if (hudInfo.fov != -1) {
            f = (float)(1.0 / Math.tan((double)hudInfo.fov * 2.56 * 7.669903939428206E-4));
        }
        if ((dastat & 0xA) == 2) {
            float ratioratio = (float)this.xdim / (float)this.ydim;
            this.parent.matrix[0][0] = f * (float)this.parent.ydimen * (ratioratio >= 1.6f ? 1.2f : 1.0f);
            this.parent.matrix[0][2] = 1.0f;
            this.parent.matrix[1][1] = f * (float)this.parent.xdimen;
            this.parent.matrix[1][2] = 1.0f;
            this.parent.matrix[2][2] = 1.0f;
            this.parent.matrix[2][3] = (float)this.parent.ydimen * (ratioratio >= 1.6f ? 1.2f : 1.0f);
            this.parent.matrix[3][2] = -1.0f;
        } else {
            this.parent.matrix[2][3] = 1.0f;
            this.parent.matrix[0][0] = 1.0f;
            float[] fArray = this.parent.matrix[0];
            fArray[0] = fArray[0] * f;
            this.parent.matrix[1][1] = (float)this.xdim / (float)this.ydim;
            float[] fArray2 = this.parent.matrix[1];
            fArray2[1] = fArray2[1] * f;
            this.parent.matrix[2][2] = 1.0001f;
            this.parent.matrix[3][2] = 1.0f - this.parent.matrix[2][2];
        }
        this.gl.glLoadMatrixf(this.parent.matrix);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        if ((hudInfo.flags & 8) != 0) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
            this.gl.glClear(256);
        }
        this.parent.globalorientation = this.hudsprite.getCstat();
        this.parent.mdrenderer.mddraw(this.parent.modelManager.getModel(picnum, dapalnum), this.hudsprite, 0, 0);
        this.parent.viewingrange = oldviewingrange;
        this.parent.gxyaspect = ogxyaspect;
        this.parent.globalshade = ogshade;
        this.parent.globalpal = ogpal;
        this.parent.gchang = ogchang;
        this.parent.gshang = ogshang;
        this.parent.gctang = ogctang;
        this.parent.gstang = ogstang;
    }

    @Override
    public void init() {
        this.gl = this.parent.gl;
    }

    @Override
    public void uninit() {
    }

    @Override
    public void nextpage() {
    }

    static class raster {
        float x;
        float y;
        float xi;
        int i;

        raster() {
        }

        public void set(raster src) {
            this.x = src.x;
            this.y = src.y;
            this.xi = src.xi;
            this.i = src.i;
        }
    }
}

