/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Polymost;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Polymost.Polymost;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.VideoContext;

public class PolymostVideoContext
extends VideoContext {
    private final Polymost polymost;

    public PolymostVideoContext(Polymost polymost) {
        this.polymost = polymost;
    }

    @Override
    public void setgFov(int gFov) {
        this.gFov = gFov;
        this.polymost.setFieldOfView(gFov);
    }

    @Override
    public void setTextureFilter(TexFilter textureFilter) {
        int maxAnisotropy;
        int anisotropy = textureFilter.getAnisotropy();
        if (anisotropy > 1 && anisotropy > (maxAnisotropy = (int)GLInfo.getMaxAnisotropicFilterLevel())) {
            TexFilter bestFilter = TexFilter.TRILINEAR;
            for (TexFilter filter : TexFilter.values()) {
                if (filter.getAnisotropy() == 1 || filter.getAnisotropy() > maxAnisotropy) continue;
                bestFilter = filter;
            }
            textureFilter = bestFilter;
        }
        this.polymost.textureCache.setFilter(textureFilter);
        this.polymost.modelManager.setTextureFilter(textureFilter);
        super.setTextureFilter(textureFilter);
    }

    @Override
    public void setUseHighTiles(boolean useHighTiles) {
        if (this.isUseHighTiles() == useHighTiles) {
            return;
        }
        Gdx.app.postRunnable(() -> {
            this.polymost.textureCache.uninit();
            this.polymost.clearskins(true);
            super.setUseHighTiles(useHighTiles);
        });
    }

    @Override
    public void setPaletteEmulation(boolean paletteEmulation) {
        if (this.polymost.enableIndexedShader(paletteEmulation)) {
            super.setPaletteEmulation(paletteEmulation);
        }
    }

    @Override
    public void setDetailMapping(boolean detailMapping) {
        if ((GLInfo.multitex == 0 || GLInfo.envcombine == 0) && detailMapping) {
            Console.out.println("Your OpenGL implementation doesn't support detail mapping. Disabling...");
            detailMapping = false;
        }
        super.setDetailMapping(detailMapping);
    }

    @Override
    public void setGlowMapping(boolean glowMapping) {
        if ((GLInfo.multitex == 0 || GLInfo.envcombine == 0) && glowMapping) {
            Console.out.println("Your OpenGL implementation doesn't support glow mapping. Disabling...");
            glowMapping = false;
        }
        super.setGlowMapping(glowMapping);
    }
}

