/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.Software.Software;

public class RenderTester
extends JFrame {
    int backBufferWidth = 640;
    int backBufferHeight = 400;
    Software software;

    public RenderTester(Software software) {
        final Raster canvas = new Raster(Color.BLACK);
        canvas.update(this.backBufferWidth, this.backBufferHeight);
        this.add(canvas);
        this.software = software;
        software.config.setgShowFPS(false);
        software.setChangeListener(new Software.ChangeListener(){
            final /* synthetic */ RenderTester this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onChangePalette(byte[] palette) {
                canvas.changePalette(palette);
            }

            @Override
            public void onNextPage(byte[] frameBuffer) {
                byte[] dst = canvas.getFrameBuffer();
                System.arraycopy(frameBuffer, 0, dst, 0, Math.min(frameBuffer.length, dst.length));
                canvas.invalidate();
                canvas.repaint();
            }
        });
    }

    public void init(Engine engine) {
        this.software.init(engine);
        this.software.resize(this.backBufferWidth, this.backBufferHeight);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void nextpage() {
        SwingUtilities.invokeLater(() -> {
            if (this.software.isInited) {
                this.software.nextpage();
            }
        });
    }

    public int drawrooms(float daposx, float daposy, float daposz, float daang, float dahoriz, int dacursectnum) {
        this.software.drawrooms(daposx, daposy, daposz, daang, dahoriz, dacursectnum);
        return 0;
    }

    public Software getSoftware() {
        return this.software;
    }

    class Raster
    extends JPanel {
        private final Color background;
        private BufferedImage display;
        private byte[] data;
        private IndexColorModel paletteModel;
        private int width;
        private int height;

        public Raster(Color background) {
            this.background = background;
            this.paletteModel = new IndexColorModel(8, 256, new byte[768], 0, false);
            this.display = new BufferedImage(1, 1, 13, this.paletteModel);
            this.data = ((DataBufferByte)this.display.getRaster().getDataBuffer()).getData();
            this.setFocusable(false);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.display, 0, 0, null);
        }

        public byte[] getFrameBuffer() {
            return this.data;
        }

        public void changePalette(byte[] palette) {
            this.paletteModel = new IndexColorModel(8, 256, palette, 0, false);
            this.display = new BufferedImage(this.paletteModel, this.display.getRaster(), false, null);
        }

        public void update(int width, int height) {
            if (this.width == width && this.height == height) {
                return;
            }
            this.width = width;
            this.height = height;
            Dimension size = new Dimension(width, height);
            this.setSize(size);
            this.setPreferredSize(size);
            this.setBackground(this.background);
            this.display = new BufferedImage(RenderTester.this.backBufferWidth, RenderTester.this.backBufferHeight, 13, this.paletteModel);
            this.data = ((DataBufferByte)this.display.getRaster().getDataBuffer()).getData();
            this.validate();
        }
    }
}

