/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Software;

import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Software.A;

public class Ac
implements A {
    private final int[] reciptable = new int[2048];
    private int transmode = 0;
    private int gbxinc;
    private int gbyinc;
    private int glogx;
    private int glogy;
    private int gshade;
    private int bpl;
    private int gpinc;
    private byte[] gtrans;
    private byte[] gbuf;
    private byte[] frameplace;
    private byte[] gpal;
    private byte[] ghlinepal;
    private byte[] hlinepal;
    private int bzinc;
    private int asm1;
    private int asm2;
    private int hlineshade;

    public Ac() {
        for (int i = 0; i < 2048; ++i) {
            this.reciptable[i] = Pragmas.divscale(2048L, i + 2048, 30);
        }
    }

    public static long toUnsignedLong(long x) {
        return x & 0xFFFFFFFFL;
    }

    @Override
    public int krecipasm(int i) {
        i = Float.floatToIntBits(i);
        return this.reciptable[i >> 12 & 0x7FF] >> (i - 1065353216 >> 23 & 0x1F) ^ i >> 31;
    }

    @Override
    public void setvlinebpl(int dabpl) {
        this.bpl = dabpl;
    }

    @Override
    public void fixtransluscence(byte[] datrans) {
        this.gtrans = datrans;
    }

    @Override
    public void settransnormal() {
        this.transmode = 0;
    }

    @Override
    public void settransreverse() {
        this.transmode = 1;
    }

    @Override
    public void sethlinesizes(int logx, int logy, byte[] bufplc) {
        this.glogx = logx;
        this.glogy = logy;
        this.gbuf = bufplc;
    }

    @Override
    public void setpalookupaddress(byte[] paladdr) {
        this.ghlinepal = paladdr;
    }

    @Override
    public void setuphlineasm4(int bxinc, int byinc) {
        this.gbxinc = bxinc;
        this.gbyinc = byinc;
    }

    @Override
    public void hlineasm4(int cnt, int skiploadincs, int paloffs, int by, int bx, int p) {
        if (skiploadincs == 0) {
            this.gbxinc = this.asm1;
            this.gbyinc = this.asm2;
        }
        byte[] remap = this.ghlinepal;
        int shiftx = 32 - this.glogx;
        int shifty = 32 - this.glogy;
        int xinc = this.gbxinc;
        int yinc = this.gbyinc;
        try {
            while (cnt >= 0) {
                int index = (bx >>> shiftx << this.glogy) + (by >>> shifty);
                if (index >= this.gbuf.length) {
                    return;
                }
                this.drawpixel(p, remap[(this.gbuf[index] & 0xFF) + paloffs]);
                bx -= xinc;
                by -= yinc;
                --p;
                --cnt;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setupslopevlin(int logylogx, byte[] bufplc, int pinc, int bzinc) {
        this.glogx = logylogx & 0xFF;
        this.glogy = logylogx >> 8;
        this.gbuf = bufplc;
        this.gpinc = pinc;
        this.bzinc = bzinc >> 3;
    }

    @Override
    public void slopevlin(int p, byte[] pal, int slopaloffs, int cnt, int bx, int by, int x3, int y3, int[] slopalookup, int bz) {
        int shiftx = 32 - this.glogx;
        int shifty = 32 - this.glogy;
        int inc = this.gpinc;
        int zinc = this.bzinc;
        int logy = this.glogy;
        byte[] buf = this.gbuf;
        try {
            while (cnt > 0) {
                int i = this.krecipasm(bz >> 6);
                bz += zinc;
                int u = bx + x3 * i;
                int v = by + y3 * i;
                int index = (u >>> shiftx << logy) + (v >>> shifty);
                if (index >= buf.length) {
                    return;
                }
                this.drawpixel(p, pal[(buf[index] & 0xFF) + slopalookup[slopaloffs]]);
                --slopaloffs;
                p += inc;
                --cnt;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setupvlineasm(int neglogy) {
        this.glogy = neglogy;
    }

    @Override
    public void vlineasm1(int vinc, byte[] pal, int shade, int cnt, long vplc, byte[] bufplc, int bufoffs, int p) {
        vplc = Ac.toUnsignedLong(vplc);
        int pl = this.bpl;
        int logy = this.glogy;
        try {
            while (cnt >= 0) {
                int index = (int)((long)bufoffs + (vplc >> logy));
                if (index < 0 || index >= bufplc.length) {
                    return;
                }
                int ch = (bufplc[index] & 0xFF) + shade;
                this.drawpixel(p, pal[ch]);
                p += pl;
                vplc = Ac.toUnsignedLong(vplc + (long)vinc);
                --cnt;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setupmvlineasm(int neglogy) {
        this.glogy = neglogy;
    }

    @Override
    public void mvlineasm1(int vinc, byte[] pal, int shade, int cnt, long vplc, byte[] bufplc, int bufoffs, int p) {
        int pl = this.bpl;
        int logy = this.glogy;
        vplc = Ac.toUnsignedLong(vplc);
        try {
            while (cnt >= 0) {
                int index = (int)((long)bufoffs + (vplc >> logy));
                if (index < 0 || index >= bufplc.length) {
                    return;
                }
                int ch = bufplc[index] & 0xFF;
                if (ch != 255) {
                    this.drawpixel(p, pal[ch + shade]);
                }
                p += pl;
                vplc = Ac.toUnsignedLong(vplc + (long)vinc);
                --cnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setuptvlineasm(int neglogy) {
        this.glogy = neglogy;
    }

    @Override
    public void tvlineasm1(int vinc, byte[] pal, int shade, int cnt, long vplc, byte[] bufplc, int bufoffs, int p) {
        int pl = this.bpl;
        int logy = this.glogy;
        byte[] trans = this.gtrans;
        byte[] frameptr = this.frameplace;
        vplc = Ac.toUnsignedLong(vplc);
        try {
            if (this.transmode != 0) {
                while (cnt >= 0) {
                    int index = (int)((long)bufoffs + (vplc >> logy));
                    if (index < 0 || index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = pal[ch + shade] & 0xFF;
                        this.drawpixel(p, trans[(frameptr[p] & 0xFF) + (dacol << 8)]);
                    }
                    p += pl;
                    vplc = Ac.toUnsignedLong(vplc + (long)vinc);
                    --cnt;
                }
            } else {
                while (cnt >= 0) {
                    int index = (int)((long)bufoffs + (vplc >> logy));
                    if (index < 0 || index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = pal[ch + shade] & 0xFF;
                        this.drawpixel(p, trans[((frameptr[p] & 0xFF) << 8) + dacol]);
                    }
                    p += pl;
                    vplc = Ac.toUnsignedLong(vplc + (long)vinc);
                    --cnt;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void sethlineincs(int x, int y) {
        this.asm1 = x;
        this.asm2 = y;
    }

    @Override
    public void setuphline(byte[] pal, int shade) {
        this.hlinepal = pal;
        this.hlineshade = shade;
    }

    @Override
    public void msethlineshift(int logx, int logy) {
        this.glogx = logx;
        this.glogy = logy;
    }

    @Override
    public void mhline(byte[] bufplc, long bx, int cntup16, int junk, long by, int p) {
        bx = Ac.toUnsignedLong(bx);
        by = Ac.toUnsignedLong(by);
        byte[] remap = this.hlinepal;
        int shiftx = 32 - this.glogx;
        int shifty = 32 - this.glogy;
        int xinc = this.asm1;
        int yinc = this.asm2;
        int shade = this.hlineshade;
        try {
            cntup16 >>= 16;
            while (cntup16 > 0) {
                int index = (int)((bx >>> shiftx << this.glogy) + (by >>> shifty));
                if (index >= bufplc.length) {
                    return;
                }
                int ch = bufplc[index] & 0xFF;
                if (ch != 255) {
                    this.drawpixel(p, remap[ch + shade]);
                }
                bx = Ac.toUnsignedLong(bx + (long)xinc);
                by = Ac.toUnsignedLong(by + (long)yinc);
                ++p;
                --cntup16;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void tsethlineshift(int logx, int logy) {
        this.glogx = logx;
        this.glogy = logy;
    }

    @Override
    public void thline(byte[] bufplc, long bx, int cntup16, int junk, long by, int p) {
        bx = Ac.toUnsignedLong(bx);
        by = Ac.toUnsignedLong(by);
        byte[] remap = this.hlinepal;
        int shiftx = 32 - this.glogx;
        int shifty = 32 - this.glogy;
        int xinc = this.asm1;
        int yinc = this.asm2;
        int shade = this.hlineshade;
        try {
            if (this.transmode != 0) {
                cntup16 >>= 16;
                while (cntup16 > 0) {
                    int index = (int)((bx >> shiftx << this.glogy) + (by >> shifty));
                    if (index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = remap[ch + shade] & 0xFF;
                        this.drawpixel(p, this.gtrans[(this.frameplace[p] & 0xFF) + (dacol << 8)]);
                    }
                    bx = Ac.toUnsignedLong(bx + (long)xinc);
                    by = Ac.toUnsignedLong(by + (long)yinc);
                    ++p;
                    --cntup16;
                }
            } else {
                cntup16 >>= 16;
                while (cntup16 > 0) {
                    int index = (int)((bx >> shiftx << this.glogy) + (by >> shifty));
                    if (index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = remap[ch + shade] & 0xFF;
                        this.drawpixel(p, this.gtrans[((this.frameplace[p] & 0xFF) << 8) + dacol]);
                    }
                    bx = Ac.toUnsignedLong(bx + (long)xinc);
                    by = Ac.toUnsignedLong(by + (long)yinc);
                    ++p;
                    --cntup16;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setupspritevline(byte[] pal, int shade, int bxinc, int byinc, int ysiz) {
        this.gpal = pal;
        this.gshade = Math.max(0, shade);
        this.gbxinc = bxinc;
        this.gbyinc = byinc;
        this.glogy = ysiz;
    }

    @Override
    public void spritevline(int bx, int by, int cnt, byte[] bufplc, int bufoffs, int p) {
        byte[] remap = this.gpal;
        int xinc = this.gbxinc;
        int yinc = this.gbyinc;
        int pl = this.bpl;
        int shade = this.gshade;
        try {
            while (cnt > 1) {
                int index = bufoffs + (bx >> 16) * this.glogy + (by >> 16);
                if (index < 0 || index >= bufplc.length) {
                    return;
                }
                this.drawpixel(p, remap[(bufplc[index] & 0xFF) + shade]);
                bx += xinc;
                by += yinc;
                p += pl;
                --cnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void msetupspritevline(byte[] pal, int shade, int bxinc, int byinc, int ysiz) {
        this.gpal = pal;
        this.gshade = Math.max(0, shade);
        this.gbxinc = bxinc;
        this.gbyinc = byinc;
        this.glogy = ysiz;
    }

    @Override
    public void mspritevline(int bx, int by, int cnt, byte[] bufplc, int bufoffs, int p) {
        byte[] remap = this.gpal;
        int xinc = this.gbxinc;
        int yinc = this.gbyinc;
        int pl = this.bpl;
        int shade = this.gshade;
        try {
            while (cnt > 1) {
                int index = bufoffs + (bx >> 16) * this.glogy + (by >> 16);
                if (index < 0 || index >= bufplc.length) {
                    return;
                }
                int ch = bufplc[index] & 0xFF;
                if (ch != 255) {
                    this.drawpixel(p, remap[ch + shade]);
                }
                bx += xinc;
                by += yinc;
                p += pl;
                --cnt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void tsetupspritevline(byte[] pal, int shade, int bxinc, int byinc, int ysiz) {
        this.gpal = pal;
        this.gshade = Math.max(0, shade);
        this.gbxinc = bxinc;
        this.gbyinc = byinc;
        this.glogy = ysiz;
    }

    @Override
    public void tspritevline(int bx, int by, int cnt, byte[] bufplc, int bufoffs, int p) {
        byte[] remap = this.gpal;
        int xinc = this.gbxinc;
        int yinc = this.gbyinc;
        int pl = this.bpl;
        int shade = this.gshade;
        try {
            if (this.transmode != 0) {
                while (cnt > 1) {
                    int index = bufoffs + (bx >> 16) * this.glogy + (by >> 16);
                    if (index < 0 || index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = remap[ch + shade] & 0xFF;
                        this.drawpixel(p, this.gtrans[(this.frameplace[p] & 0xFF) + (dacol << 8)]);
                    }
                    bx += xinc;
                    by += yinc;
                    p += pl;
                    --cnt;
                }
            } else {
                while (cnt > 1) {
                    int index = bufoffs + (bx >> 16) * this.glogy + (by >> 16);
                    if (index < 0 || index >= bufplc.length) {
                        return;
                    }
                    int ch = bufplc[index] & 0xFF;
                    if (ch != 255) {
                        int dacol = remap[ch + shade] & 0xFF;
                        this.drawpixel(p, this.gtrans[((this.frameplace[p] & 0xFF) << 8) + dacol]);
                    }
                    bx += xinc;
                    by += yinc;
                    p += pl;
                    --cnt;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setupdrawslab(int dabpl, byte[] pal, int shade, int trans) {
        this.bpl = dabpl;
        this.gpal = pal;
        this.gshade = Math.max(0, shade);
        this.transmode = trans;
    }

    @Override
    public void drawslab(int dx, int v, int dy, int vi, byte[] data, int vptr, int p) {
        byte[] remap = this.gpal;
        int pl = this.bpl;
        int shade = this.gshade;
        try {
            switch (this.transmode) {
                case 0: {
                    while (dy > 0) {
                        for (int x = 0; x < dx; ++x) {
                            this.drawpixel(p + x, remap[(data[(v >>> 16) + vptr] & 0xFF) + shade]);
                        }
                        p += pl;
                        v += vi;
                        --dy;
                    }
                    break;
                }
                case 1: {
                    while (dy > 0) {
                        for (int x = 0; x < dx; ++x) {
                            int dacol = remap[(data[(v >>> 16) + vptr] & 0xFF) + shade] & 0xFF;
                            this.drawpixel(p + x, this.gtrans[(this.frameplace[p + x] & 0xFF) + (dacol << 8)]);
                        }
                        p += pl;
                        v += vi;
                        --dy;
                    }
                    break;
                }
                case 2: {
                    while (dy > 0) {
                        for (int x = 0; x < dx; ++x) {
                            int dacol = remap[(data[(v >>> 16) + vptr] & 0xFF) + shade] & 0xFF;
                            this.drawpixel(p + x, this.gtrans[((this.frameplace[p + x] & 0xFF) << 8) + dacol]);
                        }
                        p += pl;
                        v += vi;
                        --dy;
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void drawpixel(int ptr, byte col) {
        try {
            this.frameplace[ptr] = col;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setframeplace(byte[] newframeplace) {
        this.frameplace = newframeplace;
    }

    @Override
    public byte[] getframeplace() {
        return this.frameplace;
    }

    @Override
    public void clearframe(byte dacol) {
        Gameutils.fill(this.frameplace, dacol);
    }
}

