/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.GLTile;
import ru.m210projects.Build.Render.TextureHandle.GLTileArray;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Render.Types.GL10;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.Types.font.BitmapFont;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.Types.font.TileFontData;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;

public class TextureManager {
    protected final Engine engine;
    protected final GLTileArray cache;
    protected final ExpandTexture expand;
    protected final Map<Font, GLTile> fontAtlas;
    protected TextureHDInfo info;
    protected GLTile glPalette;
    protected GLTile[] glPalookups;
    protected int texunits = 0;
    protected TexFilter textureFilter = TexFilter.NONE;
    private GLTile bindedTile;

    public TextureManager(Engine engine, ExpandTexture opt) {
        this.engine = engine;
        this.cache = new GLTileArray(Engine.MAXTILES);
        this.glPalookups = new GLTile[256];
        this.expand = opt;
        this.fontAtlas = new HashMap<Font, GLTile>();
    }

    public GLTile getBitmapFontAtlas(BitmapFont font) {
        if (!this.fontAtlas.containsKey(font)) {
            return this.fontAtlas.computeIfAbsent(font, e -> this.createGLBitmap(font));
        }
        return this.fontAtlas.get(font);
    }

    protected GLTile createGLBitmap(BitmapFont bitmapFont) {
        final int sizx = bitmapFont.getAtlasWidth();
        int sizy = bitmapFont.getAtlasHeight();
        final byte[] textfont = bitmapFont.getData();
        TileFontData dat = new TileFontData(this, sizx, sizy){
            final /* synthetic */ TextureManager this$0;
            {
                this.this$0 = this$0;
                super(width, height);
            }

            @Override
            public ByteBuffer buildAtlas(ByteBuffer data) {
                for (int h = 0; h < 256; ++h) {
                    int tptr = h % 16 * 8 + h / 16 * sizx * 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            data.put(tptr + j, (textfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0 ? (byte)-1 : 0);
                        }
                        tptr += sizx;
                    }
                }
                return data;
            }

            @Override
            public int getGLInternalFormat() {
                return 6406;
            }

            @Override
            public int getGLFormat() {
                return 6406;
            }
        };
        GLTile atlas = this.newTile(dat, 0, TexFilter.NONE);
        atlas.setupTextureFilter(TexFilter.NONE);
        return atlas;
    }

    public void setTextureInfo(TextureHDInfo info) {
        this.info = info;
    }

    public GLTile get(TileData.PixelFormat fmt, ArtEntry artEntry, int dapalnum, int skybox, int method) {
        Hicreplctyp si;
        boolean clamping = this.clampingMode(method);
        boolean alpha = this.alphaMode(method);
        Hicreplctyp hicreplctyp = si = this.engine.getConfig().isUseHighTiles() && this.info != null ? this.info.findTexture(artEntry.getNum(), dapalnum, skybox) : null;
        if (si == null && (skybox != 0 || dapalnum >= 252)) {
            return null;
        }
        GLTile tile = this.cache.get(artEntry.getNum(), dapalnum, clamping, skybox);
        if (si != null && tile != null && tile.hicr == null && si.skybox == null) {
            this.cache.dispose(artEntry.getNum());
            tile = null;
        }
        if (tile != null) {
            if (tile.isInvalidated()) {
                tile.setInvalidated(false);
                TileData data = this.loadPic(fmt, si, artEntry, dapalnum, clamping, alpha, skybox, this.textureFilter);
                tile.update(data, fmt == TileData.PixelFormat.Pal8 ? 0 : dapalnum, this.textureFilter);
            }
        } else {
            if (si != null && dapalnum != 0 && this.info.findTexture(artEntry.getNum(), 0, skybox) == si && (tile = this.cache.get(artEntry.getNum(), 0, clamping, skybox)) != null) {
                return tile;
            }
            TileData data = this.loadPic(fmt, si, artEntry, dapalnum, clamping, alpha, skybox, this.textureFilter);
            if (data == null) {
                return null;
            }
            tile = this.allocTile(data, si, artEntry, fmt == TileData.PixelFormat.Pal8 ? 0 : dapalnum, skybox, alpha, this.textureFilter);
        }
        if (dapalnum >= 252) {
            this.activateEffect();
        }
        return tile;
    }

    public TileData.PixelFormat getFmt(int dapicnum) {
        GLTile tile = this.cache.get(dapicnum);
        if (tile != null) {
            return tile.getPixelFormat();
        }
        return null;
    }

    public boolean bind(GLTile tile) {
        if (this.bindedTile == tile) {
            return false;
        }
        tile.bind();
        return true;
    }

    public void unbind() {
        if (this.bindedTile != null) {
            this.bindedTile.unbind();
        }
        this.bindedTile = null;
    }

    public void precache(TileData.PixelFormat fmt, ArtEntry pic, int dapalnum, int method) {
        this.get(fmt, pic, dapalnum, 0, method);
    }

    public int getTextureUnits() {
        return this.texunits;
    }

    protected TileData loadPic(TileData.PixelFormat fmt, Hicreplctyp hicr, ArtEntry artEntry, int dapalnum, boolean clamping, boolean alpha, int skybox, TexFilter textureFilter) {
        block4: {
            Entry entry;
            if (hicr != null && (entry = this.checkResource(hicr, artEntry.getNum(), skybox)) != null && entry.exists()) {
                try {
                    byte[] data = entry.getBytes();
                    return new PixmapTileData(new Pixmap(data, 0, data.length), clamping, this.expand.get());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (skybox == 0) break block4;
                    return null;
                }
            }
        }
        if (fmt == TileData.PixelFormat.Pal8) {
            return new IndexedTileData(artEntry, clamping, alpha, this.expand.get());
        }
        return new RGBTileData(this.engine.getPaletteManager(), artEntry, dapalnum, clamping, alpha, this.expand.get(), textureFilter != TexFilter.NONE);
    }

    @Nullable
    protected Entry checkResource(Hicreplctyp hicr, int dapic, int facen) {
        Entry fn;
        if (hicr == null) {
            return null;
        }
        if (facen > 0) {
            if (hicr.skybox == null || facen > 6 || hicr.skybox.face[facen - 1] == null) {
                return null;
            }
            fn = hicr.skybox.face[facen - 1];
        } else {
            fn = hicr.filename;
        }
        if (fn == null || !fn.exists()) {
            Console.out.println("Hightile[" + dapic + "]: File \"" + fn + "\" not found");
            if (facen > 0) {
                hicr.skybox.ignore = 1;
            } else {
                hicr.ignore = 1;
            }
            return null;
        }
        return fn;
    }

    public GLTile newTile(TileData pic, int palnum, TexFilter textureFilter) {
        return new GLTile(pic, palnum, textureFilter){

            @Override
            public void bind() {
                super.bind();
                TextureManager.this.bindedTile = this;
            }

            @Override
            public void unbind() {
                super.unbind();
                TextureManager.this.bindedTile = null;
            }

            @Override
            public void bind(int unit) {
                Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
            }
        };
    }

    public GLTile newTile(TileData.PixelFormat fmt, int width, int height) {
        return new GLTile(fmt, width, height){

            @Override
            public void bind() {
                super.bind();
                TextureManager.this.bindedTile = this;
            }

            @Override
            public void bind(int unit) {
                Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
            }

            @Override
            public void unbind() {
                super.unbind();
                TextureManager.this.bindedTile = null;
            }
        };
    }

    protected GLTile allocTile(TileData data, Hicreplctyp si, ArtEntry artEntry, int dapalnum, int skybox, boolean alpha, TexFilter textureFilter) {
        GLTile tile = this.newTile(data, data.isHighTile() ? si.palnum : dapalnum, textureFilter);
        tile.entry = artEntry;
        if (data.isHighTile()) {
            tile.setHighTile(si);
            tile.setHasAlpha(alpha);
            tile.setSkyboxFace(skybox);
            if (skybox > 0) {
                tile.scalex = (float)tile.getWidth() / 64.0f;
                tile.scaley = (float)tile.getHeight() / 64.0f;
            } else {
                if (data instanceof PixmapTileData) {
                    tile.width = ((PixmapTileData)data).getTileWidth();
                    tile.height = ((PixmapTileData)data).getTileHeight();
                }
                int width = tile.getWidth();
                int height = tile.getHeight();
                tile.scalex = (float)width / (float)artEntry.getWidth();
                tile.scaley = (float)height / (float)artEntry.getHeight();
            }
        }
        data.dispose();
        this.cache.add(tile, artEntry.getNum());
        return tile;
    }

    public void setFilter(TexFilter textureFilter) {
        this.textureFilter = textureFilter;
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.cache.setFilter(i, textureFilter);
        }
    }

    public void invalidate(int dapicnum, int dapalnum, boolean clamped) {
        GLTile tile = this.cache.get(dapicnum, dapalnum, clamped, 0);
        if (tile == null) {
            return;
        }
        if (!tile.isHighTile()) {
            tile.setInvalidated(true);
        }
    }

    public void invalidateall() {
        for (int j = Engine.MAXTILES - 1; j >= 0; --j) {
            this.cache.invalidate(j);
        }
    }

    public boolean clampingMode(int dameth) {
        return (dameth & 4) >> 2 == 1;
    }

    public boolean alphaMode(int dameth) {
        return (dameth & 0x100) == 0;
    }

    public void uninit() {
        for (int i = Engine.MAXTILES - 1; i >= 0; --i) {
            this.cache.dispose(i);
        }
        for (GLTile tile : this.fontAtlas.values()) {
            tile.delete();
        }
        this.fontAtlas.clear();
    }

    public GLTile getLastBinded() {
        return this.bindedTile;
    }

    public void activateEffect() {
        if (GLInfo.multisample == 0) {
            return;
        }
        Gdx.gl.glActiveTexture(33984 + ++this.texunits);
        Gdx.gl.glEnable(3553);
    }

    public void deactivateEffects(GL10 gl10) {
        if (GLInfo.multisample == 0) {
            return;
        }
        while (this.texunits >= 0) {
            gl10.glActiveTexture(33984 + this.texunits);
            gl10.glMatrixMode(5890);
            gl10.glLoadIdentity();
            gl10.glMatrixMode(5888);
            if (this.texunits > 0) {
                gl10.glTexEnvf(8960, 34163, 1.0f);
                gl10.glDisable(3553);
            }
            --this.texunits;
        }
        this.texunits = 0;
    }

    public GLTile getPalette() {
        return this.glPalette;
    }

    @Nullable
    public GLTile getPalookup(int pal) {
        PaletteManager paletteManager = this.engine.getPaletteManager();
        if (this.glPalookups[pal] == null || this.glPalookups[pal].isInvalidated()) {
            if (!paletteManager.isValidPalette(pal)) {
                return this.glPalookups[0];
            }
            LookupData dat = new LookupData(paletteManager.getPalookupBuffer()[pal]);
            if (this.glPalookups[pal] != null) {
                this.glPalookups[pal].setInvalidated(false);
                this.glPalookups[pal].update(dat, 0, TexFilter.NONE);
            } else {
                this.glPalookups[pal] = this.newTile(dat, 0, TexFilter.NONE);
            }
            this.glPalookups[pal].unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
        }
        return this.glPalookups[pal];
    }

    public void disposePalette() {
        this.glPalette.dispose();
        this.glPalette = null;
        for (int i = 0; i < 256; ++i) {
            if (this.glPalookups[i] == null) continue;
            this.glPalookups[i].dispose();
            this.glPalookups[i] = null;
        }
    }

    public void changePalette(byte[] pal) {
        PaletteData dat = new PaletteData(pal);
        if (this.glPalette != null) {
            this.glPalette.update(dat, 0, TexFilter.NONE);
        } else {
            this.glPalette = this.newTile(dat, 0, TexFilter.NONE);
        }
        this.glPalette.unsafeSetFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest, true);
    }

    public void invalidatepalookup(int pal) {
        if (this.glPalookups[pal] != null) {
            this.glPalookups[pal].setInvalidated(true);
        }
    }

    public static enum ExpandTexture {
        Horizontal(1),
        Vertical(2),
        Both(3);

        private final byte bit;

        private ExpandTexture(int bit) {
            this.bit = (byte)bit;
        }

        public byte get() {
            return this.bit;
        }
    }

    private static class LookupData
    extends ShaderData {
        public LookupData(byte[] data) {
            super(data, 256, 64, 1);
        }

        @Override
        public int getGLFormat() {
            return 6409;
        }
    }

    private static class PaletteData
    extends ShaderData {
        public PaletteData(byte[] data) {
            super(data, 256, 1, 3);
        }

        @Override
        public TileData.PixelFormat getPixelFormat() {
            return TileData.PixelFormat.Pal8;
        }
    }

    private static abstract class ShaderData
    extends DummyTileData {
        public ShaderData(byte[] buf, int w, int h, int bytes) {
            super(bytes != 1 ? TileData.PixelFormat.Rgb : TileData.PixelFormat.Pal8, w, h);
            this.data.clear();
            this.data.put(buf, 0, Math.min(this.data.capacity(), buf.length));
        }

        @Override
        public boolean hasAlpha() {
            return false;
        }
    }
}

