/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.TextureHandle.DummyTileData;
import ru.m210projects.Build.Render.TextureHandle.TileData;

public class TileAtlas {
    public int atlasWidth;
    public int atlasHeight;
    public int gridWidth;
    public int gridHeight;
    public int tilesPerAtlas;
    public int colsPerAtlas;
    public int rowsPerAtlas;
    protected TileData.PixelFormat fmt;
    protected int pos = 0;
    public List<TileData> atlas = new ArrayList<TileData>();
    public HashMap<Integer, TileUnit> units = new HashMap();

    public TileAtlas(TileData.PixelFormat fmt, int gridWidth, int gridHeight, int numtiles) {
        this(fmt, Math.min(1 << GLInfo.gltexmaxsize, TileAtlas.getAtlasSize(numtiles)[0] * gridWidth), Math.min(1 << GLInfo.gltexmaxsize, TileAtlas.getAtlasSize(numtiles)[1] * gridHeight), gridWidth, gridHeight, true);
    }

    public TileAtlas(TileData.PixelFormat fmt, int atlasWidth, int atlasHeight, int gridWidth, int gridHeight, boolean pow2) {
        this.fmt = fmt;
        this.atlasWidth = pow2 ? GLInfo.calcSize(atlasWidth) : atlasWidth;
        this.atlasHeight = pow2 ? GLInfo.calcSize(atlasHeight) : atlasHeight;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.colsPerAtlas = atlasWidth / gridWidth;
        this.rowsPerAtlas = atlasHeight / gridHeight;
        this.tilesPerAtlas = this.colsPerAtlas * this.rowsPerAtlas;
    }

    public void reloadTile(int nTile, TileData pic) {
        TileUnit tile = this.getTile(nTile);
        if (tile == null) {
            this.addTile(nTile, pic);
            return;
        }
        if (pic.getWidth() > this.gridWidth || pic.getHeight() > this.gridHeight) {
            System.err.println("Error: the grid size should be increased!");
            return;
        }
        if (pic.getPixelFormat() != this.fmt) {
            System.err.println("Error: different pixel format!");
            return;
        }
        this.clearTile(nTile);
        int atlasnum = tile.atlasnum;
        int u1 = (int)(tile.u1 * (float)this.atlasWidth / (float)this.gridWidth);
        int v1 = (int)(tile.v1 * (float)this.atlasHeight / (float)this.gridHeight);
        int offs = (u1 * this.gridWidth + v1 * this.atlasWidth * this.gridHeight) * this.fmt.getLength();
        ByteBuffer buf = this.atlas.get(atlasnum).getPixels();
        ByteBuffer symbolBuffer = pic.getPixels();
        int dptr = offs;
        for (int i = 0; i < pic.getHeight(); ++i) {
            dptr = i * this.fmt.getLength() * this.atlasWidth + offs;
            for (int j = 0; j < pic.getWidth(); ++j) {
                for (int k = 0; k < this.fmt.getLength(); ++k) {
                    buf.put(dptr++, symbolBuffer.get());
                }
            }
        }
        tile.u2 = (float)(u1 + 1) * (float)pic.getWidth() / (float)this.atlasWidth;
        tile.v2 = (float)(v1 + 1) * (float)pic.getHeight() / (float)this.atlasHeight;
    }

    public void clearTile(int nTile) {
        TileUnit tile = this.getTile(nTile);
        if (tile == null) {
            return;
        }
        int atlasnum = tile.atlasnum;
        int u1 = (int)(tile.u1 * (float)this.atlasWidth / (float)this.gridWidth);
        int v1 = (int)(tile.v1 * (float)this.atlasHeight / (float)this.gridHeight);
        int offs = (u1 * this.gridWidth + v1 * this.atlasWidth * this.gridHeight) * this.fmt.getLength();
        ByteBuffer buf = this.atlas.get(atlasnum).getPixels();
        int dptr = offs;
        for (int i = 0; i < this.gridHeight; ++i) {
            dptr = i * this.fmt.getLength() * this.atlasWidth + offs;
            for (int j = 0; j < this.gridWidth; ++j) {
                for (int k = 0; k < this.fmt.getLength(); ++k) {
                    buf.put(dptr++, this.fmt == TileData.PixelFormat.Pal8 ? (byte)-1 : 0);
                }
            }
        }
    }

    public void addTile(int nTile, TileData pic) {
        if (pic.getWidth() > this.gridWidth || pic.getHeight() > this.gridHeight) {
            System.err.println("Error: the grid size should be increased!");
            return;
        }
        if (pic.getPixelFormat() != this.fmt) {
            System.err.println("Error: different pixel format!");
            return;
        }
        int atlasnum = this.pos / this.tilesPerAtlas;
        int symbolnum = this.pos % this.tilesPerAtlas;
        int u1 = symbolnum % this.colsPerAtlas;
        int v1 = symbolnum / this.colsPerAtlas;
        int offs = (u1 * this.gridWidth + v1 * this.atlasWidth * this.gridHeight) * this.fmt.getLength();
        if (this.atlas.size() - 1 < atlasnum) {
            DummyTileData data = new DummyTileData(this.fmt, this.atlasWidth, this.atlasHeight);
            ByteBuffer buf = ((TileData)data).getPixels();
            for (int j = 0; j < buf.capacity(); ++j) {
                buf.put(this.fmt == TileData.PixelFormat.Pal8 ? (byte)-1 : 0);
            }
            this.atlas.add(data);
        }
        ByteBuffer buf = this.atlas.get(atlasnum).getPixels();
        ByteBuffer symbolBuffer = pic.getPixels();
        int dptr = offs;
        for (int i = 0; i < pic.getHeight(); ++i) {
            dptr = i * this.fmt.getLength() * this.atlasWidth + offs;
            for (int j = 0; j < pic.getWidth(); ++j) {
                for (int k = 0; k < this.fmt.getLength(); ++k) {
                    buf.put(dptr++, symbolBuffer.get());
                }
            }
        }
        TileUnit symb = new TileUnit(nTile);
        symb.atlasnum = atlasnum;
        symb.u1 = (float)u1 * (float)this.gridWidth / (float)this.atlasWidth;
        symb.v1 = (float)v1 * (float)this.gridHeight / (float)this.atlasHeight;
        symb.u2 = (float)(u1 + 1) * (float)pic.getWidth() / (float)this.atlasWidth;
        symb.v2 = (float)(v1 + 1) * (float)pic.getHeight() / (float)this.atlasHeight;
        this.units.put(nTile, symb);
        ++this.pos;
    }

    public TileUnit getTile(int unit) {
        return this.units.get(unit);
    }

    public void saveToFile(String path) {
        for (int i = 0; i < this.atlas.size(); ++i) {
            TileData dat = this.atlas.get(i);
            dat.save(path + i);
        }
    }

    private static int[] getAtlasSize(int numtiles) {
        int y;
        int x = (int)Math.floor(Math.sqrt(numtiles));
        if (x * x == numtiles) {
            y = x;
        } else {
            y = x + 1;
            if (x * y < numtiles) {
                // empty if block
            }
        }
        return new int[]{++x, y};
    }

    public static class TileUnit {
        public float u1;
        public float v1;
        public float u2;
        public float v2;
        public int nTile;
        public int atlasnum;

        public TileUnit(int nTile) {
            this.nTile = nTile;
        }
    }
}

