/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import com.badlogic.gdx.graphics.Pixmap;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD2.MD2Info;
import ru.m210projects.Build.Render.ModelHandle.MDModel.MD3.MD3Info;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.Voxel.VoxelData;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Script.AudioInfo;
import ru.m210projects.Build.Script.MapHackInfo;
import ru.m210projects.Build.Script.ModelsInfo;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class DefScript {
    protected boolean disposable;
    public final TextureHDInfo texInfo;
    public final ModelsInfo mdInfo;
    public final AudioInfo audInfo;
    public final MapHackInfo mapInfo;
    protected final Engine engine;
    protected Entry currentAddon;
    protected HashMap<String, List<String>> addonsIncludes;
    protected DefTile[] tiles = new DefTile[Engine.MAXTILES];
    private final Map<String, Token> basetokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            Token tok = new IncludeToken();
            this.put("#include", tok);
            this.put("include", tok);
            this.put("defineskybox", new DefineSkyboxToken());
            this.put("definetint", new DefineTint());
            this.put("model", new ModelToken());
            this.put("voxel", new VoxelToken());
            this.put("skybox", new SkyboxToken());
            this.put("tint", new TintToken());
            tok = new TextureToken();
            this.put("tile", tok);
            this.put("texture", tok);
            this.put("tilefromtexture", new TileFromTextureToken());
            this.put("animtilerange", new AnimRangeToken());
            this.put("mapinfo", new MaphackToken());
            tok = new AudioToken();
            this.put("sound", tok);
            this.put("music", tok);
            this.put("includeif", new AddonToken());
            this.put("echo", new EchoToken());
        }
    };

    public DefScript(DefScript src, Entry entry) {
        this.disposable = true;
        this.texInfo = new TextureHDInfo().setFrom(src.texInfo);
        this.mdInfo = new ModelsInfo(src.mdInfo, src.disposable);
        this.audInfo = new AudioInfo(src.audInfo);
        this.mapInfo = this.createMapHackInfo(src.mapInfo);
        this.engine = src.engine;
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            if (src.tiles[i] == null) continue;
            this.tiles[i] = new DefTile(src.tiles[i]);
        }
        if (src.addonsIncludes != null) {
            this.addonsIncludes = new HashMap();
            for (String key : src.addonsIncludes.keySet()) {
                List<String> list = src.addonsIncludes.get(key);
                ArrayList<String> clone = new ArrayList<String>(list.size());
                clone.addAll(list);
                this.addonsIncludes.put(key, clone);
            }
        }
        this.currentAddon = entry;
    }

    public DefScript(Engine engine) {
        this.disposable = false;
        this.texInfo = new TextureHDInfo();
        this.mdInfo = new ModelsInfo();
        this.audInfo = new AudioInfo();
        this.mapInfo = this.createMapHackInfo(null);
        this.engine = engine;
    }

    protected MapHackInfo createMapHackInfo(MapHackInfo src) {
        if (src != null) {
            return new MapHackInfo(src);
        }
        return new MapHackInfo();
    }

    public boolean loadScript(Entry file) {
        if (file == null) {
            Console.out.println("Def error: script not found", OsdColor.RED);
            return false;
        }
        Scriptfile script = new Scriptfile(file.getName(), file);
        if (file instanceof FileEntry) {
            script.path = ((FileEntry)file).getRelativePath().toString();
        }
        try {
            this.defsparser(script);
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.out.println("Def error: the script " + file + " has errors", OsdColor.RED);
            return false;
        }
        return true;
    }

    public boolean loadScript(String name, Entry entry) {
        if (entry == null) {
            Console.out.println("Def error: script not found", OsdColor.RED);
            return false;
        }
        try {
            this.defsparser(new Scriptfile(name, entry));
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.out.println("Def error: the script " + name + " has errors", OsdColor.RED);
            return false;
        }
        return true;
    }

    protected void addToken(String name, Token token) {
        this.basetokens.put(name, token);
    }

    protected boolean addDefTile(DefTile texstatus, int tile) {
        DefTile def = this.tiles[tile];
        if (def != null && def.crc32 != 0L) {
            if (texstatus.crc32 == 0L) {
                texstatus.next = def;
                this.tiles[tile] = texstatus;
            } else if (def.crc32 != texstatus.crc32) {
                def = this.tiles[tile].getLast();
                def.next = texstatus;
            } else if (def.internal || this.disposable) {
                this.tiles[tile] = texstatus;
            }
        } else if (def == null || def.internal || this.disposable) {
            this.tiles[tile] = texstatus;
        } else {
            return false;
        }
        return true;
    }

    protected void defsparser(Scriptfile script) {
        Console.out.println("Loading " + script.filename + "...");
        while (true) {
            Token basetoken;
            if ((basetoken = (Token)this.gettoken(script, this.basetokens)) == null) {
                continue;
            }
            if (basetoken == BaseToken.EOF) {
                return;
            }
            basetoken.parse(script);
        }
    }

    protected Object gettoken(Scriptfile sf, Map<String, ?> list) {
        if (sf == null) {
            return BaseToken.Error;
        }
        int tok = sf.gettoken();
        if (tok == -2) {
            return BaseToken.EOF;
        }
        Object out = list.get(Strhandler.toLowerCase(sf.textbuf.substring(tok, sf.textptr)));
        if (out != null) {
            return out;
        }
        sf.errorptr = sf.textptr;
        return BaseToken.Error;
    }

    protected String getFile(Scriptfile script) {
        String fn = script.getstring();
        if (fn == null) {
            return null;
        }
        fn = FileUtils.getCorrectPath(fn);
        return fn;
    }

    protected boolean check_tile(String defcmd, int tile, Scriptfile script, int cmdtokptr) {
        if (tile >= Engine.MAXTILES) {
            Console.out.println("Error: " + defcmd + ": Invalid tile number on line " + script.filename + ":" + script.getlinum(cmdtokptr), OsdColor.RED);
            return true;
        }
        return false;
    }

    protected boolean check_tile_range(String defcmd, int tilebeg, int tileend, Scriptfile script, int cmdtokptr) {
        if (tileend < tilebeg) {
            Console.out.println("Warning: " + defcmd + ": backwards tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), OsdColor.YELLOW);
            int tmp = tilebeg;
            tilebeg = tileend;
            tileend = tmp;
        }
        if (tilebeg >= Engine.MAXTILES || tileend >= Engine.MAXTILES) {
            Console.out.println("Error: " + defcmd + ": Invalid tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), OsdColor.RED);
            return true;
        }
        return false;
    }

    protected int getPtr(Scriptfile script, int line) {
        if (line <= 2) {
            return script.lineoffs[0];
        }
        if (line <= script.linenum) {
            return script.lineoffs[line - 2];
        }
        return script.eof;
    }

    public void dispose() {
        if (!this.disposable) {
            return;
        }
        this.engine.loadpics();
        for (int i = 0; i < Engine.MAXTILES; ++i) {
            if (this.tiles[i] == null) continue;
            this.texInfo.remove(i, 0);
            this.tiles[i] = null;
        }
        this.mdInfo.dispose();
    }

    public void apply() {
        int i;
        List<String> defs;
        if (this.addonsIncludes != null && this.currentAddon != null && (defs = this.addonsIncludes.get(this.currentAddon.getName())) != null) {
            for (i = 0; i < defs.size() / 2; ++i) {
                String fn = defs.get(2 * i + 1);
                Entry res = Cache.getInstance().getEntry(fn, true);
                if (!res.exists()) {
                    Console.out.println("Warning: Failed including " + fn + " as module", OsdColor.RED);
                    continue;
                }
                Scriptfile included = new Scriptfile(fn, res);
                included.path = defs.get(2 * i);
                this.defsparser(included);
            }
        }
        for (i = 0; i < Engine.MAXTILES; ++i) {
            long crc32;
            if (this.tiles[i] == null) continue;
            DefTile tile = this.tiles[i];
            ArtEntry pic = this.engine.getTile(i);
            if (tile.crc32 != 0L && (crc32 = pic.getChecksum()) != tile.crc32) {
                boolean found = false;
                while (tile.next != null) {
                    tile = tile.next;
                    if (tile.crc32 != 0L && crc32 != tile.crc32) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (tile.waloff == null) continue;
            byte[] tileData = tile.waloff;
            ArtEntry transferEntry = new ArtEntry(() -> new ByteArrayInputStream(tileData), i, 0, tile.sizx, tile.sizy, pic.getFlags());
            transferEntry.setOffset(tile.xoffset, tile.yoffset);
            DynamicArtEntry newPic = this.engine.getTileManager().allocatepermanenttile(transferEntry);
            newPic.invalidate();
            this.texInfo.addTexture(i, 0, tile.hrp, (float)(255 - (tile.alphacut & 0xFF)) * 0.003921569f, 1.0f, 1.0f, 1.0f, 1.0f, 0);
        }
    }

    protected boolean checkErrorToken(Scriptfile script, Object tk) {
        if (tk instanceof BaseToken) {
            int line = script.getlinum(script.ltextptr);
            Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(this.getPtr(script, line), this.getPtr(script, line + 1))), OsdColor.RED);
            return true;
        }
        return false;
    }

    protected static class DefTile {
        public long crc32;
        public byte[] waloff;
        public short sizx;
        public short sizy;
        public byte xoffset;
        public byte yoffset;
        public Entry hrp;
        public byte alphacut;
        public final boolean internal;
        public int optional;
        public DefTile next;

        public DefTile(DefTile src) {
            this.crc32 = src.crc32;
            this.waloff = src.waloff;
            this.sizx = src.sizx;
            this.sizy = src.sizy;
            this.xoffset = src.xoffset;
            this.yoffset = src.yoffset;
            this.hrp = src.hrp;
            this.alphacut = src.alphacut;
            this.internal = src.internal;
            this.optional = src.optional;
            if (src.next != null) {
                this.next = new DefTile(src.next);
            }
        }

        public DefTile(int sizx, int sizy, long crc32, boolean internal) {
            this.sizx = (short)sizx;
            this.sizy = (short)sizy;
            this.crc32 = crc32;
            this.internal = internal;
        }

        public DefTile getLast() {
            DefTile out = this;
            DefTile n;
            while ((n = out.next) != null) {
                out = n;
            }
            return out;
        }
    }

    public static interface Token {
        public BaseToken parse(Scriptfile var1);
    }

    public static enum BaseToken implements Token
    {
        Ok,
        Warning,
        Error,
        EOF;


        @Override
        public BaseToken parse(Scriptfile script) {
            return this;
        }
    }

    protected class AudioToken
    implements Token {
        private final Map<String, AudioTokens> sound_musictokens = new HashMap<String, AudioTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", AudioTokens.ID);
                this.put("midi", AudioTokens.ID);
                this.put("map", AudioTokens.ID);
                this.put("file", AudioTokens.FILE);
            }
        };

        protected AudioToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String t_id = null;
            String t_file = null;
            int dummy = script.getbraces();
            if (dummy == -1) {
                return BaseToken.Error;
            }
            block4: while (script.textptr < dummy) {
                Object tk = DefScript.this.gettoken(script, this.sound_musictokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                switch (((AudioTokens)((Object)tk)).ordinal()) {
                    default: {
                        continue block4;
                    }
                    case 0: {
                        String t = script.getstring();
                        if (t == null) continue block4;
                        t_id = t.trim();
                        continue block4;
                    }
                    case 1: 
                }
                t_file = DefScript.this.getFile(script);
            }
            script.skipbrace(dummy);
            DefScript.this.audInfo.addDigitalInfo(t_id, t_file);
            return BaseToken.Ok;
        }
    }

    public static enum AudioTokens {
        ID,
        FILE;

    }

    protected class TintToken
    implements Token {
        private final Map<String, TintTokens> tinttokens = new HashMap<String, TintTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", TintTokens.PAL);
                this.put("red", TintTokens.RED);
                this.put("green", TintTokens.GREEN);
                this.put("blue", TintTokens.BLUE);
                this.put("flags", TintTokens.FLAGS);
            }
        };

        protected TintToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int pal = -1;
            int r = 255;
            int g = 255;
            int b = 255;
            int f = 0;
            int send = script.getbraces();
            if (send == -1) {
                return BaseToken.Error;
            }
            while (script.textptr < send) {
                try {
                    Object tk = DefScript.this.gettoken(script, this.tinttokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                        continue;
                    }
                    switch (((TintTokens)((Object)tk)).ordinal()) {
                        case 0: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            pal = ivalue;
                            break;
                        }
                        case 1: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            r = ivalue;
                            break;
                        }
                        case 2: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            g = ivalue;
                            break;
                        }
                        case 3: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            b = ivalue;
                            break;
                        }
                        case 4: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            f = ivalue;
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            script.skipbrace(send);
            if (pal == -1) {
                Console.out.println("Tint palette is not found!", OsdColor.RED);
                return BaseToken.Error;
            }
            Console.out.println("Loading tint " + pal);
            DefScript.this.texInfo.setPaletteTint(pal, r, g, b, f);
            return BaseToken.Ok;
        }
    }

    protected static enum TintTokens {
        PAL,
        RED,
        GREEN,
        BLUE,
        FLAGS;

    }

    protected class DefineTint
    implements Token {
        protected DefineTint() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer pal = script.getsymbol();
            if (pal == null) {
                return BaseToken.Error;
            }
            Integer r = script.getsymbol();
            if (r == null) {
                return BaseToken.Error;
            }
            Integer g = script.getsymbol();
            if (g == null) {
                return BaseToken.Error;
            }
            Integer b = script.getsymbol();
            if (b == null) {
                return BaseToken.Error;
            }
            Integer f = script.getsymbol();
            if (f == null) {
                return BaseToken.Error;
            }
            Console.out.println("Loading tint " + pal);
            DefScript.this.texInfo.setPaletteTint(pal, r, g, b, f);
            return BaseToken.Ok;
        }
    }

    protected class DefineSkyboxToken
    extends SkyboxToken {
        protected DefineSkyboxToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int stile = -1;
            int spal = 0;
            String[] sfn = new String[6];
            Integer ivalue = script.getsymbol();
            if (ivalue != null) {
                stile = ivalue;
            }
            if ((ivalue = script.getsymbol()) != null) {
                spal = ivalue;
            }
            script.getsymbol();
            sfn[0] = DefScript.this.getFile(script);
            sfn[1] = DefScript.this.getFile(script);
            sfn[2] = DefScript.this.getFile(script);
            sfn[3] = DefScript.this.getFile(script);
            sfn[4] = DefScript.this.getFile(script);
            sfn[5] = DefScript.this.getFile(script);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }
    }

    protected class SkyboxToken
    implements Token {
        private final String[] skyfaces = new String[]{"front face", "right face", "back face", "left face", "top face", "bottom face"};
        private final Map<String, SkyboxTokens> skyboxtokens = new HashMap<String, SkyboxTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", SkyboxTokens.TILE);
                this.put("pal", SkyboxTokens.PAL);
                this.put("ft", SkyboxTokens.FRONT);
                this.put("front", SkyboxTokens.FRONT);
                this.put("forward", SkyboxTokens.FRONT);
                this.put("rt", SkyboxTokens.RIGHT);
                this.put("right", SkyboxTokens.RIGHT);
                this.put("bk", SkyboxTokens.BACK);
                this.put("back", SkyboxTokens.BACK);
                this.put("lf", SkyboxTokens.LEFT);
                this.put("left", SkyboxTokens.LEFT);
                this.put("lt", SkyboxTokens.LEFT);
                this.put("up", SkyboxTokens.TOP);
                this.put("top", SkyboxTokens.TOP);
                this.put("ceiling", SkyboxTokens.TOP);
                this.put("ceil", SkyboxTokens.TOP);
                this.put("dn", SkyboxTokens.BOTTOM);
                this.put("bottom", SkyboxTokens.BOTTOM);
                this.put("floor", SkyboxTokens.BOTTOM);
                this.put("down", SkyboxTokens.BOTTOM);
                this.put("nocompress", SkyboxTokens.NOCOMPRESS);
                this.put("nodownsize", SkyboxTokens.NODOWNSIZE);
            }
        };

        protected SkyboxToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int stile = -1;
            int spal = 0;
            String[] sfn = new String[6];
            int sskyend = script.getbraces();
            if (sskyend == -1) {
                return BaseToken.Error;
            }
            while (script.textptr < sskyend) {
                try {
                    Object tk = DefScript.this.gettoken(script, this.skyboxtokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                        continue;
                    }
                    switch (((SkyboxTokens)((Object)tk)).ordinal()) {
                        case 0: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            stile = ivalue;
                            break;
                        }
                        case 1: {
                            Integer ivalue = script.getsymbol();
                            if (ivalue == null) break;
                            spal = ivalue;
                            break;
                        }
                        case 2: {
                            sfn[0] = DefScript.this.getFile(script);
                            break;
                        }
                        case 3: {
                            sfn[1] = DefScript.this.getFile(script);
                            break;
                        }
                        case 4: {
                            sfn[2] = DefScript.this.getFile(script);
                            break;
                        }
                        case 5: {
                            sfn[3] = DefScript.this.getFile(script);
                            break;
                        }
                        case 6: {
                            sfn[4] = DefScript.this.getFile(script);
                            break;
                        }
                        case 7: {
                            sfn[5] = DefScript.this.getFile(script);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            script.skipbrace(sskyend);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        public boolean addSkybox(Scriptfile script, int stile, int spal, String[] sfn) {
            if (stile < 0) {
                Console.out.println("Error: skybox: missing 'tile number' near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                return false;
            }
            Entry[] faces = new Entry[6];
            for (int i = 0; i < 6; ++i) {
                if (sfn[i] == null) {
                    Console.out.println("Error: skybox: missing " + this.skyfaces[i] + " filename' near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                    return false;
                }
                faces[i] = Cache.getInstance().getEntry(sfn[i], true);
                if (faces[i].exists()) continue;
                Console.out.println("Error: file \"" + sfn[i] + "\" does not exist", OsdColor.RED);
                return false;
            }
            DefScript.this.texInfo.addSkybox(stile, spal, faces);
            return true;
        }
    }

    public static enum SkyboxTokens {
        TILE,
        PAL,
        FRONT,
        RIGHT,
        BACK,
        LEFT,
        TOP,
        BOTTOM,
        NOCOMPRESS,
        NODOWNSIZE;

    }

    protected class VoxelToken
    implements Token {
        private final Map<String, VoxelTokens> voxeltokens = new HashMap<String, VoxelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", VoxelTokens.TILE);
                this.put("tile0", VoxelTokens.TILE0);
                this.put("tile1", VoxelTokens.TILE1);
                this.put("scale", VoxelTokens.SCALE);
                this.put("rotate", VoxelTokens.ROTATE);
            }
        };

        protected VoxelToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            double vscale = 1.0;
            int tile0 = Engine.MAXTILES;
            int tile1 = -1;
            boolean vrotate = false;
            String fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Error;
            }
            int vmodelend = script.getbraces();
            if (vmodelend == -1) {
                return BaseToken.Error;
            }
            Entry res = Cache.getInstance().getEntry(fn, true);
            if (!res.exists()) {
                Console.out.println("Warning: File not found" + fn, OsdColor.YELLOW);
                script.textptr = vmodelend + 1;
                return BaseToken.Warning;
            }
            VoxelInfo vox = null;
            try {
                vox = new VoxelInfo(new VoxelData(res));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (vox == null) {
                Console.out.println("Warning: Failed loading voxel model " + fn, OsdColor.YELLOW);
                script.textptr = vmodelend + 1;
                return BaseToken.Warning;
            }
            while (script.textptr < vmodelend) {
                Object tk = DefScript.this.gettoken(script, this.voxeltokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                switch (((VoxelTokens)((Object)tk)).ordinal()) {
                    case 0: {
                        int tilex = script.getsymbol();
                        if (DefScript.this.check_tile("voxel", tilex, script, script.ltextptr)) break;
                        DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                        break;
                    }
                    case 1: {
                        Integer ivalue = script.getsymbol();
                        if (ivalue == null) break;
                        tile0 = ivalue;
                        break;
                    }
                    case 2: {
                        int tilex;
                        Integer ivalue = script.getsymbol();
                        if (ivalue != null) {
                            tile1 = ivalue;
                        }
                        if (DefScript.this.check_tile_range("voxel", tile0, tile1, script, script.ltextptr)) break;
                        for (tilex = tile0; tilex <= tile1; ++tilex) {
                            DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                        }
                        break;
                    }
                    case 3: {
                        Double dvalue = script.getdouble();
                        if (dvalue == null) break;
                        vscale = dvalue;
                        break;
                    }
                    case 4: {
                        vrotate = true;
                        break;
                    }
                }
            }
            script.skipbrace(vmodelend);
            vox.setMisc((float)vscale * 65536.0f, 0.0f, 0.0f, vrotate ? 2 : 0);
            return BaseToken.Ok;
        }
    }

    public static enum VoxelTokens {
        TILE,
        TILE0,
        TILE1,
        SCALE,
        ROTATE;

    }

    protected class TextureToken
    implements Token {
        private final Map<String, TextureTokens> texturetokens = new HashMap<String, TextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", TextureTokens.PAL);
                this.put("detail", TextureTokens.DETAIL);
                this.put("glow", TextureTokens.GLOW);
                this.put("specular", TextureTokens.SPECULAR);
                this.put("normal", TextureTokens.NORMAL);
                this.put("file", TextureTokens.FILE);
                this.put("name", TextureTokens.FILE);
                this.put("alphacut", TextureTokens.ALPHACUT);
                this.put("detailscale", TextureTokens.XSCALE);
                this.put("scale", TextureTokens.XSCALE);
                this.put("xscale", TextureTokens.XSCALE);
                this.put("intensity", TextureTokens.XSCALE);
                this.put("yscale", TextureTokens.YSCALE);
                this.put("specpower", TextureTokens.SPECPOWER);
                this.put("specularpower", TextureTokens.SPECPOWER);
                this.put("parallaxscale", TextureTokens.PARALLAXSCALE);
                this.put("specfactor", TextureTokens.SPECFACTOR);
                this.put("specularfactor", TextureTokens.SPECFACTOR);
                this.put("parallaxbias", TextureTokens.PARALLAXBIAS);
                this.put("nocompress", TextureTokens.NOCOMPRESS);
                this.put("nodownsize", TextureTokens.NODOWNSIZE);
            }
        };

        protected TextureToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer ttile = script.getsymbol();
            if (ttile == null) {
                return BaseToken.Error;
            }
            int textureend = script.getbraces();
            if (textureend == -1) {
                return BaseToken.Error;
            }
            block22: while (script.textptr < textureend) {
                int palend;
                Object tk = DefScript.this.gettoken(script, this.texturetokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                TextureTokens token = (TextureTokens)((Object)tk);
                switch (token.ordinal()) {
                    default: {
                        continue block22;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                }
                Integer tpal = -1;
                Entry tfn = null;
                double alphacut = -1.0;
                double xscale = 1.0;
                double yscale = 1.0;
                double specpower = 1.0;
                double specfactor = 1.0;
                int flags = 0;
                if (token == TextureTokens.PAL && (tpal = script.getsymbol()) == null || (palend = script.getbraces()) == -1) continue;
                block23: while (script.textptr < palend) {
                    tk = DefScript.this.gettoken(script, this.texturetokens);
                    if (tk instanceof BaseToken) {
                        int line = script.getlinum(script.ltextptr);
                        Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                        continue;
                    }
                    switch (((TextureTokens)((Object)tk)).ordinal()) {
                        default: {
                            continue block23;
                        }
                        case 0: {
                            Path filePath = FileUtils.getPath(DefScript.this.getFile(script), new String[0]);
                            if (DefScript.this.currentAddon != null) {
                                tfn = DefScript.this.currentAddon.getParent().getEntry(filePath);
                                continue block23;
                            }
                            tfn = Cache.getInstance().getEntry(filePath, true);
                            continue block23;
                        }
                        case 6: {
                            Double dvalue;
                            if (token != TextureTokens.PAL || (dvalue = script.getdouble()) == null) continue block23;
                            alphacut = dvalue;
                            continue block23;
                        }
                        case 7: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            xscale = dvalue;
                            continue block23;
                        }
                        case 8: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            yscale = dvalue;
                            continue block23;
                        }
                        case 9: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            specpower = dvalue;
                            continue block23;
                        }
                        case 10: {
                            Double dvalue = script.getdouble();
                            if (dvalue == null) continue block23;
                            specfactor = dvalue;
                            continue block23;
                        }
                        case 14: {
                            script.getdouble();
                            continue block23;
                        }
                        case 13: {
                            script.getdouble();
                            continue block23;
                        }
                        case 11: {
                            flags |= 1;
                            continue block23;
                        }
                        case 12: 
                    }
                    flags |= 0x10;
                }
                script.skipbrace(palend);
                switch (token.ordinal()) {
                    default: {
                        break;
                    }
                    case 1: {
                        xscale = 1.0 / xscale;
                        yscale = 1.0 / yscale;
                        break;
                    }
                    case 2: {
                        tpal = 255;
                        xscale = 1.0 / xscale;
                        yscale = 1.0 / yscale;
                        break;
                    }
                    case 3: {
                        tpal = 254;
                        break;
                    }
                    case 4: {
                        tpal = 253;
                        break;
                    }
                    case 5: {
                        tpal = 252;
                    }
                }
                if (ttile >= Engine.MAXTILES) continue;
                if (token == TextureTokens.PAL && tpal >= 252) {
                    Console.out.println("Error: missing or invalid 'palette number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                    return BaseToken.Error;
                }
                if (tfn == null) {
                    Console.out.println("Error: missing 'file name' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                    return BaseToken.Error;
                }
                if (!tfn.exists()) {
                    Console.out.println("Error: file \"" + tfn + "\" not found for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                    return BaseToken.Error;
                }
                DefScript.this.texInfo.addTexture(ttile, tpal, tfn, (float)alphacut, (float)xscale, (float)yscale, (float)specpower, (float)specfactor, flags);
            }
            script.skipbrace(textureend);
            if (ttile >= Engine.MAXTILES) {
                Console.out.println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), OsdColor.RED);
                return BaseToken.Error;
            }
            return BaseToken.Ok;
        }
    }

    protected static enum TextureTokens {
        FILE,
        PAL,
        DETAIL,
        GLOW,
        SPECULAR,
        NORMAL,
        ALPHACUT,
        XSCALE,
        YSCALE,
        SPECPOWER,
        SPECFACTOR,
        NOCOMPRESS,
        NODOWNSIZE,
        PARALLAXBIAS,
        PARALLAXSCALE;

    }

    protected class ModelToken
    implements Token {
        protected int modelskin = -1;
        protected int lastmodelskin = -1;
        protected int seenframe = 0;
        protected final Map<String, ModelTokens> modeltokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("scale", ModelTokens.SCALE);
                this.put("shade", ModelTokens.SHADE);
                this.put("zadd", ModelTokens.ZADD);
                this.put("frame", ModelTokens.FRAME);
                this.put("anim", ModelTokens.ANIM);
                this.put("skin", ModelTokens.SKIN);
                this.put("detail", ModelTokens.DETAIL);
                this.put("glow", ModelTokens.GLOW);
                this.put("specular", ModelTokens.SPECULAR);
                this.put("normal", ModelTokens.NORMAL);
                this.put("hud", ModelTokens.HUD);
                this.put("flags", ModelTokens.FLAGS);
            }
        };
        private final Map<String, ModelTokens> modelframetokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame", ModelTokens.FRAME);
                this.put("name", ModelTokens.FRAME);
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
                this.put("smoothduration", ModelTokens.SMOOTHDURATION);
                this.put("pal", ModelTokens.PAL);
            }
        };
        private final Map<String, ModelTokens> modelanimtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame0", ModelTokens.FRAME0);
                this.put("frame1", ModelTokens.FRAME1);
                this.put("fps", ModelTokens.FPS);
                this.put("flags", ModelTokens.FLAGS);
            }
        };
        private final Map<String, ModelTokens> modelskintokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", ModelTokens.PAL);
                this.put("file", ModelTokens.FILE);
                this.put("surf", ModelTokens.SURF);
                this.put("surface", ModelTokens.SURF);
                this.put("specpower", ModelTokens.SPECPOWER);
                this.put("specfactor", ModelTokens.SPECFACTOR);
                this.put("parallaxscale", ModelTokens.PARALLAXSCALE);
                this.put("parallaxbias", ModelTokens.PARALLAXBIAS);
            }
        };
        private final Map<String, ModelTokens> modelhudtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
                this.put("xadd", ModelTokens.XADD);
                this.put("yadd", ModelTokens.YADD);
                this.put("zadd", ModelTokens.ZADD);
                this.put("fov", ModelTokens.FOV);
                this.put("angadd", ModelTokens.ANGADD);
                this.put("hide", ModelTokens.HIDE);
                this.put("nobob", ModelTokens.NOBOB);
                this.put("flipped", ModelTokens.FLIPPED);
                this.put("nodepth", ModelTokens.NODEPTH);
            }
        };

        protected ModelToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            mdscale = 1.0;
            mzadd = 0.0;
            myoffset = 0.0;
            mdflags = 0;
            mdpal = 0;
            model_ok = true;
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            modelfn = script.getstring();
            if (modelfn == null) {
                return BaseToken.Error;
            }
            modelend = script.getbraces();
            if (modelend == -1) {
                return BaseToken.Error;
            }
            res = Cache.getInstance().getEntry(modelfn, true);
            if (!res.exists()) {
                Console.out.println("Warning: File not found" + modelfn, OsdColor.YELLOW);
                script.textptr = modelend + 1;
                return BaseToken.Warning;
            }
            m = null;
            try {
                is = res.getInputStream();
                try {
                    sign = StreamUtils.readInt(is);
                    switch (sign) {
                        case 844121161: {
                            m = new MD2Info(res);
                            ** break;
lbl30:
                            // 1 sources

                            break;
                        }
                        case 860898377: {
                            m = new MD3Info(res);
                            ** break;
lbl34:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (res.isExtension("kvx")) {
                                m = new ModelInfo(res, ModelInfo.Type.Voxel);
                            }
                            break;
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (m == null) {
                Console.out.println("Warning: Failed loading model " + modelfn, OsdColor.YELLOW);
                script.textptr = modelend + 1;
                return BaseToken.Warning;
            }
            block78: while (script.textptr < modelend) {
                tk = DefScript.this.gettoken(script, this.modeltokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                token = (ModelTokens)tk;
                block7 : switch (token.ordinal()) {
                    default: {
                        break;
                    }
                    case 0: {
                        dvalue = script.getdouble();
                        if (dvalue == null) continue block78;
                        mdscale = dvalue;
                        break;
                    }
                    case 1: {
                        ivalue = script.getsymbol();
                        if (ivalue == null) continue block78;
                        break;
                    }
                    case 4: {
                        dvalue = script.getdouble();
                        if (dvalue == null) continue block78;
                        mzadd = dvalue;
                        break;
                    }
                    case 15: {
                        ivalue = script.getsymbol();
                        if (ivalue == null) continue block78;
                        mdflags = ivalue;
                        break;
                    }
                    case 5: {
                        frametokptr = script.ltextptr;
                        happy = true;
                        framename = null;
                        ftilenume = -1;
                        ltilenume = -1;
                        smoothduration = 0.1;
                        frameend = script.getbraces();
                        if (frameend == -1) break;
                        block79: while (script.textptr < frameend) {
                            tk = DefScript.this.gettoken(script, this.modelframetokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                                continue;
                            }
                            switch (((ModelTokens)tk).ordinal()) {
                                default: {
                                    continue block79;
                                }
                                case 16: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block79;
                                    mdpal = ivalue;
                                    continue block79;
                                }
                                case 5: {
                                    framename = script.getstring();
                                    continue block79;
                                }
                                case 11: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block79;
                                    ltilenume = ftilenume = ivalue.intValue();
                                    continue block79;
                                }
                                case 12: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block79;
                                    ftilenume = ivalue;
                                    continue block79;
                                }
                                case 13: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block79;
                                    ltilenume = ivalue;
                                    continue block79;
                                }
                                case 34: 
                            }
                            dvalue = script.getdouble();
                            if (dvalue == null) continue;
                            smoothduration = dvalue;
                        }
                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("model: frame", ftilenume, ltilenume, script, frametokptr)) {
                            model_ok = false;
                            break;
                        }
                        for (tilex = ftilenume; tilex <= ltilenume && happy; ++tilex) {
                            switch (DefScript.this.mdInfo.addModelInfo(m, tilex, framename, Math.max(0, this.modelskin), (float)smoothduration, mdpal)) {
                                case -1: {
                                    happy = false;
                                    break;
                                }
                                case -2: {
                                    Console.out.println("Invalid tile number on line " + script.filename + ":" + script.getlinum(frametokptr), OsdColor.RED);
                                    happy = false;
                                    break;
                                }
                                case -3: {
                                    Console.out.println("Invalid frame name on line " + script.filename + ":" + script.getlinum(frametokptr), OsdColor.RED);
                                    happy = false;
                                    break;
                                }
                            }
                            model_ok &= happy;
                        }
                        this.seenframe = 1;
                        break;
                    }
                    case 8: {
                        animtokptr = script.ltextptr;
                        happy = true;
                        startframe = null;
                        endframe = null;
                        flags = 0;
                        dfps = 1.0;
                        animend = script.getbraces();
                        if (animend == -1) break;
                        block81: while (script.textptr < animend) {
                            tk = DefScript.this.gettoken(script, this.modelanimtokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                                continue;
                            }
                            switch (((ModelTokens)tk).ordinal()) {
                                default: {
                                    continue block81;
                                }
                                case 6: {
                                    startframe = script.getstring();
                                    continue block81;
                                }
                                case 7: {
                                    endframe = script.getstring();
                                    continue block81;
                                }
                                case 14: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block81;
                                    dfps = dvalue;
                                    continue block81;
                                }
                                case 15: 
                            }
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue;
                            flags = ivalue;
                        }
                        script.skipbrace(animend);
                        if (startframe == null) {
                            Console.out.println("Error: missing 'start frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), OsdColor.RED);
                            happy = false;
                        }
                        if (endframe == null) {
                            Console.out.println("Error: missing 'end frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), OsdColor.RED);
                            happy = false;
                        }
                        model_ok &= happy;
                        if (!happy) continue block78;
                        if (m.getType() == ModelInfo.Type.Voxel) break;
                        switch (((MDInfo)m).setAnimation(startframe, endframe, (int)(dfps * 65.536), flags)) {
                            case -2: {
                                Console.out.println("Invalid starting frame name on line " + script.filename + ":" + script.getlinum(animtokptr), OsdColor.RED);
                                model_ok = false;
                                break block7;
                            }
                            case -3: {
                                Console.out.println("Invalid ending frame name on line " + script.filename + ":" + script.getlinum(animtokptr), OsdColor.RED);
                                model_ok = false;
                            }
                        }
                        break;
                    }
                    case 9: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        skintokptr = script.ltextptr;
                        skinfn = null;
                        palnum = 0;
                        surfnum = 0;
                        param = 1.0;
                        specpower = 1.0;
                        specfactor = 1.0;
                        skinend = script.getbraces();
                        if (skinend == -1) break;
                        block82: while (script.textptr < skinend) {
                            tk = DefScript.this.gettoken(script, this.modelskintokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                                continue;
                            }
                            switch (((ModelTokens)tk).ordinal()) {
                                default: {
                                    continue block82;
                                }
                                case 16: {
                                    palnum = script.getsymbol();
                                    continue block82;
                                }
                                case 31: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block82;
                                    param = dvalue;
                                    continue block82;
                                }
                                case 32: {
                                    script.getdouble();
                                    continue block82;
                                }
                                case 33: {
                                    script.getdouble();
                                    continue block82;
                                }
                                case 29: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block82;
                                    specpower = dvalue;
                                    continue block82;
                                }
                                case 30: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block82;
                                    specfactor = dvalue;
                                    continue block82;
                                }
                                case 17: {
                                    skinfn = DefScript.this.getFile(script);
                                    continue block82;
                                }
                                case 18: 
                            }
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue;
                            surfnum = ivalue;
                        }
                        script.skipbrace(skinend);
                        if (skinfn == null) {
                            Console.out.println("Error: missing 'skin filename' for skin definition near line " + script.filename + ":" + script.getlinum(skintokptr), OsdColor.RED);
                            model_ok = false;
                            break;
                        }
                        if (this.seenframe != 0) {
                            this.modelskin = ++this.lastmodelskin;
                        }
                        this.seenframe = 0;
                        switch (token.ordinal()) {
                            default: {
                                break;
                            }
                            case 25: {
                                palnum = 255;
                                param = 1.0 / param;
                                break;
                            }
                            case 28: {
                                palnum = 254;
                                break;
                            }
                            case 27: {
                                palnum = 253;
                                break;
                            }
                            case 26: {
                                palnum = 252;
                            }
                        }
                        if (!Cache.getInstance().getEntry(skinfn, true).exists()) continue block78;
                        if (m.getType() == ModelInfo.Type.Voxel) break;
                        switch (((MDInfo)m).setSkin(skinfn, palnum, Math.max(0, this.modelskin), surfnum, param, specpower, specfactor)) {
                            case -2: {
                                Console.out.println("Invalid skin filename on line " + script.filename + ":" + script.getlinum(skintokptr), OsdColor.RED);
                                model_ok = false;
                                break block7;
                            }
                            case -3: {
                                Console.out.println("Invalid palette number on line " + script.filename + ":" + script.getlinum(skintokptr), OsdColor.RED);
                                model_ok = false;
                            }
                        }
                        break;
                    }
                    case 10: {
                        hudtokptr = script.ltextptr;
                        happy = true;
                        ftilenume = -1;
                        ltilenume = -1;
                        flags = 0;
                        fov = -1;
                        xadd = 0.0;
                        yadd = 0.0;
                        zadd = 0.0;
                        angadd = 0.0;
                        frameend = script.getbraces();
                        if (frameend == -1) break;
                        block83: while (script.textptr < frameend) {
                            tk = DefScript.this.gettoken(script, this.modelhudtokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                                continue;
                            }
                            switch (((ModelTokens)tk).ordinal()) {
                                default: {
                                    continue block83;
                                }
                                case 11: {
                                    ivalue = script.getsymbol();
                                    if (ivalue != null) {
                                        ftilenume = ivalue;
                                    }
                                    ltilenume = ftilenume;
                                    continue block83;
                                }
                                case 12: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block83;
                                    ftilenume = ivalue;
                                    continue block83;
                                }
                                case 13: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block83;
                                    ltilenume = ivalue;
                                    continue block83;
                                }
                                case 2: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block83;
                                    xadd = dvalue;
                                    continue block83;
                                }
                                case 3: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block83;
                                    yadd = dvalue;
                                    continue block83;
                                }
                                case 4: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block83;
                                    zadd = dvalue;
                                    continue block83;
                                }
                                case 19: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block83;
                                    angadd = dvalue;
                                    continue block83;
                                }
                                case 20: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block83;
                                    fov = ivalue;
                                    continue block83;
                                }
                                case 21: {
                                    flags |= 1;
                                    continue block83;
                                }
                                case 22: {
                                    flags |= 2;
                                    continue block83;
                                }
                                case 23: {
                                    flags |= 4;
                                    continue block83;
                                }
                                case 24: 
                            }
                            flags |= 8;
                        }
                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("hud", ftilenume, ltilenume, script, hudtokptr)) {
                            model_ok = false;
                            break;
                        }
                        for (tilex = ftilenume; tilex <= ltilenume && happy; ++tilex) {
                            if (DefScript.this.mdInfo.addHudInfo(tilex, xadd, yadd, zadd, (short)angadd, flags, fov) == -2) {
                                Console.out.println("Invalid tile number on line " + script.filename + ":" + script.getlinum(hudtokptr), OsdColor.RED);
                                happy = false;
                            }
                            model_ok &= happy;
                        }
                        continue block78;
                    }
                }
            }
            script.skipbrace(modelend);
            if (!model_ok) {
                Console.out.println("Removing model " + modelfn + " due to errors.", OsdColor.YELLOW);
                DefScript.this.mdInfo.removeModelInfo(m);
                return BaseToken.Error;
            }
            m.setMisc((float)mdscale, (float)mzadd, (float)myoffset, mdflags);
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            return BaseToken.Ok;
        }
    }

    protected static enum ModelTokens {
        SCALE,
        SHADE,
        XADD,
        YADD,
        ZADD,
        FRAME,
        FRAME0,
        FRAME1,
        ANIM,
        SKIN,
        HUD,
        TILE,
        TILE0,
        TILE1,
        FPS,
        FLAGS,
        PAL,
        FILE,
        SURF,
        ANGADD,
        FOV,
        HIDE,
        NOBOB,
        FLIPPED,
        NODEPTH,
        DETAIL,
        NORMAL,
        SPECULAR,
        GLOW,
        SPECPOWER,
        SPECFACTOR,
        PARAM,
        PARALLAXSCALE,
        PARALLAXBIAS,
        SMOOTHDURATION;

    }

    protected class TileFromTextureToken
    implements Token {
        protected final Map<String, TileTextureTokens> tilefromtexturetokens = new HashMap<String, TileTextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("file", TileTextureTokens.FILE);
                this.put("name", TileTextureTokens.FILE);
                this.put("alphacut", TileTextureTokens.ALPHACUT);
                this.put("xoffset", TileTextureTokens.XOFFSET);
                this.put("xoff", TileTextureTokens.XOFFSET);
                this.put("yoffset", TileTextureTokens.YOFFSET);
                this.put("yoff", TileTextureTokens.YOFFSET);
                this.put("texture", TileTextureTokens.TEXTURE);
                this.put("ifcrc", TileTextureTokens.CRC);
            }
        };

        protected TileFromTextureToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            DefScript def = DefScript.this;
            int ttexturetokptr = script.ltextptr;
            String fn = null;
            int talphacut = 255;
            Byte xoffset = null;
            Byte yoffset = null;
            long tilecrc = 0L;
            boolean istexture = false;
            Integer tile = script.getsymbol();
            if (tile == null) {
                return BaseToken.Error;
            }
            int ttextureend = script.getbraces();
            if (ttextureend == -1) {
                return BaseToken.Error;
            }
            block12: while (script.textptr < ttextureend) {
                Object tk = def.gettoken(script, this.tilefromtexturetokens);
                if (tk instanceof BaseToken) {
                    int line = script.getlinum(script.ltextptr);
                    Console.out.println(script.filename + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), OsdColor.RED);
                    continue;
                }
                switch (((TileTextureTokens)((Object)tk)).ordinal()) {
                    default: {
                        continue block12;
                    }
                    case 0: {
                        fn = def.getFile(script);
                        continue block12;
                    }
                    case 1: {
                        Integer value = script.getsymbol();
                        if (value != null) {
                            talphacut = value;
                        }
                        talphacut = Gameutils.BClipRange(talphacut, 0, 255);
                        continue block12;
                    }
                    case 2: {
                        String xoffs = script.getstring();
                        if (xoffs.equalsIgnoreCase("ART")) {
                            xoffset = DefScript.this.engine.getTile(tile).getOffsetX();
                            continue block12;
                        }
                        try {
                            xoffset = Byte.parseByte(xoffs);
                        }
                        catch (Exception e) {
                            Console.out.println("Xoffset value out of range. Value: \"" + xoffs + "\" was disabled.", OsdColor.RED);
                        }
                        continue block12;
                    }
                    case 3: {
                        String yoffs = script.getstring();
                        if (yoffs.equalsIgnoreCase("ART")) {
                            yoffset = DefScript.this.engine.getTile(tile).getOffsetY();
                            continue block12;
                        }
                        try {
                            yoffset = Byte.parseByte(yoffs);
                        }
                        catch (Exception e) {
                            Console.out.println("Yoffset value out of range. Value: \"" + yoffs + "\" was disabled.", OsdColor.RED);
                        }
                        continue block12;
                    }
                    case 4: {
                        istexture = true;
                        continue block12;
                    }
                    case 5: 
                }
                tilecrc = (long)script.getsymbol().intValue() & 0xFFFFFFFFL;
            }
            script.skipbrace(ttextureend);
            if (this.addTile(script, fn, tile, xoffset, yoffset, tilecrc, talphacut, istexture, ttexturetokptr) != null) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        protected DefTile addTile(Scriptfile script, String fn, Integer tile, Byte xoffset, Byte yoffset, long tilecrc, int talphacut, boolean istexture, int ttexturetokptr) {
            DefScript def = DefScript.this;
            if (tile < 0 || tile >= Engine.MAXTILES) {
                Console.out.println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), OsdColor.RED);
                return null;
            }
            if (fn == null) {
                String ext = FileUtils.getExtension(script.filename);
                DefTile deftile = new DefTile(DefScript.this.engine.getTile(tile).getWidth(), DefScript.this.engine.getTile(tile).getHeight(), tilecrc, ext != null && ext.equals("dat"));
                if (xoffset != null) {
                    deftile.xoffset = xoffset;
                }
                if (yoffset != null) {
                    deftile.yoffset = yoffset;
                }
                if (xoffset == null && yoffset == null) {
                    Console.out.println("Error: missing 'file name' for tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), OsdColor.RED);
                }
                if (def.addDefTile(deftile, tile)) {
                    return deftile;
                }
                return null;
            }
            String ext = FileUtils.getExtension(script.filename);
            DefTile texstatus = this.ImportTileFromTexture(Cache.getInstance().getEntry(fn, true), tile, tilecrc, talphacut, istexture, ext != null && ext.equals("dat"));
            if (texstatus == null) {
                return null;
            }
            if (xoffset != null) {
                texstatus.xoffset = xoffset;
            }
            if (yoffset != null) {
                texstatus.yoffset = yoffset;
            }
            if (!def.addDefTile(texstatus, tile)) {
                Console.out.println("Error: \"" + fn + "\" has more than one tile, in tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), OsdColor.RED);
                return null;
            }
            return texstatus;
        }

        protected DefTile ImportTileFromTexture(Entry fn, int tile, long crc32, int alphacut, boolean istexture, boolean internal) {
            Pixmap pix;
            DefScript def = DefScript.this;
            byte[] data = fn.getBytes();
            if (data.length == 0) {
                Console.out.println("ImportTileFromTexture error: file " + fn + " not found!", OsdColor.RED);
                return null;
            }
            try {
                pix = new Pixmap(data, 0, data.length);
            }
            catch (Throwable e) {
                Console.out.println("ImportTileFromTexture error: " + e.getMessage(), OsdColor.RED);
                return null;
            }
            pix.setFilter(Pixmap.Filter.NearestNeighbour);
            Pixmap.Format fmt = pix.getFormat();
            int xsiz = pix.getWidth();
            int ysiz = pix.getHeight();
            DefTile deftile = new DefTile(xsiz, ysiz, crc32, internal);
            deftile.waloff = new byte[xsiz * ysiz];
            ByteBuffer bb = pix.getPixels();
            byte[] waloff = deftile.waloff;
            PaletteManager paletteManager = DefScript.this.engine.getPaletteManager();
            byte[] basePalette = paletteManager.getBasePalette();
            FastColorLookup fastColorLookup = paletteManager.getFastColorLookup();
            for (int y = 0; y < ysiz; ++y) {
                for (int x = 0; x < xsiz; ++x) {
                    int r = (bb.get() & 0xFF) >> 2;
                    int g = (bb.get() & 0xFF) >> 2;
                    int b = (bb.get() & 0xFF) >> 2;
                    if (fmt == Pixmap.Format.RGBA4444 || fmt == Pixmap.Format.RGBA8888) {
                        if (bb.get() == 0) {
                            waloff[x * ysiz + y] = -1;
                            continue;
                        }
                        waloff[x * ysiz + y] = fastColorLookup.getClosestColorIndex(basePalette, r, g, b);
                        continue;
                    }
                    waloff[x * ysiz + y] = fastColorLookup.getClosestColorIndex(basePalette, r, g, b);
                }
            }
            if (istexture) {
                deftile.hrp = fn;
                deftile.alphacut = (byte)alphacut;
            }
            return deftile;
        }
    }

    public static enum TileTextureTokens {
        FILE,
        ALPHACUT,
        XOFFSET,
        YOFFSET,
        TEXTURE,
        CRC;

    }

    protected class AnimRangeToken
    implements Token {
        protected AnimRangeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer tile0 = script.getsymbol();
            if (tile0 == null) {
                return BaseToken.Error;
            }
            Integer tile1 = script.getsymbol();
            if (tile1 == null) {
                return BaseToken.Error;
            }
            Integer speed = script.getsymbol();
            if (speed == null) {
                return BaseToken.Error;
            }
            Integer anm = script.getsymbol();
            if (anm == null) {
                return BaseToken.Error;
            }
            int length = tile1 - tile0;
            if (length <= 0) {
                Console.out.println("Warning: Animation lenght < 0, skipping", OsdColor.RED);
                return BaseToken.Warning;
            }
            ArtEntry pic = DefScript.this.engine.getTile(tile0);
            pic.disableAnimation();
            pic.setAnimFrames(length);
            pic.setAnimType(AnimType.findAnimType((anm & 3) << 6));
            pic.setAnimSpeed(speed);
            return BaseToken.Ok;
        }
    }

    protected static class EchoToken
    implements Token {
        protected EchoToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String message = script.getstring();
            if (message != null) {
                Console.out.println(message, OsdColor.BROWN);
            } else {
                Console.out.println("");
            }
            return BaseToken.Ok;
        }
    }

    protected class AddonToken
    implements Token {
        protected AddonToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn;
            String addon;
            DefScript def = DefScript.this;
            if (def.addonsIncludes == null) {
                def.addonsIncludes = new HashMap();
            }
            if ((addon = script.getstring()) != null && (fn = def.getFile(script)) != null) {
                if (def.addonsIncludes.get(addon) == null) {
                    ArrayList list = new ArrayList();
                    def.addonsIncludes.put(addon, list);
                }
                def.addonsIncludes.get(addon).add(script.path);
                def.addonsIncludes.get(addon).add(fn);
            }
            return BaseToken.Ok;
        }
    }

    protected class IncludeToken
    implements Token {
        protected IncludeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Warning;
            }
            this.include(DefScript.this, fn, script, script.ltextptr);
            return BaseToken.Ok;
        }

        private void include(DefScript def, String fn, Scriptfile script, int cmdtokptr) {
            Entry entry = Cache.getInstance().getEntry(fn, true);
            if (!entry.exists()) {
                if (cmdtokptr == 0) {
                    Console.out.println("Warning: Failed including " + fn + " as module", OsdColor.YELLOW);
                } else {
                    Console.out.println("Warning: Failed including " + fn + " on line " + script.filename + ":" + script.getlinum(cmdtokptr), OsdColor.YELLOW);
                }
                return;
            }
            Scriptfile included = new Scriptfile(fn, entry);
            included.path = script.path;
            def.defsparser(included);
        }
    }

    protected class MaphackToken
    implements Token {
        private final Map<String, MapHackTokens> maptokens = new HashMap<String, MapHackTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("mapfile", MapHackTokens.FILE);
                this.put("mhkfile", MapHackTokens.MHK);
                this.put("mapmd4", MapHackTokens.MD4);
                this.put("maptitle", MapHackTokens.TITLE);
            }
        };

        protected MaphackToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int end = script.getbraces();
            if (end == -1) {
                return BaseToken.Error;
            }
            String file = null;
            String mhk = null;
            String md4 = null;
            block6: while (script.textptr < end) {
                Object tk = DefScript.this.gettoken(script, this.maptokens);
                if (DefScript.this.checkErrorToken(script, tk)) continue;
                switch (((MapHackTokens)((Object)tk)).ordinal()) {
                    default: {
                        continue block6;
                    }
                    case 3: {
                        script.getstring();
                        continue block6;
                    }
                    case 0: {
                        file = DefScript.this.getFile(script);
                        continue block6;
                    }
                    case 1: {
                        mhk = DefScript.this.getFile(script);
                        continue block6;
                    }
                    case 2: 
                }
                md4 = script.getstring();
            }
            Entry mapEntry = Cache.getInstance().getEntry(file, true);
            Entry mhkEntry = Cache.getInstance().getEntry(mhk, true);
            if (mapEntry.exists() && mhkEntry.exists() && DefScript.this.mapInfo.addMapInfo(mapEntry, mhkEntry, md4)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }
    }

    public static enum MapHackTokens {
        FILE,
        MHK,
        MD4,
        TITLE;

    }
}

