/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import com.badlogic.gdx.utils.Array;
import org.jetbrains.annotations.Nullable;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.ModelHandle.MDInfo;
import ru.m210projects.Build.Render.ModelHandle.ModelInfo;
import ru.m210projects.Build.Render.ModelHandle.VoxelInfo;
import ru.m210projects.Build.Render.Types.Hudtyp;
import ru.m210projects.Build.Render.Types.Tile2model;
import ru.m210projects.Build.Types.collections.DynamicArray;

public class ModelsInfo {
    private final DynamicArray<Tile2model> cache = new DynamicArray<Tile2model>(Engine.MAXTILES, Tile2model.class, false);
    private final Hudtyp[][] hudInfo = new Hudtyp[2][Engine.MAXTILES];
    private final Array<Spritesmooth> spritesmooth = new DynamicArray<Spritesmooth>(4096, Spritesmooth.class);
    private final Array<SpriteAnim> spriteanim = new DynamicArray<SpriteAnim>(4096, SpriteAnim.class);

    public ModelsInfo() {
    }

    public ModelsInfo(ModelsInfo src, boolean disposable) {
        int i;
        for (i = 0; i < src.cache.size; ++i) {
            Tile2model t2m = src.cache.get(i);
            if (t2m == null) continue;
            this.cache.set(i, t2m.clone(disposable));
        }
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < Engine.MAXTILES; ++j) {
                if (src.hudInfo[i] == null || src.hudInfo[i][j] == null) continue;
                this.hudInfo[i][j] = src.hudInfo[i][j].clone();
            }
        }
    }

    public Spritesmooth getSmoothParams(int i) {
        return this.spritesmooth.get(i);
    }

    public SpriteAnim getAnimParams(int i) {
        return this.spriteanim.get(i);
    }

    public ModelInfo getModelInfo(int picnum) {
        Tile2model t2m = this.cache.get(picnum);
        if (t2m != null) {
            return t2m.model;
        }
        return null;
    }

    public VoxelInfo getVoxelInfo(int picnum) {
        Tile2model t2m = this.cache.get(picnum);
        if (t2m != null) {
            return t2m.voxel;
        }
        return null;
    }

    public int getTile(ModelInfo model) {
        for (int i = this.cache.size - 1; i >= 0; --i) {
            Tile2model t2m = this.cache.get(i);
            if (t2m == null || t2m.model != model) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public Tile2model getParams(int picnum) {
        return this.cache.get(picnum);
    }

    public Hudtyp getHudInfo(int picnum, int flags) {
        if (this.hudInfo[flags >> 2 & 1] != null) {
            return this.hudInfo[flags >> 2 & 1][picnum];
        }
        return null;
    }

    protected Tile2model getCache(int picnum, int pal) {
        Tile2model t2m = this.cache.get(picnum);
        if (t2m == null) {
            t2m = this.cache.getInstance(picnum);
            t2m.palette = pal;
            return t2m;
        }
        if (t2m.palette == pal) {
            return t2m;
        }
        Tile2model n = t2m;
        while (n.next != null) {
            n = n.next;
            if (n.palette != pal) continue;
            return n;
        }
        Tile2model current = new Tile2model();
        current.palette = pal;
        n.next = current;
        return current;
    }

    public int addModelInfo(ModelInfo md, int picnum, String framename, int skinnum, float smooth, int pal) {
        if (md == null) {
            return -1;
        }
        int i = -3;
        switch (md.getType()) {
            case Voxel: {
                i = 0;
                skinnum = 0;
                smooth = 0;
                break;
            }
            case Md2: 
            case Md3: {
                if (framename == null) {
                    return -3;
                }
                i = ((MDInfo)md).getFrameIndex(framename);
            }
        }
        Tile2model current = this.getCache(picnum, pal);
        current.model = md;
        current.framenum = i;
        current.skinnum = skinnum;
        current.smoothduration = smooth;
        return i;
    }

    public int addVoxelInfo(VoxelInfo md, int picnum) {
        if (md == null) {
            return -1;
        }
        Tile2model t2m = this.cache.getInstance(picnum);
        t2m.voxel = md;
        return 0;
    }

    public void removeModelInfo(ModelInfo md) {
        for (int i = this.cache.size - 1; i >= 0; --i) {
            Tile2model t2m = this.cache.get(i);
            if (t2m == null || t2m.model != md) continue;
            t2m.model = null;
        }
    }

    public int addHudInfo(int tilex, double xadd, double yadd, double zadd, short angadd, int flags, int fov) {
        if (tilex >= Engine.MAXTILES) {
            return -2;
        }
        if (this.hudInfo[flags >> 2 & 1] == null || this.hudInfo[flags >> 2 & 1][tilex] == null) {
            this.hudInfo[flags >> 2 & 1][tilex] = new Hudtyp();
        }
        Hudtyp hud = this.hudInfo[flags >> 2 & 1][tilex];
        hud.xadd = (float)xadd;
        hud.yadd = (float)yadd;
        hud.zadd = (float)zadd;
        hud.angadd = (short)(angadd | 0x800);
        hud.flags = (short)flags;
        hud.fov = (short)fov;
        return 0;
    }

    public void dispose() {
        for (int i = this.cache.size - 1; i >= 0; --i) {
            Tile2model t2m = this.cache.get(i);
            if (t2m == null || !t2m.disposable) continue;
            this.cache.set(i, null);
        }
    }

    public static class Spritesmooth {
        public float smoothduration;
        public short mdcurframe;
        public short mdoldframe;
        public short mdsmooth;
    }

    public static class SpriteAnim {
        public long mdanimtims;
        public short mdanimcur;
    }
}

