/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import java.io.File;
import java.util.Arrays;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.filehandle.Entry;

public class Scriptfile {
    public String textbuf;
    public int errorptr;
    public int ltextptr;
    public int textptr;
    public String path;
    public String filename;
    public int eof;
    public int linenum;
    public int[] lineoffs;

    protected void skipovertoken() {
        while (this.textptr < this.eof && this.textptr < this.textbuf.length() && this.textbuf.charAt(this.textptr) != '\u0000') {
            ++this.textptr;
        }
    }

    protected void skipoverws() {
        if (this.textptr < this.eof && this.textptr < this.textbuf.length() && this.textbuf.charAt(this.textptr) == '\u0000') {
            ++this.textptr;
        }
    }

    public String getstring() {
        int out = this.gettoken();
        if (out == -1 || out == -2) {
            return null;
        }
        String txt = this.textbuf.substring(out, this.textptr);
        txt = txt.replaceAll("\"", "");
        txt = txt.replace("/", File.separator);
        return Strhandler.toLowerCase(txt);
    }

    public int gettoken() {
        this.skipoverws();
        if (this.textptr >= this.eof) {
            return -2;
        }
        int start = this.ltextptr = this.textptr;
        this.skipovertoken();
        return start;
    }

    public Double getdouble() {
        int t = this.gettoken();
        if (t == -2) {
            return null;
        }
        try {
            return Double.parseDouble(this.textbuf.substring(t, this.textptr));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getsymbol() {
        int t = this.gettoken();
        if (t == -2) {
            return null;
        }
        try {
            return (int)Long.parseLong(this.textbuf.substring(t, this.textptr), 10);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getbraces() {
        boolean inquote = false;
        this.skipoverws();
        if (this.textptr >= this.eof) {
            return -1;
        }
        if (this.textbuf.charAt(this.textptr) != '{') {
            return -1;
        }
        int bracestart = ++this.textptr;
        int bracecnt = 1;
        while (true) {
            if (this.textptr >= this.eof) {
                return 0;
            }
            if (this.textbuf.charAt(this.textptr) == '\"') {
                inquote ^= true;
            }
            if (!inquote && this.textbuf.charAt(this.textptr) == '{') {
                ++bracecnt;
            }
            if (!inquote && this.textbuf.charAt(this.textptr) == '}' && --bracecnt == 0) break;
            ++this.textptr;
        }
        int braceend = this.textptr - 1;
        this.textptr = bracestart;
        return braceend;
    }

    public void skipbrace(int braceend) {
        this.textptr = braceend + 1;
        this.gettoken();
    }

    public boolean eof() {
        this.skipoverws();
        return this.textptr >= this.eof;
    }

    public int getlinum(int ptr) {
        int stp = 1;
        while (stp + stp < this.linenum) {
            stp += stp;
        }
        int i = 0;
        while (stp != 0) {
            if (i + stp < this.linenum && this.lineoffs[i + stp] < ptr) {
                i += stp;
            }
            stp >>= 1;
        }
        return i + 2;
    }

    protected void preparse(byte[] data, int flen) {
        int numcr = 1;
        for (int i = 0; i < flen; ++i) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (!cr) continue;
            ++numcr;
        }
        this.linenum = numcr;
        this.lineoffs = new int[numcr];
        int nflen = 0;
        boolean space = false;
        int cs = 0;
        boolean inquote = false;
        numcr = 0;
        for (int i = 0; i < flen; ++i) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                this.lineoffs[numcr++] = nflen;
                if (cs == 1) {
                    cs = 0;
                }
                space = true;
                continue;
            }
            if (!(inquote || data[i] != 32 && data[i] != 9)) {
                space = true;
                continue;
            }
            if (data[i] == 47 && data[i + 1] == 47 && cs == 0) {
                cs = 1;
            }
            if (data[i] == 92 && data[i + 1] == 92 && cs == 0) {
                cs = 1;
            }
            if (data[i] == 47 && data[i + 1] == 42 && cs == 0) {
                space = true;
                cs = 2;
            }
            if (data[i] == 42 && data[i + 1] == 47 && cs == 2) {
                cs = 0;
                ++i;
                continue;
            }
            if (cs != 0) continue;
            if (space) {
                data[nflen++] = 0;
                space = false;
            }
            if (data[i] == 92 && data[i + 1] == 34) {
                ++i;
                data[nflen++] = 34;
                continue;
            }
            if (data[i] == 34) {
                inquote ^= true;
            }
            data[nflen++] = data[i];
        }
        data[nflen++] = 0;
        this.lineoffs[numcr] = nflen;
        data[nflen++] = 0;
        flen = nflen;
        this.textbuf = new String(data, 0, flen);
        this.textptr = 0;
        this.eof = this.textbuf.length() - 1;
    }

    public Scriptfile(String filename, Entry entry) {
        byte[] data = entry.getBytes();
        int flen = data.length;
        byte[] tx = Arrays.copyOf(data, flen + 2);
        tx[flen + 1] = 0;
        tx[flen] = 0;
        this.preparse(tx, flen);
        this.filename = filename;
    }
}

