/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Tables {
    protected final short[] sintable;
    protected final short[] radarang;
    protected final short[] sqrtable = new short[4096];
    protected final short[] shlookup = new short[4352];
    protected final byte[] textfont;
    protected final byte[] smalltextfont;

    public Tables(Entry entry) throws IOException {
        this.sintable = new short[2048];
        this.radarang = new short[1280];
        this.textfont = new byte[2048];
        this.smalltextfont = new byte[2048];
        int j = 1;
        int k = 0;
        for (int i = 0; i < 4096; ++i) {
            if (i >= j) {
                j <<= 2;
                ++k;
            }
            this.sqrtable[i] = (short)((int)Math.sqrt((i << 18) + 131072) << 1);
            this.shlookup[i] = (short)((k << 1) + (10 - k << 8));
            if (i >= 256) continue;
            this.shlookup[i + 4096] = (short)((k + 6 << 1) + (10 - (k + 6) << 8));
        }
        this.read(entry);
    }

    protected void read(Entry entry) throws IOException {
        if (!entry.exists()) {
            throw new FileNotFoundException("Failed to load \"tables.dat\"!");
        }
        try (InputStream is = entry.getInputStream();){
            ByteBuffer.wrap(StreamUtils.readBytes(is, this.sintable.length * 2)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.sintable);
            ByteBuffer.wrap(StreamUtils.readBytes(is, this.radarang.length)).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.radarang, 0, this.radarang.length / 2);
            StreamUtils.readBytes(is, this.textfont, 1024);
            StreamUtils.readBytes(is, this.smalltextfont, 1024);
        }
        for (int i = 0; i < 640; ++i) {
            this.radarang[1279 - i] = -this.radarang[i];
        }
    }

    public int sin(int angle) {
        return this.sintable[angle & 0x7FF];
    }

    public int cos(int angle) {
        return this.sin(angle + 512);
    }

    public int sqrt(int a) {
        long out = (long)a & 0xFFFFFFFFL;
        int value = (out & 0xFF000000L) != 0L ? this.shlookup[(int)((out >> 24) + 4096L)] & 0xFFFF : this.shlookup[(int)(out >> 12)] & 0xFFFF;
        out >>= value & 0xFF;
        out = out & 0xFFFF0000L | (long)(this.sqrtable[(int)out] & 0xFFFF);
        return (int)(out >>= (value & 0xFF00) >> 8);
    }

    public int getAngle(int xvect, int yvect) {
        if ((xvect | yvect) == 0) {
            return 0;
        }
        if (xvect == 0) {
            return (short)(512 + ((yvect < 0 ? 1 : 0) << 10));
        }
        if (yvect == 0) {
            return (short)((xvect < 0 ? 1 : 0) << 10);
        }
        if (xvect == yvect) {
            return (short)(256 + ((xvect < 0 ? 1 : 0) << 10));
        }
        if (xvect == -yvect) {
            return (short)(768 + ((xvect > 0 ? 1 : 0) << 10));
        }
        if (Math.abs((long)xvect) > Math.abs((long)yvect)) {
            return (this.radarang[640 + Pragmas.scale(160L, yvect, xvect)] >> 6) + ((xvect < 0 ? 1 : 0) << 10) & 0x7FF;
        }
        return (this.radarang[640 - Pragmas.scale(160L, xvect, yvect)] >> 6) + 512 + ((yvect < 0 ? 1 : 0) << 10) & 0x7FF;
    }

    public int getRadarAng(int value) {
        if (value < 0 || value >= this.radarang.length) {
            return 0;
        }
        return this.radarang[value];
    }
}

