/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.osd.Console;

public class Timer {
    protected final int timerticspersec;
    protected int totalclock;
    protected int frameTicks;
    protected final float timerskipticks;
    protected float frametime;
    protected float gameTime = 0.0f;
    protected int skipTicks = 0;

    public Timer(int tickspersecond, int frameTicks) {
        Console.out.println("Initializing timer");
        this.totalclock = 0;
        this.frameTicks = frameTicks;
        this.timerticspersec = tickspersecond;
        this.timerskipticks = 1000.0f / (float)this.timerticspersec * (float)frameTicks;
        this.frametime = 0.0f;
    }

    public void setSkipTicks(int skipTicks) {
        this.skipTicks = skipTicks;
    }

    public boolean update(float delta, boolean vsync) {
        this.gameTime += (delta *= 1000.0f);
        if (delta > this.timerskipticks) {
            this.totalclock += this.frameTicks * (int)(this.gameTime / this.timerskipticks);
            this.gameTime %= this.timerskipticks;
            this.frametime = 0.0f;
            return true;
        }
        float f = vsync ? this.timerskipticks - (float)this.frameTicks : this.timerskipticks;
        if (this.gameTime >= f) {
            this.totalclock += this.frameTicks;
            this.gameTime = 0.0f;
            this.frametime = 0.0f;
            return true;
        }
        if (this.skipTicks != 0) {
            this.totalclock += this.skipTicks * this.frameTicks;
            return true;
        }
        return false;
    }

    public int getsmoothratio(float deltaTime) {
        float value = this.frametime += deltaTime * 1000.0f / this.timerskipticks * 65536.0f;
        return (int)value;
    }

    public int getFrameTicks() {
        return this.frameTicks;
    }

    @Deprecated
    public int getTicsPerSecond() {
        return this.timerticspersec;
    }

    public void reset() {
        this.frametime = 0.0f;
        this.gameTime = 0.0f;
        this.totalclock = 0;
        this.skipTicks = 0;
    }

    public void calcLag(int lag) {
        this.totalclock -= lag;
    }

    public int getTotalClock() {
        return this.totalclock;
    }

    public void setTotalClock(int totalclock) {
        this.totalclock = totalclock;
    }
}

