/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.FastColorLookup;

public class DefaultFastColorLookup
implements FastColorLookup {
    private final int FASTPALGRIDSIZ = 8;
    private final byte[] coldist = new byte[]{0, 1, 2, 3, 4, 3, 2, 1};
    private int[] rdist;
    private int[] gdist;
    private int[] bdist;
    private byte[] colhere;
    private byte[] colhead;
    private short[] colnext;
    private int[] colscan;
    protected Byte[] palcache = new Byte[262144];

    public DefaultFastColorLookup(byte[] basePalette, int rscale, int gscale, int bscale) {
        int i;
        this.rdist = new int[129];
        this.gdist = new int[129];
        this.bdist = new int[129];
        this.colhere = new byte[125];
        this.colhead = new byte[1000];
        this.colnext = new short[256];
        this.colscan = new int[27];
        int j = 0;
        for (i = 64; i >= 0; --i) {
            int n = j * rscale;
            this.rdist[128 - i] = n;
            this.rdist[i] = n;
            int n2 = j * gscale;
            this.gdist[128 - i] = n2;
            this.gdist[i] = n2;
            int n3 = j * bscale;
            this.bdist[128 - i] = n3;
            this.bdist[i] = n3;
            j += 129 - (i << 1);
        }
        Arrays.fill(this.colhere, (byte)0);
        Arrays.fill(this.colhead, (byte)0);
        for (i = 255; i >= 0; --i) {
            int r = basePalette[3 * i] & 0xFF;
            int g = basePalette[3 * i + 1] & 0xFF;
            int b = basePalette[3 * i + 2] & 0xFF;
            j = (r >> 3) * 8 * 8 + (g >> 3) * 8 + (b >> 3) + 64 + 8 + 1;
            this.colnext[i] = (this.colhere[j >> 3] & EngineUtils.powToLong(j & 7)) != 0 ? (int)(this.colhead[j] & 0xFF) : -1;
            this.colhead[j] = (byte)i;
            int n = j >> 3;
            this.colhere[n] = (byte)(this.colhere[n] | (byte)EngineUtils.powToLong(j & 7));
        }
        i = 0;
        for (int x = -64; x <= 64; x += 64) {
            for (int y = -8; y <= 8; y += 8) {
                for (int z = -1; z <= 1; ++z) {
                    this.colscan[i++] = x + y + z;
                }
            }
        }
        i = this.colscan[13];
        this.colscan[13] = this.colscan[26];
        this.colscan[26] = i;
    }

    @Override
    public void invalidate() {
        Arrays.fill((Object[])this.palcache, null);
    }

    @Override
    public byte getClosestColorIndex(byte[] palette, int r, int g, int b) {
        int pal1;
        int dist;
        int i;
        int j = (r >> 3) * 8 * 8 + (g >> 3) * 8 + (b >> 3) + 64 + 8 + 1;
        int rgb = r << 12 | g << 6 | b;
        int mindist = Math.min(this.rdist[(this.coldist[r & 7] & 0xFF) + 64 + 8], this.gdist[(this.coldist[g & 7] & 0xFF) + 64 + 8]);
        mindist = Math.min(mindist, this.bdist[(this.coldist[b & 7] & 0xFF) + 64 + 8]);
        ++mindist;
        Byte out = this.palcache[rgb & this.palcache.length - 1];
        if (out != null) {
            return out;
        }
        r = 64 - r;
        g = 64 - g;
        b = 64 - b;
        byte retcol = -1;
        for (int k = 26; k >= 0; --k) {
            i = this.colscan[k] + j;
            if ((this.colhere[i >> 3] & Engine.pow2char[i & 7]) == 0) continue;
            i = this.colhead[i] & 0xFF;
            do {
                if ((dist = this.gdist[(palette[(pal1 = i * 3) + 1] & 0xFF) + g]) >= mindist || (dist += this.rdist[(palette[pal1] & 0xFF) + r]) >= mindist || (dist += this.bdist[(palette[pal1 + 2] & 0xFF) + b]) >= mindist) continue;
                mindist = dist;
                retcol = (byte)i;
            } while ((i = this.colnext[i]) >= 0);
        }
        if (retcol >= 0) {
            this.palcache[rgb & this.palcache.length - 1] = retcol;
            return retcol;
        }
        mindist = Integer.MAX_VALUE;
        for (i = 255; i >= 0; --i) {
            pal1 = i * 3;
            dist = this.gdist[(palette[pal1 + 1] & 0xFF) + g];
            if (dist >= mindist || (dist += this.rdist[(palette[pal1] & 0xFF) + r]) >= mindist || (dist += this.bdist[(palette[pal1 + 2] & 0xFF) + b]) >= mindist) continue;
            mindist = dist;
            retcol = (byte)i;
        }
        this.palcache[rgb & this.palcache.length - 1] = retcol;
        return retcol;
    }
}

