/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import com.badlogic.gdx.utils.IntArray;
import java.util.concurrent.atomic.AtomicInteger;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Variable;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.BitMap;
import ru.m210projects.Build.Types.collections.ListNode;

public class EngineService {
    private final AtomicInteger floorZ = new AtomicInteger();
    private final AtomicInteger ceilZ = new AtomicInteger();
    private final Engine engine;
    private final BitMap sectBitMap;
    private final IntArray tmpSectorList = new IntArray();

    public EngineService(Engine engine) {
        this.engine = engine;
        this.sectBitMap = new BitMap();
    }

    public int clipInsideBox(int x, int y, int wallnum, int walldist) {
        BoardService service = this.engine.getBoardService();
        Wall wal = service.getWall(wallnum);
        if (wal == null) {
            return 0;
        }
        Wall wal2 = service.getNextWall(wal);
        return this.clipInsideBoxLine(x, y, wal.getX(), wal.getY(), wal2.getX(), wal2.getY(), walldist);
    }

    public int clipInsideBoxLine(int x, int y, int x1, int y1, int x2, int y2, int walldist) {
        int r = walldist << 1;
        if ((x1 += walldist - x) < 0 && (x2 += walldist - x) < 0 || x1 >= r && x2 >= r) {
            return 0;
        }
        if ((y1 += walldist - y) < 0 && (y2 += walldist - y) < 0 || y1 >= r && y2 >= r) {
            return 0;
        }
        if ((x2 -= x1) * (walldist - y1) >= (y2 -= y1) * (walldist - x1)) {
            return (x2 *= x2 > 0 ? -y1 : r - y1) < (y2 *= y2 > 0 ? r - x1 : -x1) ? 1 : 0;
        }
        return ((x2 *= x2 > 0 ? r - y1 : -y1) >= (y2 *= y2 > 0 ? -x1 : r - x1) ? 1 : 0) << 1;
    }

    public boolean canSee(int x1, int y1, int z1, int sect1, int x2, int y2, int z2, int sect2) {
        this.sectBitMap.clear();
        this.tmpSectorList.clear();
        if (x1 == x2 && y1 == y2) {
            return sect1 == sect2;
        }
        BoardService service = this.engine.getBoardService();
        int x21 = x2 - x1;
        int y21 = y2 - y1;
        int z21 = z2 - z1;
        this.sectBitMap.setBit(sect1);
        this.tmpSectorList.add(sect1);
        for (int dacnt = 0; dacnt < this.tmpSectorList.size; ++dacnt) {
            Sector sec = service.getSector(this.tmpSectorList.get(dacnt));
            if (sec == null) continue;
            for (ListNode<Wall> wn = sec.getWallNode(); wn != null; wn = wn.getNext()) {
                int t;
                Wall wal = wn.get();
                Wall wal2 = service.getNextWall(wal);
                if (wal2 == null) continue;
                int x31 = wal.getX() - x1;
                int x34 = wal.getX() - wal2.getX();
                int y31 = wal.getY() - y1;
                int y34 = wal.getY() - wal2.getY();
                int bot = y21 * x34 - x21 * y34;
                if (bot <= 0 || ((long)(t = y21 * x31 - x21 * y31) & 0xFFFFFFFFL) >= ((long)bot & 0xFFFFFFFFL) || ((long)(t = y31 * x34 - x31 * y34) & 0xFFFFFFFFL) >= ((long)bot & 0xFFFFFFFFL)) continue;
                if (wal.isOneWay()) {
                    return false;
                }
                short nexts = wal.getNextsector();
                Sector nextSector = service.getSector(nexts);
                if (nextSector == null) {
                    return false;
                }
                t = Pragmas.divscale(t, bot, 24);
                int x = x1 + Pragmas.mulscale(x21, t, 24);
                int y = y1 + Pragmas.mulscale(y21, t, 24);
                int z = z1 + Pragmas.mulscale(z21, t, 24);
                this.engine.getBoardService().getzsofslope(sec, x, y, this.floorZ, this.ceilZ);
                if (z <= this.ceilZ.get() || z >= this.floorZ.get()) {
                    return false;
                }
                this.engine.getBoardService().getzsofslope(nextSector, x, y, this.floorZ, this.ceilZ);
                if (z <= this.ceilZ.get() || z >= this.floorZ.get()) {
                    return false;
                }
                if (this.sectBitMap.getBit(nexts)) continue;
                this.sectBitMap.setBit(nexts);
                this.tmpSectorList.add(nexts);
            }
        }
        return this.sectBitMap.getBit(sect2);
    }

    public boolean rIntersect(int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int x4, int y4, Variable x, Variable y, Variable z) {
        int topu;
        int y34 = y3 - y4;
        int x34 = x3 - x4;
        int bot = x2 * y34 - y2 * x34;
        if (bot == 0) {
            return false;
        }
        int x31 = x3 - x1;
        int y31 = y3 - y1;
        int topt = x31 * y34 - y31 * x34;
        if (bot > 0) {
            if (topt < 0) {
                return false;
            }
            topu = x2 * y31 - y2 * x31;
            if (topu < 0 || topu >= bot) {
                return false;
            }
        } else {
            if (topt > 0) {
                return false;
            }
            topu = x2 * y31 - y2 * x31;
            if (topu > 0 || topu <= bot) {
                return false;
            }
        }
        int t = Pragmas.divscale(topt, bot, 16);
        x.set(x1 + Pragmas.mulscale(x2, t, 16));
        y.set(y1 + Pragmas.mulscale(y2, t, 16));
        z.set(z1 + Pragmas.mulscale(z2, t, 16));
        return true;
    }

    public boolean lIntersect(int x1, int y1, int z1, int x2, int y2, int z2, int x3, int y3, int x4, int y4, Variable x, Variable y, Variable z) {
        int topu;
        int x21 = x2 - x1;
        int y34 = y3 - y4;
        int y21 = y2 - y1;
        int x34 = x3 - x4;
        int bot = x21 * y34 - y21 * x34;
        if (bot == 0) {
            return false;
        }
        int x31 = x3 - x1;
        int y31 = y3 - y1;
        int topt = x31 * y34 - y31 * x34;
        if (bot > 0) {
            if (topt < 0 || topt >= bot) {
                return false;
            }
            topu = x21 * y31 - y21 * x31;
            if (topu < 0 || topu >= bot) {
                return false;
            }
        } else {
            if (topt > 0 || topt <= bot) {
                return false;
            }
            topu = x21 * y31 - y21 * x31;
            if (topu > 0 || topu <= bot) {
                return false;
            }
        }
        int t = Pragmas.divscale(topt, bot, 24);
        x.set(x1 + Pragmas.mulscale(x21, t, 24));
        y.set(y1 + Pragmas.mulscale(y21, t, 24));
        z.set(z1 + Pragmas.mulscale(z2 - z1, t, 24));
        return true;
    }
}

