/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import ru.m210projects.Build.CRC32;

public class Palette {
    private long crc32 = -1L;
    private final byte[] bytes = new byte[768];

    public boolean update(byte[] palette) {
        long crc32 = CRC32.getChecksum(palette);
        if (crc32 == this.crc32) {
            return false;
        }
        System.arraycopy(palette, 0, this.bytes, 0, palette.length);
        this.crc32 = crc32;
        return true;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getRed(int index) {
        return this.bytes[3 * index] & 0xFF;
    }

    public int getGreen(int index) {
        return this.bytes[3 * index + 1] & 0xFF;
    }

    public int getBlue(int index) {
        return this.bytes[3 * index + 2] & 0xFF;
    }

    public int getRGB(int p) {
        return this.getRed(p) | this.getGreen(p) << 8 | this.getBlue(p) << 16;
    }

    public int getRGBA(int index, byte alphaMask) {
        return this.getRGB(index) | alphaMask << 24;
    }

    public int getRGBA(int p) {
        return this.getRGBA(p, (byte)-1);
    }
}

