/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.StreamUtils;

public class Wall {
    private int x;
    private int y;
    private short point2;
    private short nextwall;
    private short nextsector;
    private short cstat;
    private short picnum;
    private short overpicnum;
    private byte shade;
    private short pal;
    private short xrepeat;
    private short yrepeat;
    private short xpanning;
    private short ypanning;
    private short lotag;
    private short hitag;
    private short extra;
    private Wall wall2;

    public Wall() {
    }

    public Wall(byte[] data) throws IOException {
        this.readObject(new ByteArrayInputStream(data));
    }

    public Wall(InputStream is) throws IOException {
        this.readObject(is);
    }

    public Wall readObject(InputStream is) throws IOException {
        this.setX(StreamUtils.readInt(is));
        this.setY(StreamUtils.readInt(is));
        this.setPoint2(StreamUtils.readShort(is));
        this.setNextwall(StreamUtils.readShort(is));
        this.setNextsector(StreamUtils.readShort(is));
        this.setCstat(StreamUtils.readShort(is));
        this.setPicnum(StreamUtils.readShort(is));
        this.setOverpicnum(StreamUtils.readShort(is));
        this.setShade(StreamUtils.readByte(is));
        this.setPal(StreamUtils.readUnsignedByte(is));
        this.setXrepeat(StreamUtils.readUnsignedByte(is));
        this.setYrepeat(StreamUtils.readUnsignedByte(is));
        this.setXpanning(StreamUtils.readUnsignedByte(is));
        this.setYpanning(StreamUtils.readUnsignedByte(is));
        this.setLotag(StreamUtils.readShort(is));
        this.setHitag(StreamUtils.readShort(is));
        this.setExtra(StreamUtils.readShort(is));
        return this;
    }

    public void writeObject(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.getX());
        StreamUtils.writeInt(os, this.getY());
        StreamUtils.writeShort(os, this.getPoint2());
        StreamUtils.writeShort(os, this.getNextwall());
        StreamUtils.writeShort(os, this.getNextsector());
        StreamUtils.writeShort(os, this.getCstat());
        StreamUtils.writeShort(os, this.getPicnum());
        StreamUtils.writeShort(os, this.getOverpicnum());
        os.write(this.getShade());
        os.write(this.getPal());
        os.write(this.getXrepeat());
        os.write(this.getYrepeat());
        os.write(this.getXpanning());
        os.write(this.getYpanning());
        StreamUtils.writeShort(os, this.getLotag());
        StreamUtils.writeShort(os, this.getHitag());
        StreamUtils.writeShort(os, this.getExtra());
    }

    public void set(Wall src) {
        this.setX(src.getX());
        this.setY(src.getY());
        this.setPoint2(src.getPoint2());
        this.setNextwall(src.getNextwall());
        this.setNextsector(src.getNextsector());
        this.setCstat(src.getCstat());
        this.setPicnum(src.getPicnum());
        this.setOverpicnum(src.getOverpicnum());
        this.setShade(src.getShade());
        this.setPal(src.getPal());
        this.setXrepeat(src.getXrepeat());
        this.setYrepeat(src.getYrepeat());
        this.setXpanning(src.getXpanning());
        this.setYpanning(src.getYpanning());
        this.setLotag(src.getLotag());
        this.setHitag(src.getHitag());
        this.setExtra(src.getExtra());
    }

    public boolean isSwapped() {
        return (this.getCstat() & 2) != 0;
    }

    public boolean isBottomAligned() {
        return (this.getCstat() & 4) != 0;
    }

    public boolean isXFlip() {
        return (this.getCstat() & 8) != 0;
    }

    public boolean isYFlip() {
        return (this.getCstat() & 0x100) != 0;
    }

    public boolean isMasked() {
        return (this.getCstat() & 0x10) != 0;
    }

    public boolean isOneWay() {
        return (this.getCstat() & 0x20) != 0;
    }

    public boolean isTransparent() {
        return (this.getCstat() & 0x80) != 0;
    }

    public boolean isTransparent2() {
        return (this.getCstat() & 0x200) != 0;
    }

    public String toString() {
        String out = "x " + this.getX() + " \r\n";
        out = out + "y " + this.getY() + " \r\n";
        out = out + "point2 " + this.getPoint2() + " \r\n";
        out = out + "nextwall " + this.getNextwall() + " \r\n";
        out = out + "nextsector " + this.getNextsector() + " \r\n";
        out = out + "cstat " + this.getCstat() + " \r\n";
        out = out + "picnum " + this.getPicnum() + " \r\n";
        out = out + "overpicnum " + this.getOverpicnum() + " \r\n";
        out = out + "shade " + this.getShade() + " \r\n";
        out = out + "pal " + this.getPal() + " \r\n";
        out = out + "xrepeat " + this.getXrepeat() + " \r\n";
        out = out + "yrepeat " + this.getYrepeat() + " \r\n";
        out = out + "xpanning " + this.getXpanning() + " \r\n";
        out = out + "ypanning " + this.getYpanning() + " \r\n";
        out = out + "lotag " + this.getLotag() + " \r\n";
        out = out + "hitag " + this.getHitag() + " \r\n";
        out = out + "extra " + this.getExtra() + " \r\n";
        return out;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public short getPoint2() {
        return this.point2;
    }

    public void setPoint2(int point2) {
        this.point2 = (short)point2;
    }

    public short getNextwall() {
        return this.nextwall;
    }

    public void setNextwall(int nextwall) {
        this.nextwall = (short)nextwall;
    }

    public short getNextsector() {
        return this.nextsector;
    }

    public void setNextsector(int nextsector) {
        this.nextsector = (short)nextsector;
    }

    public short getCstat() {
        return this.cstat;
    }

    public void setCstat(int cstat) {
        this.cstat = (short)cstat;
    }

    public short getPicnum() {
        return this.picnum;
    }

    public void setPicnum(int picnum) {
        this.picnum = (short)picnum;
    }

    public short getOverpicnum() {
        return this.overpicnum;
    }

    public void setOverpicnum(int overpicnum) {
        this.overpicnum = (short)overpicnum;
    }

    public byte getShade() {
        return this.shade;
    }

    public void setShade(int shade) {
        this.shade = (byte)shade;
    }

    public short getPal() {
        return this.pal;
    }

    public void setPal(int pal) {
        this.pal = (short)(pal & 0xFF);
    }

    public short getXrepeat() {
        return this.xrepeat;
    }

    public void setXrepeat(int xrepeat) {
        this.xrepeat = (short)(xrepeat & 0xFF);
    }

    public short getYrepeat() {
        return this.yrepeat;
    }

    public void setYrepeat(int yrepeat) {
        this.yrepeat = (short)(yrepeat & 0xFF);
    }

    public short getXpanning() {
        return this.xpanning;
    }

    public void setXpanning(int xpanning) {
        this.xpanning = (short)(xpanning & 0xFF);
    }

    public short getYpanning() {
        return this.ypanning;
    }

    public void setYpanning(int ypanning) {
        this.ypanning = (short)(ypanning & 0xFF);
    }

    public short getLotag() {
        return this.lotag;
    }

    public void setLotag(int lotag) {
        this.lotag = (short)lotag;
    }

    public short getHitag() {
        return this.hitag;
    }

    public void setHitag(int hitag) {
        this.hitag = (short)hitag;
    }

    public short getExtra() {
        return this.extra;
    }

    public void setExtra(int extra) {
        this.extra = (short)extra;
    }

    public Wall getWall2() {
        return this.wall2;
    }

    public void setWall2(Wall wall2) {
        this.wall2 = wall2;
    }

    public int getWallAngle() {
        return EngineUtils.getAngle(this.wall2.getX() - this.getX(), this.wall2.getY() - this.getY());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wall wall = (Wall)o;
        return this.x == wall.x && this.y == wall.y && this.point2 == wall.point2 && this.nextwall == wall.nextwall && this.nextsector == wall.nextsector && this.cstat == wall.cstat && this.picnum == wall.picnum && this.overpicnum == wall.overpicnum && this.shade == wall.shade && this.pal == wall.pal && this.xrepeat == wall.xrepeat && this.yrepeat == wall.yrepeat && this.xpanning == wall.xpanning && this.ypanning == wall.ypanning && this.lotag == wall.lotag && this.hitag == wall.hitag && this.extra == wall.extra && Objects.equals(this.wall2, wall.wall2);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.point2, this.nextwall, this.nextsector, this.cstat, this.picnum, this.overpicnum, this.shade, this.pal, this.xrepeat, this.yrepeat, this.xpanning, this.ypanning, this.lotag, this.hitag, this.extra, this.wall2);
    }

    public Node buildNode(int i) {
        return new Node(i);
    }

    public class Node
    extends ListNode<Wall> {
        protected Node(int index) {
            super(index);
        }

        @Override
        public Wall get() {
            return Wall.this;
        }
    }
}

