/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.filehandle.StreamUtils;

public class BitMap {
    private byte[] array;

    public BitMap(int capacity) {
        this.array = new byte[capacity >> 3];
    }

    public BitMap() {
        this.array = new byte[128];
    }

    public void clear() {
        Arrays.fill(this.array, (byte)0);
    }

    public boolean getBit(int index) {
        this.checkIndex(index);
        if (index >= 0) {
            return (this.array[index >> 3] & 1 << (index & 7)) != 0;
        }
        return false;
    }

    public void setBit(int index) {
        this.checkIndex(index);
        if (index >= 0) {
            int n = index >> 3;
            this.array[n] = (byte)(this.array[n] | (byte)Engine.pow2char[index & 7]);
        }
    }

    public void clearBit(int index) {
        this.checkIndex(index);
        if (index >= 0) {
            int n = index >> 3;
            this.array[n] = (byte)(this.array[n] & (byte)(~Engine.pow2char[index & 7]));
        }
    }

    private void checkIndex(int index) {
        int i = index >> 3;
        if (i >= this.array.length) {
            int size;
            for (size = 1; size <= i; size <<= 1) {
            }
            byte[] newArray = new byte[size];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
    }

    public byte[] getArray() {
        return this.array;
    }

    public BitMap readObject(InputStream is) throws IOException {
        this.array = new byte[StreamUtils.readInt(is)];
        StreamUtils.readBytes(is, this.array);
        return this;
    }

    public void writeObject(OutputStream os) throws IOException {
        StreamUtils.writeInt(os, this.array.length);
        StreamUtils.writeBytes(os, this.array);
    }

    public void copy(BitMap src) {
        this.array = Arrays.copyOf(src.array, src.array.length);
    }

    public String toString() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int size = this.array.length << 3;
        for (int i = 0; i < size; ++i) {
            if (!this.getBit(i)) continue;
            list.add(i);
        }
        return ((Object)list).toString();
    }
}

