/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types.collections;

import java.util.NoSuchElementException;
import ru.m210projects.Build.Types.collections.ListNode;

public class LinkedList<T> {
    protected ListNode<T> first;
    protected ListNode<T> last;
    protected int size;

    public void addFirst(ListNode<T> newNode) {
        ListNode<T> f = this.first;
        this.first = newNode.link(this, null, f);
        if (f == null) {
            this.last = newNode;
        } else {
            f.prev = newNode;
        }
        ++this.size;
    }

    public void addLast(ListNode<T> newNode) {
        ListNode<T> l = this.last;
        this.last = newNode.link(this, l, null);
        if (l == null) {
            this.first = newNode;
        } else {
            l.next = newNode;
        }
        ++this.size;
    }

    public ListNode<T> removeFirst() {
        ListNode<T> f = this.first;
        if (f == null) {
            throw new NoSuchElementException();
        }
        this.unlink(f);
        return f;
    }

    public ListNode<T> removeLast() {
        ListNode<T> l = this.last;
        if (l == null) {
            throw new NoSuchElementException();
        }
        this.unlink(l);
        return l;
    }

    public boolean remove(ListNode<T> item) {
        if (this.size == 0) {
            return false;
        }
        if (item.equals(this.last)) {
            this.removeLast();
            return true;
        }
        if (item.equals(this.first)) {
            this.removeFirst();
            return true;
        }
        for (ListNode<T> node = this.first; node != null; node = node.getNext()) {
            if (!item.equals(node)) continue;
            this.unlink(node);
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    protected void unlink(ListNode<T> x) {
        x.parent = null;
        ListNode next = x.next;
        ListNode prev = x.prev;
        if (prev == null) {
            this.first = next;
        } else {
            prev.next = next;
            x.prev = null;
        }
        if (next == null) {
            this.last = prev;
        } else {
            next.prev = prev;
            x.next = null;
        }
        --this.size;
    }

    public ListNode<T> getFirst() {
        return this.first;
    }

    public ListNode<T> getLast() {
        return this.last;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        ListNode<T> x = this.first;
        while (x != null) {
            sb.append(x.index);
            if (x.next != null) {
                sb.append(',').append(' ');
            }
            x = x.next;
        }
        sb.append(']');
        return sb.toString();
    }

    public static <T> LinkedList<T> toImmutableList(LinkedList<T> list) {
        return new ImmutableList<T>(list);
    }

    private static class ImmutableList<T>
    extends LinkedList<T> {
        public ImmutableList(LinkedList<T> list) {
            this.first = list.getFirst();
            this.last = list.getLast();
            this.size = list.getSize();
        }

        @Override
        public void addFirst(ListNode<T> newNode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addLast(ListNode<T> newNode) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListNode<T> removeFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListNode<T> removeLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(ListNode<T> item) {
            throw new UnsupportedOperationException();
        }
    }
}

