/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import ru.m210projects.Build.filehandle.Entry;

public class BuildFileHandle
extends FileHandle {
    private final Entry entry;

    public BuildFileHandle(File file, Entry entry) {
        this.entry = entry;
        this.file = file;
        this.type = Files.FileType.Absolute;
    }

    @Override
    public String name() {
        return this.entry.getName();
    }

    @Override
    public String extension() {
        return this.entry.getExtension();
    }

    @Override
    public InputStream read() {
        try {
            return this.entry.getInputStream();
        }
        catch (IOException e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    @Override
    public ByteBuffer map(FileChannel.MapMode mode) {
        ByteBuffer bb = ByteBuffer.wrap(this.entry.getBytes());
        bb.order(ByteOrder.LITTLE_ENDIAN);
        return bb;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public long length() {
        return this.entry.getSize();
    }
}

