/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.AbsoluteFileEntry;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.fs.NotFoundEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.filehandle.rff.RffFile;
import ru.m210projects.Build.filehandle.zip.ZipEntry;
import ru.m210projects.Build.filehandle.zip.ZipFile;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Cache {
    protected final CacheResourceMap cacheResourceMap = new CacheResourceMap();

    public Cache(Directory gameDirectory) {
        CacheHolder.HOLDER_INSTANCE = this;
        this.addGroup(gameDirectory, CacheResourceMap.CachePriority.HIGH);
    }

    public static Cache getInstance() {
        return CacheHolder.HOLDER_INSTANCE;
    }

    public boolean addGroup(Group group, CacheResourceMap.CachePriority priority) {
        if (Objects.nonNull(group) && group.getSize() > 0) {
            this.cacheResourceMap.addGroup(group, priority);
            return true;
        }
        return false;
    }

    public boolean isGameDirectory(Group group) {
        if (!(group instanceof Directory.Game) || group.equals(Directory.DUMMY_DIRECTORY)) {
            return false;
        }
        return group.equals(this.getGameDirectory());
    }

    public void removeGroup(Group group) {
        this.cacheResourceMap.removeGroup(group);
    }

    @NotNull
    public Directory getGameDirectory() {
        Group group = this.cacheResourceMap.getGroup(0);
        if (group instanceof Directory.Game) {
            Directory directory = (Directory)group;
            if (directory == null) {
                Cache.$$$reportNull$$$0(0);
            }
            return directory;
        }
        Directory directory = Directory.DUMMY_DIRECTORY;
        if (directory == null) {
            Cache.$$$reportNull$$$0(1);
        }
        return directory;
    }

    public CacheResourceMap.CachePriority getPriority(Group group) {
        return this.cacheResourceMap.getPriority(group);
    }

    public boolean addGroup(Entry groupEntry, CacheResourceMap.CachePriority priority) {
        Group group = this.newGroup(groupEntry);
        return this.addGroup(group, priority);
    }

    @NotNull
    public Entry getEntry(Path path, boolean searchFirst) {
        int i;
        if (path.isAbsolute() && path.startsWith(this.getGameDirectory().getPath())) {
            path = this.getGameDirectory().getPath().relativize(path);
        }
        Entry entry = Directory.DUMMY_ENTRY;
        int n = i = searchFirst ? CacheResourceMap.CachePriority.HIGHEST.getLevel() : CacheResourceMap.CachePriority.NORMAL.getLevel();
        while (i >= CacheResourceMap.CachePriority.NORMAL.getLevel()) {
            for (ListNode node = this.cacheResourceMap.getFirst(i); node != null; node = node.getNext()) {
                Group group = (Group)node.get();
                entry = group.getEntry(path);
                if (!entry.exists()) continue;
                Entry entry2 = entry;
                if (entry2 == null) {
                    Cache.$$$reportNull$$$0(2);
                }
                return entry2;
            }
            --i;
        }
        if (!entry.exists()) {
            try {
                AbsoluteFileEntry fileEntry = new AbsoluteFileEntry(path);
                if (fileEntry.exists() && !fileEntry.isDirectory()) {
                    entry = fileEntry;
                }
            }
            catch (IOException ignored) {
                entry = new NotFoundEntry(path);
            }
        }
        FileEntry fileEntry = entry;
        if (fileEntry == null) {
            Cache.$$$reportNull$$$0(3);
        }
        return fileEntry;
    }

    @NotNull
    public Entry getEntry(String name, boolean searchFirst) {
        Entry entry = this.getEntry(FileUtils.getPath(name, new String[0]), searchFirst);
        if (entry == null) {
            Cache.$$$reportNull$$$0(4);
        }
        return entry;
    }

    @NotNull
    public Group newGroup(Entry entry) {
        Group group = Directory.DUMMY_DIRECTORY;
        GroupType type = this.getGroupType(entry);
        try {
            switch (type.ordinal()) {
                case 1: {
                    group = this.getGameDirectory().getDirectory((FileEntry)entry);
                    break;
                }
                case 3: {
                    group = new GrpFile(entry.getName(), entry::getInputStream);
                    break;
                }
                case 2: {
                    group = new RffFile(entry.getName(), entry::getInputStream);
                    break;
                }
                case 4: {
                    group = new ZipFile(entry.getName(), entry::getInputStream);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Directory directory = group;
        if (directory == null) {
            Cache.$$$reportNull$$$0(5);
        }
        return directory;
    }

    @NotNull
    public Group getGroup(String groupName) {
        Group group = this.cacheResourceMap.getGroup(groupName);
        if (group.getSize() > 0) {
            Group group2 = group;
            if (group2 == null) {
                Cache.$$$reportNull$$$0(6);
            }
            return group2;
        }
        Directory directory = Directory.DUMMY_DIRECTORY;
        if (directory == null) {
            Cache.$$$reportNull$$$0(7);
        }
        return directory;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public GroupType getGroupType(Entry entry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Group> getGroups() {
        ArrayList<Group> list = new ArrayList<Group>();
        for (int i = CacheResourceMap.CachePriority.NORMAL.getLevel(); i <= CacheResourceMap.CachePriority.HIGHEST.getLevel(); ++i) {
            for (ListNode node = this.cacheResourceMap.getFirst(i); node != null; node = node.getNext()) {
                list.add((Group)node.get());
            }
        }
        return list;
    }

    public void loadGdxDef(DefScript baseDef, String appdef, String resname) {
        URL url = Cache.class.getClassLoader().getResource(resname);
        if (url != null) {
            try (InputStream input = url.openConnection().getInputStream();){
                Entry def;
                ZipFile zipFile;
                int length;
                byte[] data = new byte[1024];
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                while ((length = input.read(data)) != -1) {
                    buffer.write(data, 0, length);
                }
                if (buffer.size() > 0 && this.addGroup(zipFile = new ZipFile(resname, () -> new ByteArrayInputStream(buffer.toByteArray())), CacheResourceMap.CachePriority.NORMAL) && (def = zipFile.getEntry(appdef)).exists() && baseDef.loadScript(resname, def)) {
                    for (Entry entry : zipFile.getEntries()) {
                        if (!(entry instanceof ZipEntry) || entry.isDirectory()) continue;
                        ((ZipEntry)entry).load();
                    }
                }
            }
            catch (Exception e) {
                Console.out.println("Can't load " + resname + ". " + e, OsdColor.RED);
                e.printStackTrace();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/m210projects/Build/filehandle/Cache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGameDirectory";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class CacheHolder {
        public static Cache HOLDER_INSTANCE;

        private CacheHolder() {
        }
    }

    public static enum GroupType {
        NONE,
        DIRECTORY,
        RFF,
        GRP,
        ZIP;

    }
}

