/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public interface Group
extends Iterable<Entry> {
    public List<Entry> getEntries();

    public int getSize();

    public String getName();

    public Entry getEntry(String var1);

    default public boolean isEmpty() {
        return this.getSize() == 0;
    }

    default public Entry getEntry(Path path) {
        return this.getEntry(path.toString());
    }

    @Override
    default public Iterator<Entry> iterator() {
        return this.getEntries().iterator();
    }

    @Override
    default public Spliterator<Entry> spliterator() {
        return this.getEntries().spliterator();
    }

    default public Stream<Entry> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public void extract(Path directory) throws NotDirectoryException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new NotDirectoryException(directory.toString());
        }
        for (Entry entry : this.getEntries()) {
            Path entryPath = directory.resolve(entry.getName());
            try {
                OutputStream os = Files.newOutputStream(entryPath, new OpenOption[0]);
                try {
                    StreamUtils.writeBytes(os, entry.getBytes());
                    Console.out.println("Extracted " + entryPath, OsdColor.GREEN);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

