/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.art;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import ru.m210projects.Build.Render.listeners.TileListener;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class DynamicArtEntry
extends ArtEntry {
    private final byte[] data;
    private final TileListener listener;

    public DynamicArtEntry(TileListener listener, int num, byte[] data, int width, int height, int flags) {
        super(() -> new ByteArrayInputStream(data), num, 0, width, height, flags);
        this.data = data;
        this.listener = listener;
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    public void copyData(byte[] data) {
        if (data.length < this.size) {
            throw new RuntimeException("Wrong tile data length");
        }
        System.arraycopy(data, 0, this.data, 0, this.size);
        this.invalidate();
    }

    public void clearData() {
        Arrays.fill(this.data, (byte)0);
        this.invalidate();
    }

    public void invalidate() {
        if (this.listener != null) {
            this.listener.onInvalidate(this.num);
        }
    }
}

