/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.filehandle.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.fs.NotFoundEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class Directory
implements Group {
    public static final FileEntry DUMMY_ENTRY = new NotFoundEntry("dummy");
    public static final Directory DUMMY_DIRECTORY = new Directory(){

        @Override
        public List<Entry> getEntries() {
            return new ArrayList<Entry>();
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public String getName() {
            return "dummy";
        }

        @Override
        @NotNull
        public FileEntry getEntry(String name) {
            FileEntry fileEntry = DUMMY_ENTRY;
            if (fileEntry == null) {
                1.$$$reportNull$$$0(0);
            }
            return fileEntry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Build/filehandle/fs/Directory$1", "getEntry"));
        }
    };
    final Map<String, FileEntry> entries = new HashMap<String, FileEntry>();
    private final Map<String, Directory> directories = new HashMap<String, Directory>();
    private final Path path;
    FileEntry directoryEntry = DUMMY_ENTRY;

    protected Directory() {
        this.path = FileEntry.DUMMY_PATH;
    }

    public Directory(Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            this.path = dir;
            stream.forEach(this::addEntry);
        }
    }

    public Directory(Path dir, boolean createIfNotExists) throws IOException {
        if (createIfNotExists && !Files.exists(dir, new LinkOption[0])) {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            this.path = dir;
            stream.forEach(this::addEntry);
        }
    }

    @Override
    public synchronized int getSize() {
        return this.entries.size();
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public synchronized List<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries.values());
    }

    public FileEntry getDirectoryEntry() {
        return this.directoryEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FileEntry getEntry(String name) {
        FileEntry entry;
        Objects.requireNonNull(name, "name");
        Directory directory = this;
        synchronized (directory) {
            entry = this.entries.getOrDefault(name.toUpperCase(), DUMMY_ENTRY);
            if (entry.isDirectory()) {
                this.addDirectory(entry);
            }
        }
        FileEntry fileEntry = entry;
        if (fileEntry == null) {
            Directory.$$$reportNull$$$0(0);
        }
        return fileEntry;
    }

    @Override
    public synchronized FileEntry getEntry(Path relPath) {
        Directory dir = this;
        FileEntry result = DUMMY_ENTRY;
        for (Path p : relPath) {
            FileEntry entry = dir.getEntry(p.toString());
            if (!entry.exists()) {
                return DUMMY_ENTRY;
            }
            if (entry.isDirectory()) {
                dir = dir.addDirectory(entry);
            }
            result = entry;
        }
        return result;
    }

    @NotNull
    public Directory getDirectory(FileEntry dirEntry) {
        Directory directory = DUMMY_DIRECTORY;
        if (dirEntry != null && dirEntry.isDirectory()) {
            if (this.path.equals(dirEntry.getPath())) {
                Directory directory2 = this;
                if (directory2 == null) {
                    Directory.$$$reportNull$$$0(1);
                }
                return directory2;
            }
            try {
                Path relPath = this.path.relativize(dirEntry.getPath());
                Directory dir = this;
                Iterator<Path> iterator = relPath.iterator();
                while (iterator.hasNext()) {
                    Map<String, Directory> directories = dir.directories;
                    Path p = iterator.next();
                    String key = p.toString().toUpperCase();
                    if (!directories.containsKey(key) && dir.entries.containsValue(dirEntry)) {
                        Directory subDir = new Directory(dirEntry.getPath());
                        subDir.directoryEntry = dirEntry;
                        directories.put(key, subDir);
                    }
                    dir = directories.getOrDefault(key, DUMMY_DIRECTORY);
                }
                directory = dir;
            }
            catch (Exception ignored) {
                Directory directory3 = DUMMY_DIRECTORY;
                if (directory3 == null) {
                    Directory.$$$reportNull$$$0(2);
                }
                return directory3;
            }
        }
        Directory directory4 = directory;
        if (directory4 == null) {
            Directory.$$$reportNull$$$0(3);
        }
        return directory4;
    }

    @NotNull
    private Directory addDirectory(FileEntry entry) {
        String key = entry.getName().toUpperCase();
        Directory directory = this.directories.computeIfAbsent(key, e -> {
            try {
                Directory subDir = new Directory(entry.getPath());
                subDir.directoryEntry = entry;
                return subDir;
            }
            catch (IOException iOException) {
                return DUMMY_DIRECTORY;
            }
        });
        if (directory == null) {
            Directory.$$$reportNull$$$0(4);
        }
        return directory;
    }

    public FileEntry addEntry(Path path) {
        FileEntry entry = this.newEntry(path);
        if (entry.exists()) {
            this.entries.put(entry.getName().toUpperCase(), entry);
            entry.setParent(this);
        }
        return entry;
    }

    private String[] getFileList() {
        if (this.path.equals(FileEntry.DUMMY_PATH)) {
            return new String[0];
        }
        return this.path.toFile().list();
    }

    private boolean isInvalid() {
        int fileCount = this.entries.size();
        String[] list = this.getFileList();
        if (list != null) {
            if (fileCount != list.length) {
                return true;
            }
            return Arrays.stream(list).anyMatch(e -> !this.entries.containsKey(e.toUpperCase(Locale.ROOT)));
        }
        return false;
    }

    public boolean revalidate() {
        int files = this.entries.size();
        if (this.isInvalid()) {
            this.directories.clear();
            this.entries.clear();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.path);){
                stream.forEach(this::addEntry);
            }
            catch (IOException e) {
                Console.out.println(String.format("Directory %s invalidate failed!", this.path), OsdColor.RED);
            }
            return true;
        }
        return files != this.entries.size();
    }

    @NotNull
    private FileEntry newEntry(Path path) {
        try {
            return new FileEntry(path);
        }
        catch (NoSuchFileException e) {
            Console.out.println(String.format("Path \"%s\" is not found.", path), OsdColor.RED);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileEntry fileEntry = DUMMY_ENTRY;
        if (fileEntry == null) {
            Directory.$$$reportNull$$$0(5);
        }
        return fileEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Directory)) {
            return false;
        }
        Directory directory = (Directory)o;
        return Objects.equals(this.path, directory.path);
    }

    public int hashCode() {
        return Objects.hash(this.path);
    }

    public String toString() {
        return this.path.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ru/m210projects/Build/filehandle/fs/Directory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntry";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newEntry";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Game
    extends Directory {
        public Game(Path dir) throws IOException {
            super(dir);
            this.directoryEntry = new FileEntry(dir, dir.getFileName().toString(), 0L);
            this.directoryEntry.setParent(this);
            this.directoryEntry.physicalDirectory = this;
        }
    }
}

